/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest.client.gui.chest;

import cpw.mods.ironchest.common.blocks.chest.IronChestType;
import cpw.mods.ironchest.common.gui.chest.ContainerIronChest;
import cpw.mods.ironchest.common.tileentity.chest.TileEntityIronChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

public class GUIChest
extends GuiContainer {
    private GUI type;

    private GUIChest(GUI type, IInventory player, IInventory chest) {
        super(type.makeContainer(player, chest));
        this.type = type;
        this.field_146999_f = type.xSize;
        this.field_147000_g = type.ySize;
        this.field_146291_p = false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(((GUI)this.type).guiResourceList.location);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public static enum GUI {
        IRON(184, 202, ResourceList.IRON, IronChestType.IRON),
        GOLD(184, 256, ResourceList.GOLD, IronChestType.GOLD),
        DIAMOND(238, 256, ResourceList.DIAMOND, IronChestType.DIAMOND),
        COPPER(184, 184, ResourceList.COPPER, IronChestType.COPPER),
        SILVER(184, 238, ResourceList.SILVER, IronChestType.SILVER),
        CRYSTAL(238, 256, ResourceList.DIAMOND, IronChestType.CRYSTAL),
        OBSIDIAN(238, 256, ResourceList.DIAMOND, IronChestType.OBSIDIAN),
        DIRTCHEST9000(184, 184, ResourceList.DIRT, IronChestType.DIRTCHEST9000);

        private int xSize;
        private int ySize;
        private ResourceList guiResourceList;
        private IronChestType mainType;

        private GUI(int xSize, int ySize, ResourceList guiResourceList, IronChestType mainType) {
            this.xSize = xSize;
            this.ySize = ySize;
            this.guiResourceList = guiResourceList;
            this.mainType = mainType;
        }

        protected Container makeContainer(IInventory player, IInventory chest) {
            return new ContainerIronChest(player, chest, this.mainType, this.xSize, this.ySize);
        }

        public static GUIChest buildGUI(IronChestType type, IInventory playerInventory, TileEntityIronChest chestInventory) {
            return new GUIChest(GUI.values()[chestInventory.getType().ordinal()], playerInventory, (IInventory)chestInventory);
        }
    }

    public static enum ResourceList {
        IRON(new ResourceLocation("ironchest", "textures/gui/iron_container.png")),
        COPPER(new ResourceLocation("ironchest", "textures/gui/copper_container.png")),
        SILVER(new ResourceLocation("ironchest", "textures/gui/silver_container.png")),
        GOLD(new ResourceLocation("ironchest", "textures/gui/gold_container.png")),
        DIAMOND(new ResourceLocation("ironchest", "textures/gui/diamond_container.png")),
        DIRT(new ResourceLocation("ironchest", "textures/gui/dirt_container.png"));

        public final ResourceLocation location;

        private ResourceList(ResourceLocation loc) {
            this.location = loc;
        }
    }
}

