/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.utils.handlers;

import java.util.HashMap;
import java.util.Map;
import net.hypherionmc.toggletorch.sounds.NeonHum;
import net.hypherionmc.toggletorch.tileentities.TileNeonSign;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SoundHandler {
    private static final Map<BlockPos, PositionedSound> sounds = new HashMap<BlockPos, PositionedSound>();
    public static SoundEvent NEON_HUM;

    public static void registerSounds() {
        NEON_HUM = SoundHandler.registerSound("tile.neon_sign.hum");
    }

    public static SoundEvent registerSound(String name) {
        ResourceLocation location = new ResourceLocation("hmctt", name);
        SoundEvent event = new SoundEvent(location);
        event.setRegistryName(name);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)event);
        return event;
    }

    public static void stopSound(TileEntity tile, BlockPos pos) {
        if (sounds.containsKey(pos)) {
            PositionedSound movingSound = sounds.get(pos);
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)movingSound);
            sounds.remove(pos);
        }
    }

    public static void playSound(TileEntity tile, BlockPos pos, PositionedSound sound) {
        SoundHandler.stopSound(tile, pos);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
        sounds.put(pos, sound);
    }

    public static boolean isLoopPlaying(World worldObj, BlockPos pos) {
        PositionedSound movingSound = sounds.get(pos);
        return Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)movingSound);
    }

    public static void playLoop(TileNeonSign tile, BlockPos pos) {
        NeonHum sound = new NeonHum(tile);
        SoundHandler.playSound(tile, pos, sound);
    }
}

