/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.utils.handlers;

import net.hypherionmc.toggletorch.Main;
import net.hypherionmc.toggletorch.init.HLBlocks;
import net.hypherionmc.toggletorch.init.HLItems;
import net.hypherionmc.toggletorch.utils.IHasModel;
import net.hypherionmc.toggletorch.utils.handlers.GuiHandler;
import net.hypherionmc.toggletorch.utils.handlers.TileEntityHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistryHandler {
    public static TextureAtlasSprite textureAtlasSprite;
    public static TextureAtlasSprite textureAtlasSpriteHD;
    public static TextureAtlasSprite texturFog;
    public static TextureAtlasSprite lava;

    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        Main.logger.info("Registering Items");
        event.getRegistry().registerAll((IForgeRegistryEntry[])HLItems.ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        Main.logger.info("Registering Blocks");
        event.getRegistry().registerAll((IForgeRegistryEntry[])HLBlocks.BLOCKS.toArray(new Block[0]));
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Item item : HLItems.ITEMS) {
            if (!(item instanceof IHasModel)) continue;
            ((IHasModel)item).registerModels();
        }
        for (Block block : HLBlocks.BLOCKS) {
            if (!(block instanceof IHasModel)) continue;
            ((IHasModel)block).registerModels();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerParticleMap(TextureStitchEvent.Pre event) {
        TextureMap map = event.getMap();
        textureAtlasSprite = map.func_174942_a(new ResourceLocation("hmctt", "particles/flame_base"));
        textureAtlasSpriteHD = map.func_174942_a(new ResourceLocation("hmctt", "particles/hd_flame_base"));
        texturFog = map.func_174942_a(new ResourceLocation("hmctt", "effects/fake_fog"));
    }

    public static void init() {
        TileEntityHandler.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Main.instance, (IGuiHandler)new GuiHandler());
    }
}

