/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.utils.dyes;

import net.hypherionmc.toggletorch.HyperLightingConfig;
import net.hypherionmc.toggletorch.blocks.BlockCandle;
import net.hypherionmc.toggletorch.blocks.BlockGlowstone;
import net.hypherionmc.toggletorch.blocks.BlockLantern;
import net.hypherionmc.toggletorch.blocks.BlockTikiTorch;
import net.hypherionmc.toggletorch.blocks.BlockToggleTorch;
import net.hypherionmc.toggletorch.blocks.ColoredRedstoneLamp;
import net.hypherionmc.toggletorch.init.HLBlocks;
import net.hypherionmc.toggletorch.particles.ParticleEnum;
import net.hypherionmc.toggletorch.utils.dyes.IDyeAble;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DyeUtil {
    public static void doDyeCheck(World world, IBlockState blockState, ItemStack stack, BlockPos pos) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemDye && blockState != null && blockState.func_177230_c() instanceof IDyeAble) {
            if (blockState.func_177230_c() instanceof BlockToggleTorch && HyperLightingConfig.torchConfig.dyable) {
                ((IDyeAble)blockState.func_177230_c()).onDye(world, DyeUtil.getTorchColor(DyeUtil.getDyeColor(stack), blockState), pos);
            } else if (blockState.func_177230_c() instanceof BlockLantern && HyperLightingConfig.lanternConfig.dyable) {
                ((IDyeAble)blockState.func_177230_c()).onDye(world, DyeUtil.getLanternColor(DyeUtil.getDyeColor(stack), blockState), pos);
            } else if (blockState.func_177230_c() instanceof BlockCandle && HyperLightingConfig.candleConfig.dyable) {
                ((IDyeAble)blockState.func_177230_c()).onDye(world, DyeUtil.getCandleColor(DyeUtil.getDyeColor(stack), blockState), pos);
            } else if (blockState.func_177230_c() instanceof BlockTikiTorch && HyperLightingConfig.tikiConfig.dyable) {
                ((IDyeAble)blockState.func_177230_c()).onDye(world, DyeUtil.getTikiColor(DyeUtil.getDyeColor(stack), blockState), pos);
            } else if (blockState.func_177230_c() instanceof ColoredRedstoneLamp && HyperLightingConfig.redstoneConfig.dyable) {
                ((IDyeAble)blockState.func_177230_c()).onDye(world, DyeUtil.getRedstoneColor(DyeUtil.getDyeColor(stack), blockState), pos);
            } else if (blockState.func_177230_c() instanceof BlockGlowstone && HyperLightingConfig.glowstoneConfig.dyable) {
                ((IDyeAble)blockState.func_177230_c()).onDye(world, DyeUtil.getGlowstoneColor(DyeUtil.getDyeColor(stack), blockState), pos);
            }
        }
    }

    private static IBlockState getGlowstoneColor(DyeColor dyeColor, IBlockState blockState) {
        switch (dyeColor) {
            case ORANGE: {
                return HLBlocks.BLOCK_GLOWSTONE.func_176223_P();
            }
            case GRAY: {
                return HLBlocks.BLOCK_GLOWSTONE_GRAY.func_176223_P();
            }
            case LIGHT_GRAY: {
                return HLBlocks.BLOCK_GLOWSTONE_LIGHTGRAY.func_176223_P();
            }
            case BLACK: {
                return HLBlocks.BLOCK_GLOWSTONE_BLACK.func_176223_P();
            }
            case BROWN: {
                return HLBlocks.BLOCK_GLOWSTONE_BROWN.func_176223_P();
            }
            case PURPLE: {
                return HLBlocks.BLOCK_GLOWSTONE_PURPLE.func_176223_P();
            }
            case CYAN: {
                return HLBlocks.BLOCK_GLOWSTONE_BLUE.func_176223_P();
            }
            case GREEN: {
                return HLBlocks.BLOCK_GLOWSTONE_GREEN.func_176223_P();
            }
            case LIME: {
                return HLBlocks.BLOCK_GLOWSTONE_LIME.func_176223_P();
            }
            case YELLOW: {
                return HLBlocks.BLOCK_GLOWSTONE_YELLOW.func_176223_P();
            }
            case PINK: {
                return HLBlocks.BLOCK_GLOWSTONE_PINK.func_176223_P();
            }
            case RED: {
                return HLBlocks.BLOCK_GLOWSTONE_RED.func_176223_P();
            }
            case WHITE: {
                return HLBlocks.BLOCK_GLOWSTONE_WHITE.func_176223_P();
            }
        }
        return blockState;
    }

    private static DyeColor getDyeColor(ItemStack dye) {
        switch (EnumDyeColor.func_176766_a((int)dye.func_77952_i())) {
            case WHITE: {
                return DyeColor.WHITE;
            }
            case RED: {
                return DyeColor.RED;
            }
            case PINK: 
            case MAGENTA: {
                return DyeColor.PINK;
            }
            case YELLOW: {
                return DyeColor.YELLOW;
            }
            case LIME: {
                return DyeColor.LIME;
            }
            case GREEN: {
                return DyeColor.GREEN;
            }
            case LIGHT_BLUE: 
            case CYAN: 
            case BLUE: {
                return DyeColor.CYAN;
            }
            case PURPLE: {
                return DyeColor.PURPLE;
            }
            case BROWN: {
                return DyeColor.BROWN;
            }
            case GRAY: {
                return DyeColor.GRAY;
            }
            case BLACK: {
                return DyeColor.BLACK;
            }
            case SILVER: {
                return DyeColor.LIGHT_GRAY;
            }
        }
        return DyeColor.ORANGE;
    }

    public static int getDyeItem(ParticleEnum color) {
        switch (color) {
            case WHITE_FLAME: {
                return 15;
            }
            case RED_FLAME: {
                return 1;
            }
            case PINK_FLAME: {
                return 13;
            }
            case YELLOW_FLAME: {
                return 11;
            }
            case LIME_FLAME: {
                return 10;
            }
            case GREEN_FLAME: {
                return 2;
            }
            case BLUE_FLAME: {
                return 6;
            }
            case PURPLE_FLAME: {
                return 5;
            }
            case BROWN_FLAME: {
                return 3;
            }
            case GRAY_FLAME: {
                return 8;
            }
            case BLACK_FLAME: {
                return 0;
            }
            case LIGHT_GRAY_FLAME: {
                return 7;
            }
        }
        return 14;
    }

    private static IBlockState getTorchColor(DyeColor color, IBlockState blockState) {
        switch (color) {
            case ORANGE: {
                return HLBlocks.BLOCK_TORCH.func_176223_P().func_177226_a((IProperty)BlockToggleTorch.FACING, blockState.func_177229_b((IProperty)BlockToggleTorch.FACING)).func_177226_a((IProperty)BlockToggleTorch.POWERED, blockState.func_177229_b((IProperty)BlockToggleTorch.POWERED));
            }
            case GRAY: {
                return HLBlocks.BLOCK_GRAY_TORCH.func_176223_P().func_177226_a((IProperty)BlockToggleTorch.FACING, blockState.func_177229_b((IProperty)BlockToggleTorch.FACING)).func_177226_a((IProperty)BlockToggleTorch.POWERED, blockState.func_177229_b((IProperty)BlockToggleTorch.POWERED));
            }
            case LIGHT_GRAY: {
                return HLBlocks.BLOCK_LIGHTGRAY_TORCH.func_176223_P().func_177226_a((IProperty)BlockToggleTorch.FACING, blockState.func_177229_b((IProperty)BlockToggleTorch.FACING)).func_177226_a((IProperty)BlockToggleTorch.POWERED, blockState.func_177229_b((IProperty)BlockToggleTorch.POWERED));
            }
            case BLACK: {
                return HLBlocks.BLOCK_BLACK_TORCH.func_176223_P().func_177226_a((IProperty)BlockToggleTorch.FACING, blockState.func_177229_b((IProperty)BlockToggleTorch.FACING)).func_177226_a((IProperty)BlockToggleTorch.POWERED, blockState.func_177229_b((IProperty)BlockToggleTorch.POWERED));
            }
            case BROWN: {
                return HLBlocks.BLOCK_BROWN_TORCH.func_176223_P().func_177226_a((IProperty)BlockToggleTorch.FACING, blockState.func_177229_b((IProperty)BlockToggleTorch.FACING)).func_177226_a((IProperty)BlockToggleTorch.POWERED, blockState.func_177229_b((IProperty)BlockToggleTorch.POWERED));
            }
            case PURPLE: {
                return HLBlocks.BLOCK_PURPLE_TORCH.func_176223_P().func_177226_a((IProperty)BlockToggleTorch.FACING, blockState.func_177229_b((IProperty)BlockToggleTorch.FACING)).func_177226_a((IProperty)BlockToggleTorch.POWERED, blockState.func_177229_b((IProperty)BlockToggleTorch.POWERED));
            }
            case CYAN: {
                return HLBlocks.BLOCK_BLUE_TORCH.func_176223_P().func_177226_a((IProperty)BlockToggleTorch.FACING, blockState.func_177229_b((IProperty)BlockToggleTorch.FACING)).func_177226_a((IProperty)BlockToggleTorch.POWERED, blockState.func_177229_b((IProperty)BlockToggleTorch.POWERED));
            }
            case GREEN: {
                return HLBlocks.BLOCK_GREEN_TORCH.func_176223_P().func_177226_a((IProperty)BlockToggleTorch.FACING, blockState.func_177229_b((IProperty)BlockToggleTorch.FACING)).func_177226_a((IProperty)BlockToggleTorch.POWERED, blockState.func_177229_b((IProperty)BlockToggleTorch.POWERED));
            }
            case LIME: {
                return HLBlocks.BLOCK_LIME_TORCH.func_176223_P().func_177226_a((IProperty)BlockToggleTorch.FACING, blockState.func_177229_b((IProperty)BlockToggleTorch.FACING)).func_177226_a((IProperty)BlockToggleTorch.POWERED, blockState.func_177229_b((IProperty)BlockToggleTorch.POWERED));
            }
            case YELLOW: {
                return HLBlocks.BLOCK_YELLOW_TORCH.func_176223_P().func_177226_a((IProperty)BlockToggleTorch.FACING, blockState.func_177229_b((IProperty)BlockToggleTorch.FACING)).func_177226_a((IProperty)BlockToggleTorch.POWERED, blockState.func_177229_b((IProperty)BlockToggleTorch.POWERED));
            }
            case PINK: {
                return HLBlocks.BLOCK_PINK_TORCH.func_176223_P().func_177226_a((IProperty)BlockToggleTorch.FACING, blockState.func_177229_b((IProperty)BlockToggleTorch.FACING)).func_177226_a((IProperty)BlockToggleTorch.POWERED, blockState.func_177229_b((IProperty)BlockToggleTorch.POWERED));
            }
            case RED: {
                return HLBlocks.BLOCK_RED_TORCH.func_176223_P().func_177226_a((IProperty)BlockToggleTorch.FACING, blockState.func_177229_b((IProperty)BlockToggleTorch.FACING)).func_177226_a((IProperty)BlockToggleTorch.POWERED, blockState.func_177229_b((IProperty)BlockToggleTorch.POWERED));
            }
            case WHITE: {
                return HLBlocks.BLOCK_WHITE_TORCH.func_176223_P().func_177226_a((IProperty)BlockToggleTorch.FACING, blockState.func_177229_b((IProperty)BlockToggleTorch.FACING)).func_177226_a((IProperty)BlockToggleTorch.POWERED, blockState.func_177229_b((IProperty)BlockToggleTorch.POWERED));
            }
        }
        return blockState;
    }

    private static IBlockState getLanternColor(DyeColor color, IBlockState blockState) {
        switch (color) {
            case ORANGE: {
                return HLBlocks.BLOCK_LANTERN.func_176223_P().func_177226_a((IProperty)BlockLantern.FACING, blockState.func_177229_b((IProperty)BlockLantern.FACING)).func_177226_a((IProperty)BlockLantern.POWERED, blockState.func_177229_b((IProperty)BlockLantern.POWERED));
            }
            case GRAY: {
                return HLBlocks.BLOCK_LANTERN_GRAY.func_176223_P().func_177226_a((IProperty)BlockLantern.FACING, blockState.func_177229_b((IProperty)BlockLantern.FACING)).func_177226_a((IProperty)BlockLantern.POWERED, blockState.func_177229_b((IProperty)BlockLantern.POWERED));
            }
            case LIGHT_GRAY: {
                return HLBlocks.BLOCK_LANTERN_LIGHTGRAY.func_176223_P().func_177226_a((IProperty)BlockLantern.FACING, blockState.func_177229_b((IProperty)BlockLantern.FACING)).func_177226_a((IProperty)BlockLantern.POWERED, blockState.func_177229_b((IProperty)BlockLantern.POWERED));
            }
            case BLACK: {
                return HLBlocks.BLOCK_LANTERN_BLACK.func_176223_P().func_177226_a((IProperty)BlockLantern.FACING, blockState.func_177229_b((IProperty)BlockLantern.FACING)).func_177226_a((IProperty)BlockLantern.POWERED, blockState.func_177229_b((IProperty)BlockLantern.POWERED));
            }
            case BROWN: {
                return HLBlocks.BLOCK_LANTERN_BROWN.func_176223_P().func_177226_a((IProperty)BlockLantern.FACING, blockState.func_177229_b((IProperty)BlockLantern.FACING)).func_177226_a((IProperty)BlockLantern.POWERED, blockState.func_177229_b((IProperty)BlockLantern.POWERED));
            }
            case PURPLE: {
                return HLBlocks.BLOCK_LANTERN_PURPLE.func_176223_P().func_177226_a((IProperty)BlockLantern.FACING, blockState.func_177229_b((IProperty)BlockLantern.FACING)).func_177226_a((IProperty)BlockLantern.POWERED, blockState.func_177229_b((IProperty)BlockLantern.POWERED));
            }
            case CYAN: {
                return HLBlocks.BLOCK_LANTERN_BLUE.func_176223_P().func_177226_a((IProperty)BlockLantern.FACING, blockState.func_177229_b((IProperty)BlockLantern.FACING)).func_177226_a((IProperty)BlockLantern.POWERED, blockState.func_177229_b((IProperty)BlockLantern.POWERED));
            }
            case GREEN: {
                return HLBlocks.BLOCK_LANTERN_GREEN.func_176223_P().func_177226_a((IProperty)BlockLantern.FACING, blockState.func_177229_b((IProperty)BlockLantern.FACING)).func_177226_a((IProperty)BlockLantern.POWERED, blockState.func_177229_b((IProperty)BlockLantern.POWERED));
            }
            case LIME: {
                return HLBlocks.BLOCK_LANTERN_LIME.func_176223_P().func_177226_a((IProperty)BlockLantern.FACING, blockState.func_177229_b((IProperty)BlockLantern.FACING)).func_177226_a((IProperty)BlockLantern.POWERED, blockState.func_177229_b((IProperty)BlockLantern.POWERED));
            }
            case YELLOW: {
                return HLBlocks.BLOCK_LANTERN_YELLOW.func_176223_P().func_177226_a((IProperty)BlockLantern.FACING, blockState.func_177229_b((IProperty)BlockLantern.FACING)).func_177226_a((IProperty)BlockLantern.POWERED, blockState.func_177229_b((IProperty)BlockLantern.POWERED));
            }
            case PINK: {
                return HLBlocks.BLOCK_LANTERN_PINK.func_176223_P().func_177226_a((IProperty)BlockLantern.FACING, blockState.func_177229_b((IProperty)BlockLantern.FACING)).func_177226_a((IProperty)BlockLantern.POWERED, blockState.func_177229_b((IProperty)BlockLantern.POWERED));
            }
            case RED: {
                return HLBlocks.BLOCK_LANTERN_RED.func_176223_P().func_177226_a((IProperty)BlockLantern.FACING, blockState.func_177229_b((IProperty)BlockLantern.FACING)).func_177226_a((IProperty)BlockLantern.POWERED, blockState.func_177229_b((IProperty)BlockLantern.POWERED));
            }
            case WHITE: {
                return HLBlocks.BLOCK_LANTERN_WHITE.func_176223_P().func_177226_a((IProperty)BlockLantern.FACING, blockState.func_177229_b((IProperty)BlockLantern.FACING)).func_177226_a((IProperty)BlockLantern.POWERED, blockState.func_177229_b((IProperty)BlockLantern.POWERED));
            }
        }
        return blockState;
    }

    private static IBlockState getCandleColor(DyeColor color, IBlockState blockState) {
        switch (color) {
            case ORANGE: {
                return HLBlocks.BLOCK_CANDLE.func_176223_P().func_177226_a((IProperty)BlockCandle.FACING, blockState.func_177229_b((IProperty)BlockCandle.FACING)).func_177226_a((IProperty)BlockCandle.POWERED, blockState.func_177229_b((IProperty)BlockCandle.POWERED));
            }
            case GRAY: {
                return HLBlocks.BLOCK_CANDLE_GRAY.func_176223_P().func_177226_a((IProperty)BlockCandle.FACING, blockState.func_177229_b((IProperty)BlockCandle.FACING)).func_177226_a((IProperty)BlockCandle.POWERED, blockState.func_177229_b((IProperty)BlockCandle.POWERED));
            }
            case LIGHT_GRAY: {
                return HLBlocks.BLOCK_CANDLE_LIGHTGRAY.func_176223_P().func_177226_a((IProperty)BlockCandle.FACING, blockState.func_177229_b((IProperty)BlockCandle.FACING)).func_177226_a((IProperty)BlockCandle.POWERED, blockState.func_177229_b((IProperty)BlockCandle.POWERED));
            }
            case BLACK: {
                return HLBlocks.BLOCK_CANDLE_BLACK.func_176223_P().func_177226_a((IProperty)BlockCandle.FACING, blockState.func_177229_b((IProperty)BlockCandle.FACING)).func_177226_a((IProperty)BlockCandle.POWERED, blockState.func_177229_b((IProperty)BlockCandle.POWERED));
            }
            case BROWN: {
                return HLBlocks.BLOCK_CANDLE_BROWN.func_176223_P().func_177226_a((IProperty)BlockCandle.FACING, blockState.func_177229_b((IProperty)BlockCandle.FACING)).func_177226_a((IProperty)BlockCandle.POWERED, blockState.func_177229_b((IProperty)BlockCandle.POWERED));
            }
            case PURPLE: {
                return HLBlocks.BLOCK_CANDLE_PURPLE.func_176223_P().func_177226_a((IProperty)BlockCandle.FACING, blockState.func_177229_b((IProperty)BlockCandle.FACING)).func_177226_a((IProperty)BlockCandle.POWERED, blockState.func_177229_b((IProperty)BlockCandle.POWERED));
            }
            case CYAN: {
                return HLBlocks.BLOCK_CANDLE_BLUE.func_176223_P().func_177226_a((IProperty)BlockCandle.FACING, blockState.func_177229_b((IProperty)BlockCandle.FACING)).func_177226_a((IProperty)BlockCandle.POWERED, blockState.func_177229_b((IProperty)BlockCandle.POWERED));
            }
            case GREEN: {
                return HLBlocks.BLOCK_CANDLE_GREEN.func_176223_P().func_177226_a((IProperty)BlockCandle.FACING, blockState.func_177229_b((IProperty)BlockCandle.FACING)).func_177226_a((IProperty)BlockCandle.POWERED, blockState.func_177229_b((IProperty)BlockCandle.POWERED));
            }
            case LIME: {
                return HLBlocks.BLOCK_CANDLE_LIME.func_176223_P().func_177226_a((IProperty)BlockCandle.FACING, blockState.func_177229_b((IProperty)BlockCandle.FACING)).func_177226_a((IProperty)BlockCandle.POWERED, blockState.func_177229_b((IProperty)BlockCandle.POWERED));
            }
            case YELLOW: {
                return HLBlocks.BLOCK_CANDLE_YELLOW.func_176223_P().func_177226_a((IProperty)BlockCandle.FACING, blockState.func_177229_b((IProperty)BlockCandle.FACING)).func_177226_a((IProperty)BlockCandle.POWERED, blockState.func_177229_b((IProperty)BlockCandle.POWERED));
            }
            case PINK: {
                return HLBlocks.BLOCK_CANDLE_PINK.func_176223_P().func_177226_a((IProperty)BlockCandle.FACING, blockState.func_177229_b((IProperty)BlockCandle.FACING)).func_177226_a((IProperty)BlockCandle.POWERED, blockState.func_177229_b((IProperty)BlockCandle.POWERED));
            }
            case RED: {
                return HLBlocks.BLOCK_CANDLE_RED.func_176223_P().func_177226_a((IProperty)BlockCandle.FACING, blockState.func_177229_b((IProperty)BlockCandle.FACING)).func_177226_a((IProperty)BlockCandle.POWERED, blockState.func_177229_b((IProperty)BlockCandle.POWERED));
            }
            case WHITE: {
                return HLBlocks.BLOCK_CANDLE_WHITE.func_176223_P().func_177226_a((IProperty)BlockCandle.FACING, blockState.func_177229_b((IProperty)BlockCandle.FACING)).func_177226_a((IProperty)BlockCandle.POWERED, blockState.func_177229_b((IProperty)BlockCandle.POWERED));
            }
        }
        return blockState;
    }

    private static IBlockState getRedstoneColor(DyeColor color, IBlockState blockState) {
        switch (color) {
            case ORANGE: {
                return HLBlocks.COLORED_REDSTONE.func_176223_P().func_177226_a((IProperty)ColoredRedstoneLamp.POWERED, blockState.func_177229_b((IProperty)ColoredRedstoneLamp.POWERED));
            }
            case GRAY: {
                return HLBlocks.COLORED_REDSTONE_GRAY.func_176223_P().func_177226_a((IProperty)ColoredRedstoneLamp.POWERED, blockState.func_177229_b((IProperty)ColoredRedstoneLamp.POWERED));
            }
            case LIGHT_GRAY: {
                return HLBlocks.COLORED_REDSTONE_LIGHT_GRAY.func_176223_P().func_177226_a((IProperty)ColoredRedstoneLamp.POWERED, blockState.func_177229_b((IProperty)ColoredRedstoneLamp.POWERED));
            }
            case BLACK: {
                return HLBlocks.COLORED_REDSTONE_BLACK.func_176223_P().func_177226_a((IProperty)ColoredRedstoneLamp.POWERED, blockState.func_177229_b((IProperty)ColoredRedstoneLamp.POWERED));
            }
            case BROWN: {
                return HLBlocks.COLORED_REDSTONE_BROWN.func_176223_P().func_177226_a((IProperty)ColoredRedstoneLamp.POWERED, blockState.func_177229_b((IProperty)ColoredRedstoneLamp.POWERED));
            }
            case PURPLE: {
                return HLBlocks.COLORED_REDSTONE_PURPLE.func_176223_P().func_177226_a((IProperty)ColoredRedstoneLamp.POWERED, blockState.func_177229_b((IProperty)ColoredRedstoneLamp.POWERED));
            }
            case CYAN: {
                return HLBlocks.COLORED_REDSTONE_BLUE.func_176223_P().func_177226_a((IProperty)ColoredRedstoneLamp.POWERED, blockState.func_177229_b((IProperty)ColoredRedstoneLamp.POWERED));
            }
            case GREEN: {
                return HLBlocks.COLORED_REDSTONE_GREEN.func_176223_P().func_177226_a((IProperty)ColoredRedstoneLamp.POWERED, blockState.func_177229_b((IProperty)ColoredRedstoneLamp.POWERED));
            }
            case LIME: {
                return HLBlocks.COLORED_REDSTONE_LIME.func_176223_P().func_177226_a((IProperty)ColoredRedstoneLamp.POWERED, blockState.func_177229_b((IProperty)ColoredRedstoneLamp.POWERED));
            }
            case YELLOW: {
                return HLBlocks.COLORED_REDSTONE_YELLOW.func_176223_P().func_177226_a((IProperty)ColoredRedstoneLamp.POWERED, blockState.func_177229_b((IProperty)ColoredRedstoneLamp.POWERED));
            }
            case PINK: {
                return HLBlocks.COLORED_REDSTONE_PINK.func_176223_P().func_177226_a((IProperty)ColoredRedstoneLamp.POWERED, blockState.func_177229_b((IProperty)ColoredRedstoneLamp.POWERED));
            }
            case RED: {
                return HLBlocks.COLORED_REDSTONE_RED.func_176223_P().func_177226_a((IProperty)ColoredRedstoneLamp.POWERED, blockState.func_177229_b((IProperty)ColoredRedstoneLamp.POWERED));
            }
            case WHITE: {
                return HLBlocks.COLORED_REDSTONE_WHITE.func_176223_P().func_177226_a((IProperty)ColoredRedstoneLamp.POWERED, blockState.func_177229_b((IProperty)ColoredRedstoneLamp.POWERED));
            }
        }
        return blockState;
    }

    private static IBlockState getTikiColor(DyeColor color, IBlockState blockState) {
        switch (color) {
            case ORANGE: {
                return HLBlocks.BLOCK_TIKI_TORCH.func_176223_P().func_177226_a((IProperty)BlockTikiTorch.POWERED, blockState.func_177229_b((IProperty)BlockTikiTorch.POWERED));
            }
            case GRAY: {
                return HLBlocks.BLOCK_TIKI_TORCH_GRAY.func_176223_P().func_177226_a((IProperty)BlockTikiTorch.POWERED, blockState.func_177229_b((IProperty)BlockTikiTorch.POWERED));
            }
            case LIGHT_GRAY: {
                return HLBlocks.BLOCK_TIKI_TORCH_LIGHTGRAY.func_176223_P().func_177226_a((IProperty)BlockTikiTorch.POWERED, blockState.func_177229_b((IProperty)BlockTikiTorch.POWERED));
            }
            case BLACK: {
                return HLBlocks.BLOCK_TIKI_TORCH_BLACK.func_176223_P().func_177226_a((IProperty)BlockTikiTorch.POWERED, blockState.func_177229_b((IProperty)BlockTikiTorch.POWERED));
            }
            case BROWN: {
                return HLBlocks.BLOCK_TIKI_TORCH_BROWN.func_176223_P().func_177226_a((IProperty)BlockTikiTorch.POWERED, blockState.func_177229_b((IProperty)BlockTikiTorch.POWERED));
            }
            case PURPLE: {
                return HLBlocks.BLOCK_TIKI_TORCH_PURPLE.func_176223_P().func_177226_a((IProperty)BlockTikiTorch.POWERED, blockState.func_177229_b((IProperty)BlockTikiTorch.POWERED));
            }
            case CYAN: {
                return HLBlocks.BLOCK_TIKI_TORCH_BLUE.func_176223_P().func_177226_a((IProperty)BlockTikiTorch.POWERED, blockState.func_177229_b((IProperty)BlockTikiTorch.POWERED));
            }
            case GREEN: {
                return HLBlocks.BLOCK_TIKI_TORCH_GREEN.func_176223_P().func_177226_a((IProperty)BlockTikiTorch.POWERED, blockState.func_177229_b((IProperty)BlockTikiTorch.POWERED));
            }
            case LIME: {
                return HLBlocks.BLOCK_TIKI_TORCH_LIME.func_176223_P().func_177226_a((IProperty)BlockTikiTorch.POWERED, blockState.func_177229_b((IProperty)BlockTikiTorch.POWERED));
            }
            case YELLOW: {
                return HLBlocks.BLOCK_TIKI_TORCH_YELLOW.func_176223_P().func_177226_a((IProperty)BlockTikiTorch.POWERED, blockState.func_177229_b((IProperty)BlockTikiTorch.POWERED));
            }
            case PINK: {
                return HLBlocks.BLOCK_TIKI_TORCH_PINK.func_176223_P().func_177226_a((IProperty)BlockTikiTorch.POWERED, blockState.func_177229_b((IProperty)BlockTikiTorch.POWERED));
            }
            case RED: {
                return HLBlocks.BLOCK_TIKI_TORCH_RED.func_176223_P().func_177226_a((IProperty)BlockTikiTorch.POWERED, blockState.func_177229_b((IProperty)BlockTikiTorch.POWERED));
            }
            case WHITE: {
                return HLBlocks.BLOCK_TIKI_TORCH_WHITE.func_176223_P().func_177226_a((IProperty)BlockTikiTorch.POWERED, blockState.func_177229_b((IProperty)BlockTikiTorch.POWERED));
            }
        }
        return blockState;
    }

    public static enum DyeColor {
        ORANGE,
        CYAN,
        GREEN,
        PURPLE,
        RED,
        WHITE,
        PINK,
        YELLOW,
        LIME,
        BROWN,
        GRAY,
        LIGHT_GRAY,
        BLACK;

    }
}

