/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import net.hypherionmc.toggletorch.Main;
import net.hypherionmc.toggletorch.References;

public class UpdateEngine
implements Runnable {
    private static boolean isLatestVersion = false;
    private static int latestVersion;
    private static String updatetitle;
    private static String updatelink;

    @Override
    public void run() {
        block11: {
            Main.logger.info("Starting update check");
            if (Main.isDevBuild) {
                URL url = null;
                try {
                    url = new URL("https://ci.hypherionmc.me/job/Hyper-Lighting/job/1.12.2/lastSuccessfulBuild/buildNumber");
                    BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                    String line = in.readLine();
                    updatetitle = "Dev Build #" + line;
                    updatelink = "https://ci.hypherionmc.me/job/Hyper-Lighting/job/1.12.2/lastSuccessfulBuild/";
                    latestVersion = Integer.parseInt(line);
                    if (latestVersion > References.MOD_DEV_VERSION) {
                        isLatestVersion = false;
                        Main.logger.info("There is an update available. New Version: " + updatetitle);
                        break block11;
                    }
                    isLatestVersion = true;
                    Main.logger.info("Mod appears to be up to date");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    URL url = new URL("https://raw.githubusercontent.com/hypherionmc/hyperlighting_public/master/update_api/versions.json");
                    InputStreamReader reader = new InputStreamReader(url.openStream());
                    JsonElement object = new JsonParser().parse((Reader)reader);
                    JsonObject skr = (JsonObject)object;
                    if (skr.has("1.12.2")) {
                        JsonObject thisVersion = skr.getAsJsonObject("1.12.2");
                        updatetitle = thisVersion.get("title").getAsString();
                        updatelink = thisVersion.get("link").getAsString();
                        latestVersion = thisVersion.get("versioncode").getAsInt();
                        if (latestVersion > References.MOD_VERSION) {
                            isLatestVersion = false;
                            Main.logger.info("There is an update available. New Version: " + updatetitle);
                        } else {
                            isLatestVersion = true;
                            Main.logger.info("Mod appears to be up to date");
                        }
                    } else {
                        isLatestVersion = true;
                        Main.logger.info("Mod appears to be up to date");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean isLatestVersion() {
        return isLatestVersion;
    }

    public String getUpdateTitle() {
        return updatetitle;
    }

    public String getUpdatelink() {
        return updatelink;
    }

    static {
        updatetitle = "";
        updatelink = "";
    }
}

