/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.tileentities;

import javax.annotation.Nullable;
import net.hypherionmc.toggletorch.api.ISolarLight;
import net.hypherionmc.toggletorch.blocks.BlockFenceSolar;
import net.hypherionmc.toggletorch.network.PacketHandler;
import net.hypherionmc.toggletorch.network.StateToggleMessage;
import net.hypherionmc.toggletorch.solarpower.ISolarMachine;
import net.hypherionmc.toggletorch.solarpower.SolarEnergyStorage;
import net.hypherionmc.toggletorch.utils.ISwitchModule;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileSwitchBoard
extends TileEntity
implements ITickable,
ISolarMachine {
    private final ItemStackHandler itemStackHandler = new ItemStackHandler(6);
    private final SolarEnergyStorage energyStorage = new SolarEnergyStorage(5000, 0, 100, 5000);

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            for (EnumFacing facing : EnumFacing.values()) {
                SolarEnergyStorage storage;
                if (!(this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing)) instanceof ISolarMachine) || this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing)) == null || this.energyStorage.extractSolar(1, true) <= 0 || (storage = ((ISolarMachine)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))).getStorage()).receiveSolar(1, true) <= 0) continue;
                storage.receiveSolar(this.energyStorage.extractSolar(100, false), false);
            }
            this.sendUpdates();
        }
    }

    private void sendUpdates() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        this.func_70296_d();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemStackHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inventory", (NBTBase)this.itemStackHandler.serializeNBT());
        compound.func_74768_a("Energy", this.energyStorage.getSolarEnergyStored());
        compound.func_74768_a("Capacity", this.energyStorage.getSolarEnergyStored());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.itemStackHandler.deserializeNBT(compound.func_74775_l("inventory"));
        this.energyStorage.setEnergy(compound.func_74762_e("Energy"));
        this.energyStorage.setCapacity(compound.func_74762_e("Capacity"));
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("container.switchboard", new Object[0]);
    }

    public int getPowerLevel(int SlotID) {
        ItemStack stack = this.itemStackHandler.getStackInSlot(SlotID);
        if (this.isLinked(SlotID)) {
            NBTTagCompound compound = stack.func_77978_p();
            BlockPos pos = new BlockPos(compound.func_74762_e("blockx"), compound.func_74762_e("blocky"), compound.func_74762_e("blockz"));
            ISolarLight solar = (ISolarLight)this.field_145850_b.func_175625_s(pos);
            return (int)((double)solar.getPowerLevel() / (double)solar.getMaxPowerLevel() * 23.0);
        }
        return 0;
    }

    public int getPowerLevelPer(int SlotID) {
        ItemStack stack = this.itemStackHandler.getStackInSlot(SlotID);
        if (this.isLinked(SlotID)) {
            NBTTagCompound compound = stack.func_77978_p();
            BlockPos pos = new BlockPos(compound.func_74762_e("blockx"), compound.func_74762_e("blocky"), compound.func_74762_e("blockz"));
            ISolarLight solar = (ISolarLight)this.field_145850_b.func_175625_s(pos);
            return (int)((double)solar.getPowerLevel() / (double)solar.getMaxPowerLevel() * 100.0);
        }
        return 0;
    }

    public boolean getState(int SlotID) {
        ItemStack stack = this.itemStackHandler.getStackInSlot(SlotID);
        if (this.isLinked(SlotID)) {
            NBTTagCompound compound = stack.func_77978_p();
            BlockPos pos = new BlockPos(compound.func_74762_e("blockx"), compound.func_74762_e("blocky"), compound.func_74762_e("blockz"));
            return (Boolean)this.field_145850_b.func_180495_p(pos).func_177229_b((IProperty)BlockFenceSolar.LIT);
        }
        return false;
    }

    public boolean getCharging(int SlotID) {
        ItemStack stack = this.itemStackHandler.getStackInSlot(SlotID);
        if (this.isLinked(SlotID)) {
            NBTTagCompound compound = stack.func_77978_p();
            BlockPos pos = new BlockPos(compound.func_74762_e("blockx"), compound.func_74762_e("blocky"), compound.func_74762_e("blockz"));
            ISolarLight solar = (ISolarLight)this.field_145850_b.func_175625_s(pos);
            return solar.isCharging();
        }
        return false;
    }

    public boolean isLinked(int SlotID) {
        BlockPos pos;
        NBTTagCompound compound;
        ItemStack stack = this.itemStackHandler.getStackInSlot(SlotID);
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ISwitchModule && stack.func_77978_p() != null && (compound = stack.func_77978_p()).func_74764_b("blockx") && compound.func_74764_b("blocky") && compound.func_74764_b("blockz") && this.field_145850_b.func_175625_s(pos = new BlockPos(compound.func_74762_e("blockx"), compound.func_74762_e("blocky"), compound.func_74762_e("blockz"))) != null && this.field_145850_b.func_175625_s(pos).func_145830_o() && this.field_145850_b.func_175625_s(pos) instanceof ISolarLight;
    }

    public void toggleState(int SlotID) {
        ItemStack stack = this.itemStackHandler.getStackInSlot(SlotID);
        if (this.isLinked(SlotID)) {
            NBTTagCompound compound = stack.func_77978_p();
            BlockPos pos = new BlockPos(compound.func_74762_e("blockx"), compound.func_74762_e("blocky"), compound.func_74762_e("blockz"));
            StateToggleMessage msg = new StateToggleMessage(pos);
            if (this.getPowerLevel(SlotID) > 0) {
                PacketHandler.INSTANCE.sendToServer((IMessage)msg);
            } else if (this.field_145850_b.func_184137_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0, false) != null) {
                this.field_145850_b.func_184137_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0, false).func_145747_a((ITextComponent)new TextComponentString("Out of power"));
            }
        }
    }

    @Override
    public SolarEnergyStorage getStorage() {
        return this.energyStorage;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public void dropInventory() {
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            if (this.itemStackHandler.getStackInSlot(i).func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.itemStackHandler.getStackInSlot(i));
        }
    }
}

