/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.tileentities;

import com.zeitheron.hammercore.api.lighting.ColoredLight;
import com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.hypherionmc.toggletorch.HyperLightingConfig;
import net.hypherionmc.toggletorch.init.HLItems;
import net.hypherionmc.toggletorch.items.WirelessPowerCard;
import net.hypherionmc.toggletorch.solarpower.ISolarMachine;
import net.hypherionmc.toggletorch.solarpower.SolarEnergyStorage;
import net.hypherionmc.toggletorch.tileentities.TileSolarPanel;
import net.hypherionmc.toggletorch.utils.dyes.FogDyeColorUtil;
import net.hypherionmc.toggletorch.utils.handlers.SoundHandler;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.ItemStackHandler;

@Optional.Interface(iface="com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity", modid="hammercore")
public class TileNeonSign
extends TileEntity
implements ITickable,
ISolarMachine,
IGlowingEntity {
    public String[] signText = new String[]{"CTRL Right Click", "to edit", "the text of", "this sign"};
    private final ItemStackHandler dyeHandler = new DyeItemHandler(1);
    private final ItemStackHandler powerHandler = new PowerItemHandler(1);
    private final SolarEnergyStorage solarEnergyStorage = new SolarEnergyStorage(200, 100, 3);
    private boolean isCharging = false;
    private boolean isPowered = false;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                if (!this.powerHandler.getStackInSlot(0).func_190926_b() && this.powerHandler.getStackInSlot(0).func_77973_b() == HLItems.WIRELESS_POWER_CARD) {
                    BlockPos pos;
                    NBTTagCompound tagCompound;
                    ItemStack stack = this.powerHandler.getStackInSlot(0);
                    if (stack.func_77942_o() && stack.func_77978_p() != null && (tagCompound = stack.func_77978_p()).func_74764_b("blockx") && tagCompound.func_74764_b("blocky") && tagCompound.func_74764_b("blockz") && this.field_145850_b.func_175625_s(pos = new BlockPos(tagCompound.func_74762_e("blockx"), tagCompound.func_74762_e("blocky"), tagCompound.func_74762_e("blockz"))) != null && this.field_145850_b.func_175625_s(pos) instanceof TileSolarPanel) {
                        TileSolarPanel storage1 = (TileSolarPanel)this.field_145850_b.func_175625_s(pos);
                        SolarEnergyStorage storage = storage1.getStorage();
                        if (storage != null && storage.canExtract() && storage.extractSolar(10, true) > 0) {
                            if (this.solarEnergyStorage.receiveSolarInternal(20, true) > 0) {
                                this.isCharging = true;
                                storage.extractEnergy(this.solarEnergyStorage.receiveSolarInternal(20, false), false);
                            } else {
                                this.isCharging = false;
                            }
                        } else {
                            this.isCharging = false;
                        }
                    }
                } else {
                    this.isCharging = false;
                }
            }
            if (this.field_145850_b.func_82737_E() % 40L == 0L && this.isPowered) {
                this.solarEnergyStorage.extractSolarInternal(1, false);
            }
            if (this.solarEnergyStorage.getSolarEnergyStored() < 1) {
                this.isPowered = false;
            }
            this.sendUpdates();
        } else {
            if (this.isPowered && HyperLightingConfig.neonConfig.soundEnabled) {
                if (!SoundHandler.isLoopPlaying(this.field_145850_b, this.field_174879_c)) {
                    SoundHandler.playLoop(this, this.field_174879_c);
                }
            } else {
                SoundHandler.stopSound(this, this.field_174879_c);
            }
            this.field_145850_b.func_175664_x(this.field_174879_c);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        for (int i = 0; i < this.signText.length; ++i) {
            String s;
            this.signText[i] = s = compound.func_74779_i("Text" + (i + 1));
        }
        this.solarEnergyStorage.readNBT(compound);
        this.dyeHandler.deserializeNBT(compound.func_74775_l("dye"));
        this.powerHandler.deserializeNBT(compound.func_74775_l("powerItem"));
        this.isCharging = compound.func_74767_n("charging");
        this.isPowered = compound.func_74767_n("powered");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        for (int i = 0; i < this.signText.length; ++i) {
            compound.func_74778_a("Text" + (i + 1), this.signText[i]);
        }
        compound.func_74782_a("dye", (NBTBase)this.dyeHandler.serializeNBT());
        compound.func_74782_a("powerItem", (NBTBase)this.powerHandler.serializeNBT());
        compound.func_74757_a("charging", this.isCharging);
        compound.func_74757_a("powered", this.isPowered);
        this.solarEnergyStorage.writeNBT(compound);
        return compound;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 9, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public void sendUpdates() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        this.func_70296_d();
    }

    public void setSignText(String text) {
        this.signText = text.split("\n");
        this.sendUpdates();
    }

    public ItemStackHandler getDyeHandler() {
        return this.dyeHandler;
    }

    public ItemStackHandler getPowerHandler() {
        return this.powerHandler;
    }

    @Override
    public SolarEnergyStorage getStorage() {
        return this.solarEnergyStorage;
    }

    public ColoredLight produceColoredLight(float partialTicks) {
        if (this.isPowered && HyperLightingConfig.neonConfig.useColoredLight) {
            if (this.dyeHandler.getStackInSlot(0).func_190926_b()) {
                return new ColoredLight.Builder().pos(this.field_174879_c).radius(3.0f).color(1.0f, 0.0f, 0.0f).build();
            }
            ItemStack stack = this.dyeHandler.getStackInSlot(0);
            float[] color = FogDyeColorUtil.getColorFromDye(stack);
            return new ColoredLight.Builder().pos(this.field_174879_c).radius(3.0f).color(color[0], color[1], color[2]).build();
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && facing == null) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && facing == null) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.solarEnergyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean isCharging() {
        return this.isCharging;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public void setPowered(boolean powered) {
        this.isPowered = powered;
    }

    public void onBroken() {
        if (!this.dyeHandler.getStackInSlot(0).func_190926_b()) {
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.dyeHandler.getStackInSlot(0));
        }
        if (!this.powerHandler.getStackInSlot(0).func_190926_b()) {
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.powerHandler.getStackInSlot(0));
        }
    }

    public class PowerItemHandler
    extends ItemStackHandler {
        public PowerItemHandler(int size) {
            this.setSize(size);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() instanceof WirelessPowerCard;
        }
    }

    public class DyeItemHandler
    extends ItemStackHandler {
        public DyeItemHandler(int size) {
            this.setSize(size);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() instanceof ItemDye;
        }
    }
}

