/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.tileentities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.hypherionmc.toggletorch.blocks.BlockFogMachine;
import net.hypherionmc.toggletorch.particles.ParticleFogSmoke;
import net.hypherionmc.toggletorch.utils.dyes.FogDyeColorUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileFogMachine
extends TileEntity
implements ITickable,
IFluidHandler {
    private final ItemStackHandler itemStackHandler = new StackHandler(1);
    public boolean autoFireEnabled = false;
    public boolean isCooldown = false;
    public boolean hasFluid = false;
    public boolean fireMachine = false;
    public int timer = 0;
    public int fireLength = 120;
    public int autoFireTimer = 0;
    public int autoFireTime = 1000;
    public int cooldownTimer = 0;
    public int cooldownTime = 1200;
    public int cooldownTimeRemaining = 600;
    private FluidTank tank = new FluidTank(5000){

        public boolean canFill() {
            return true;
        }

        public boolean canDrain() {
            return false;
        }

        protected void onContentsChanged() {
            IBlockState state = TileFogMachine.this.field_145850_b.func_180495_p(TileFogMachine.this.field_174879_c);
            TileFogMachine.this.field_145850_b.func_184138_a(TileFogMachine.this.field_174879_c, state, state, 3);
            TileFogMachine.this.func_70296_d();
        }
    };

    public TileFogMachine() {
        this.tank.setTileEntity((TileEntity)this);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            if (this.fireMachine && this.canFire()) {
                this.addFireParticle();
                this.addParticles();
            }
        } else {
            if (this.isFireMachine()) {
                ++this.timer;
            }
            this.autoFireTimer = this.autoFireEnabled ? ++this.autoFireTimer : 0;
            if (!this.isCooldown) {
                ++this.cooldownTimer;
            }
            if (this.timer > this.fireLength) {
                this.fireMachine = false;
                this.timer = 0;
                this.sendUpdates();
            }
            if (this.autoFireTimer > this.autoFireTime && this.autoFireEnabled) {
                this.fireMachine = true;
                this.autoFireTimer = 0;
                this.sendUpdates();
            }
            if (this.tank.getFluidAmount() > 1) {
                this.hasFluid = true;
                this.sendUpdates();
            } else {
                this.hasFluid = false;
                this.sendUpdates();
            }
            if (this.isFireMachine() && this.canFire()) {
                this.tank.drainInternal(1, true);
            }
            if (this.cooldownTimer > this.cooldownTime) {
                this.isCooldown = true;
                this.cooldownTimer = 0;
            }
            if (this.isCooldown && this.cooldownTimeRemaining > 0) {
                --this.cooldownTimeRemaining;
            } else {
                this.isCooldown = false;
                this.cooldownTimeRemaining = 600;
            }
            this.sendUpdates();
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.fireMachine = compound.func_74767_n("isfiring");
        this.timer = compound.func_74762_e("firetimer");
        this.autoFireTimer = compound.func_74762_e("autofiretimer");
        this.isCooldown = compound.func_74767_n("iscooldown");
        this.hasFluid = compound.func_74767_n("hasfluid");
        this.cooldownTimer = compound.func_74762_e("cooldowntimer");
        this.cooldownTimeRemaining = compound.func_74762_e("cooldowntimeremain");
        this.autoFireEnabled = compound.func_74767_n("autofireenabled");
        this.tank.readFromNBT(compound);
        this.itemStackHandler.deserializeNBT(compound.func_74775_l("dye"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("isfiring", this.fireMachine);
        compound.func_74768_a("firetimer", this.timer);
        compound.func_74768_a("autofiretimer", this.autoFireTimer);
        compound.func_74757_a("iscooldown", this.isCooldown);
        compound.func_74757_a("hasfluid", this.hasFluid);
        compound.func_74768_a("cooldowntimer", this.cooldownTimer);
        compound.func_74768_a("cooldowntimeremain", this.cooldownTimeRemaining);
        compound.func_74757_a("autofireenabled", this.autoFireEnabled);
        this.tank.writeToNBT(compound);
        compound.func_74782_a("dye", (NBTBase)this.itemStackHandler.serializeNBT());
        return compound;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void sendUpdates() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        this.func_70296_d();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    @SideOnly(value=Side.CLIENT)
    private void addParticles() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockFogMachine.FACING);
        for (int i = 0; i <= 4; ++i) {
            ParticleFogSmoke particleFogSmoke1 = new ParticleFogSmoke(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 2.0 + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 0.4, (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextGaussian(), (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03);
            ParticleFogSmoke particleFogSmoke2 = new ParticleFogSmoke(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 2.0 + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 0.4, (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextGaussian(), (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03);
            ParticleFogSmoke particleFogSmoke3 = new ParticleFogSmoke(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 2.0 + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 0.4, (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextGaussian(), (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03);
            ParticleFogSmoke particleFogSmoke4 = new ParticleFogSmoke(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 2.0 + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 0.4, (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextGaussian(), (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03);
            if (facing == EnumFacing.NORTH) {
                particleFogSmoke1 = new ParticleFogSmoke(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 0.4, (double)this.field_174879_c.func_177952_p() - 1.5 + this.field_145850_b.field_73012_v.nextGaussian(), (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)this.field_145850_b.field_73012_v.nextFloat() * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03);
                particleFogSmoke2 = new ParticleFogSmoke(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 0.7, (double)this.field_174879_c.func_177952_p() - 1.5 + this.field_145850_b.field_73012_v.nextGaussian(), (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)this.field_145850_b.field_73012_v.nextFloat() * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03);
                particleFogSmoke3 = new ParticleFogSmoke(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() - 1.5 + this.field_145850_b.field_73012_v.nextGaussian(), (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)this.field_145850_b.field_73012_v.nextFloat() * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03);
                particleFogSmoke4 = new ParticleFogSmoke(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 1.3, (double)this.field_174879_c.func_177952_p() - 1.5 + this.field_145850_b.field_73012_v.nextGaussian(), (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)this.field_145850_b.field_73012_v.nextFloat() * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03);
            } else if (facing == EnumFacing.SOUTH) {
                particleFogSmoke1 = new ParticleFogSmoke(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 0.4, (double)this.field_174879_c.func_177952_p() + 2.0 + this.field_145850_b.field_73012_v.nextGaussian(), (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)this.field_145850_b.field_73012_v.nextFloat() * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03);
                particleFogSmoke2 = new ParticleFogSmoke(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 0.7, (double)this.field_174879_c.func_177952_p() + 2.0 + this.field_145850_b.field_73012_v.nextGaussian(), (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)this.field_145850_b.field_73012_v.nextFloat() * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03);
                particleFogSmoke3 = new ParticleFogSmoke(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 2.0 + this.field_145850_b.field_73012_v.nextGaussian(), (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)this.field_145850_b.field_73012_v.nextFloat() * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03);
                particleFogSmoke4 = new ParticleFogSmoke(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 1.3, (double)this.field_174879_c.func_177952_p() + 2.0 + this.field_145850_b.field_73012_v.nextGaussian(), (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)this.field_145850_b.field_73012_v.nextFloat() * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03);
            } else if (facing == EnumFacing.WEST) {
                particleFogSmoke1 = new ParticleFogSmoke(this.field_145850_b, (double)this.field_174879_c.func_177958_n() - 1.5 + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 0.4, (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextGaussian(), (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)this.field_145850_b.field_73012_v.nextFloat() * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03);
                particleFogSmoke2 = new ParticleFogSmoke(this.field_145850_b, (double)this.field_174879_c.func_177958_n() - 1.5 + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 0.7, (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextGaussian(), (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)this.field_145850_b.field_73012_v.nextFloat() * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03);
                particleFogSmoke3 = new ParticleFogSmoke(this.field_145850_b, (double)this.field_174879_c.func_177958_n() - 1.5 + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextGaussian(), (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)this.field_145850_b.field_73012_v.nextFloat() * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03);
                particleFogSmoke4 = new ParticleFogSmoke(this.field_145850_b, (double)this.field_174879_c.func_177958_n() - 1.5 + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 1.3, (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextGaussian(), (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)this.field_145850_b.field_73012_v.nextFloat() * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03);
            } else if (facing == EnumFacing.EAST) {
                particleFogSmoke1 = new ParticleFogSmoke(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 2.0 + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 0.4, (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextGaussian(), (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)this.field_145850_b.field_73012_v.nextFloat() * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03);
                particleFogSmoke2 = new ParticleFogSmoke(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 2.0 + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 0.7, (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextGaussian(), (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)this.field_145850_b.field_73012_v.nextFloat() * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03);
                particleFogSmoke3 = new ParticleFogSmoke(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 2.0 + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextGaussian(), (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)this.field_145850_b.field_73012_v.nextFloat() * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03);
                particleFogSmoke4 = new ParticleFogSmoke(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 2.0 + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 1.3, (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextGaussian(), (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03, (double)this.field_145850_b.field_73012_v.nextFloat() * 0.03, (double)(this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.03);
            }
            particleFogSmoke1.setFogColor(FogDyeColorUtil.getColorFromDye(this.itemStackHandler.getStackInSlot(0)));
            particleFogSmoke2.setFogColor(FogDyeColorUtil.getColorFromDye(this.itemStackHandler.getStackInSlot(0)));
            particleFogSmoke3.setFogColor(FogDyeColorUtil.getColorFromDye(this.itemStackHandler.getStackInSlot(0)));
            particleFogSmoke4.setFogColor(FogDyeColorUtil.getColorFromDye(this.itemStackHandler.getStackInSlot(0)));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particleFogSmoke1);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particleFogSmoke2);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particleFogSmoke3);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particleFogSmoke4);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addFireParticle() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockFogMachine.FACING);
        if (facing == EnumFacing.NORTH) {
            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.1, 0.0, 0.0, -0.1, new int[0]);
        } else if (facing == EnumFacing.SOUTH) {
            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.9, 0.0, 0.0, 0.1, new int[0]);
        } else if (facing == EnumFacing.WEST) {
            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)this.field_174879_c.func_177958_n() + 0.1, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, -0.1, 0.0, 0.0, new int[0]);
        } else if (facing == EnumFacing.EAST) {
            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)this.field_174879_c.func_177958_n() + 0.9, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, 0.1, 0.0, 0.0, new int[0]);
        }
    }

    public boolean isFireMachine() {
        return this.fireMachine;
    }

    public void setFireMachine(boolean fireMachine) {
        this.fireMachine = fireMachine;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing == null;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing == null) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemStackHandler);
        }
        return null;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.tank.drain(resource, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFire() {
        return this.hasFluid && !this.isCooldown;
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("tile.fogmachine.name", new Object[0]);
    }

    public int getFluidLevelGui() {
        return (int)((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity() * 24.0f);
    }

    public boolean isCooldown() {
        return this.isCooldown;
    }

    public boolean isAutoFireEnabled() {
        return this.autoFireEnabled;
    }

    public void setAutoFireEnabled(Boolean enabled) {
        this.autoFireEnabled = enabled;
    }

    public int getAutoFireTime() {
        return this.autoFireTime;
    }

    public void setAutoFireTime(int autoFireTime) {
        this.autoFireTime = autoFireTime;
    }

    public class StackHandler
    extends ItemStackHandler {
        public StackHandler(int size) {
            super(size);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() instanceof ItemDye;
        }
    }
}

