/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.tileentities;

import java.util.Random;
import javax.annotation.Nullable;
import net.hypherionmc.toggletorch.blocks.BlockCampFire;
import net.hypherionmc.toggletorch.blocks.BlockCampSoulFire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class TileCampFire
extends TileEntity
implements ITickable {
    private final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> fuelStacks = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private final int[] cookingTimes = new int[4];
    private final int[] cookingTotalTimes = new int[4];

    public void func_73660_a() {
        if (this.func_145838_q() instanceof BlockCampFire || this.func_145838_q() instanceof BlockCampSoulFire) {
            boolean isLit = (Boolean)this.getBlockState().func_177229_b((IProperty)BlockCampFire.LIT);
            boolean isRemote = this.field_145850_b.field_72995_K;
            if (isRemote) {
                if (isLit) {
                    this.addParticles();
                }
            } else if (isLit) {
                this.cookAndReturn();
            } else {
                for (int i = 0; i < this.inventory.size(); ++i) {
                    if (this.cookingTimes[i] <= 0) continue;
                    this.cookingTimes[i] = MathHelper.func_76125_a((int)(this.cookingTimes[i] - 2), (int)0, (int)this.cookingTotalTimes[i]);
                }
            }
        }
    }

    private void cookAndReturn() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack toCook = (ItemStack)this.inventory.get(i);
            if (toCook.func_190926_b()) continue;
            int n = i;
            this.cookingTimes[n] = this.cookingTimes[n] + 1;
            if (this.cookingTimes[i] < this.cookingTotalTimes[i]) continue;
            ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(toCook).func_77946_l();
            BlockPos pos = this.func_174877_v();
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)result);
            this.inventory.set(i, (Object)ItemStack.field_190927_a);
            this.updateTile();
        }
    }

    private void addParticles() {
        World world = this.func_145831_w();
        if (world != null) {
            BlockPos blockPos = this.func_174877_v();
            Random random = world.field_73012_v;
            if (random.nextFloat() < 0.11f) {
                for (int i = 0; i < random.nextInt(2) + 2; ++i) {
                    world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)this.field_174879_c.func_177958_n() + 0.25 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), (double)this.field_174879_c.func_177956_o() + 0.4, (double)this.field_174879_c.func_177952_p() + 0.25 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0, new int[0]);
                }
            }
            int l = ((EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockCampFire.FACING)).func_176736_b();
            for (int j = 0; j < this.getInventory().size(); ++j) {
                if (((ItemStack)this.getInventory().get(j)).func_190926_b() || !(random.nextFloat() < 0.2f)) continue;
                EnumFacing facing = EnumFacing.func_176731_b((int)Math.floorMod(j + l, 4));
                float f = 0.3125f;
                double d0 = (double)this.field_174879_c.func_177958_n() + 0.5 - (double)((float)facing.func_82601_c() * 0.3125f) + (double)((float)facing.func_176746_e().func_82601_c() * 0.3125f);
                double d1 = (double)this.field_174879_c.func_177956_o() + 0.5;
                double d2 = (double)this.field_174879_c.func_177952_p() + 0.5 - (double)((float)facing.func_82599_e() * 0.3125f) + (double)((float)facing.func_176746_e().func_82599_e() * 0.3125f);
                for (int k = 0; k < 4; ++k) {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 5.0E-4, 0.0, new int[0]);
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory.clear();
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        if (compound.func_150297_b("CookingTimes", 11)) {
            int[] cookingTimes = compound.func_74759_k("CookingTimes");
            System.arraycopy(cookingTimes, 0, this.cookingTimes, 0, Math.min(this.cookingTotalTimes.length, cookingTimes.length));
        }
        if (compound.func_150297_b("CookingTotalTimes", 11)) {
            int[] cookingTotalTimes = compound.func_74759_k("CookingTotalTimes");
            System.arraycopy(cookingTotalTimes, 0, this.cookingTotalTimes, 0, Math.min(this.cookingTotalTimes.length, cookingTotalTimes.length));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.writeItems(compound);
        compound.func_74783_a("CookingTimes", this.cookingTimes);
        compound.func_74783_a("CookingTotalTimes", this.cookingTotalTimes);
        return compound;
    }

    private NBTTagCompound writeItems(NBTTagCompound compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191281_a((NBTTagCompound)compound, this.inventory, (boolean)true);
        return compound;
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public NonNullList<ItemStack> getFuelStacks() {
        return this.fuelStacks;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.writeItems(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public boolean addItem(ItemStack itemStack, int cookTime) {
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack itemStack1 = (ItemStack)this.inventory.get(i);
            if (!itemStack1.func_190926_b() && itemStack1 != ItemStack.field_190927_a) continue;
            this.cookingTotalTimes[i] = cookTime;
            this.cookingTimes[i] = 0;
            this.inventory.set(i, (Object)itemStack.func_77979_a(1));
            this.updateTile();
            return true;
        }
        return false;
    }

    private void updateTile() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        this.func_70296_d();
    }

    public void clear() {
        this.inventory.clear();
    }

    public void dropItems() {
        if (!this.func_145831_w().field_72995_K) {
            this.getInventory().forEach(itemStack -> InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)itemStack));
        }
        this.updateTile();
    }

    public IBlockState getBlockState() {
        return this.func_145831_w().func_180495_p(this.func_174877_v());
    }

    public boolean findMatchingRecipe(ItemStack itemStackIn) {
        ItemStack itm = FurnaceRecipes.func_77602_a().func_151395_a(itemStackIn).func_77946_l();
        return !itm.func_190926_b() && itm.func_77975_n() == EnumAction.EAT;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return newSate.func_177230_c() != this.func_145838_q();
    }
}

