/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.tileentities;

import com.zeitheron.hammercore.api.lighting.ColoredLight;
import com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.hypherionmc.toggletorch.HyperLightingConfig;
import net.hypherionmc.toggletorch.api.ISolarLight;
import net.hypherionmc.toggletorch.blocks.BlockBatteryNeon;
import net.hypherionmc.toggletorch.init.HLBlocks;
import net.hypherionmc.toggletorch.init.HLItems;
import net.hypherionmc.toggletorch.particles.ParticleEnum;
import net.hypherionmc.toggletorch.solarpower.ISolarMachine;
import net.hypherionmc.toggletorch.solarpower.SolarEnergyStorage;
import net.hypherionmc.toggletorch.tileentities.TileSolarPanel;
import net.hypherionmc.toggletorch.utils.dyes.FogDyeColorUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.ItemStackHandler;

@Optional.Interface(iface="com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity", modid="hammercore")
public class TileBatteryNeon
extends TileEntity
implements ITickable,
ISolarMachine,
ISolarLight,
IGlowingEntity {
    private boolean isCharging = false;
    private final SolarEnergyStorage energyStorage = new SolarEnergyStorage(500, 20, 1);
    private final ItemStackHandler itemStackHandler = new ItemHandler(1);
    private final ItemStackHandler dyeHandler = new DyeHandler(1);

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                if (!this.itemStackHandler.getStackInSlot(0).func_190926_b() && this.itemStackHandler.getStackInSlot(0).func_77973_b() == HLItems.WIRELESS_POWER_CARD) {
                    BlockPos pos;
                    NBTTagCompound tagCompound;
                    ItemStack stack = this.itemStackHandler.getStackInSlot(0);
                    if (stack.func_77942_o() && stack.func_77978_p() != null && (tagCompound = stack.func_77978_p()).func_74764_b("blockx") && tagCompound.func_74764_b("blocky") && tagCompound.func_74764_b("blockz") && this.field_145850_b.func_175625_s(pos = new BlockPos(tagCompound.func_74762_e("blockx"), tagCompound.func_74762_e("blocky"), tagCompound.func_74762_e("blockz"))) != null && this.field_145850_b.func_175625_s(pos) instanceof TileSolarPanel) {
                        TileSolarPanel storage1 = (TileSolarPanel)this.field_145850_b.func_175625_s(pos);
                        SolarEnergyStorage storage = storage1.getStorage();
                        if (storage != null && storage.canExtract() && storage.extractSolar(10, true) > 0) {
                            if (this.energyStorage.receiveSolarInternal(20, true) > 0) {
                                this.isCharging = true;
                                storage.extractEnergy(this.energyStorage.receiveSolarInternal(20, false), false);
                            } else {
                                this.isCharging = false;
                            }
                        } else {
                            this.isCharging = false;
                        }
                    }
                } else {
                    this.isCharging = false;
                }
            }
            if (this.field_145850_b.func_82737_E() % 40L == 0L && this.field_145850_b.func_180495_p(this.field_174879_c) != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == HLBlocks.BLOCK_BATTERY_NEON && ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockBatteryNeon.LIT)).booleanValue()) {
                this.energyStorage.extractSolarInternal(1, false);
            }
            this.sendUpdates();
        }
        this.field_145850_b.func_175664_x(this.field_174879_c);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.isCharging = compound.func_74767_n("isCharging");
        this.energyStorage.readNBT(compound);
        this.itemStackHandler.deserializeNBT(compound.func_74775_l("inventory"));
        this.dyeHandler.deserializeNBT(compound.func_74775_l("dye"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("isCharging", this.isCharging);
        this.energyStorage.writeNBT(compound);
        compound.func_74782_a("inventory", (NBTBase)this.itemStackHandler.serializeNBT());
        compound.func_74782_a("dye", (NBTBase)this.dyeHandler.serializeNBT());
        return compound;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    public boolean isCharging() {
        return this.isCharging;
    }

    @Override
    public int getMaxPowerLevel() {
        return this.energyStorage.getMaxSolarEnergyStored();
    }

    @Override
    public int getPowerLevel() {
        return this.energyStorage.getSolarEnergyStored();
    }

    private void sendUpdates() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        this.func_70296_d();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyStorage);
        }
        return null;
    }

    @Override
    public SolarEnergyStorage getStorage() {
        return this.energyStorage;
    }

    public ColoredLight produceColoredLight(float partialTicks) {
        if (HyperLightingConfig.batteryLightConfig.useColoredLight && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockBatteryNeon && ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockBatteryNeon.LIT)).booleanValue()) {
            if (!this.dyeHandler.getStackInSlot(0).func_190926_b()) {
                ItemStack stack = this.dyeHandler.getStackInSlot(0);
                float[] color = FogDyeColorUtil.getColorFromDye(stack);
                return new ColoredLight.Builder().pos(this.field_174879_c).color(color[0], color[1], color[2]).radius(14.0f).build();
            }
            ParticleEnum particleEnum = ParticleEnum.DEFAULT_FLAME;
            return new ColoredLight.Builder().pos(this.field_174879_c).color(particleEnum.getRedFloat(), particleEnum.getGreenFloat(), particleEnum.getBlueFloat()).radius(14.0f).build();
        }
        return null;
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    public ItemStackHandler getDyeHandler() {
        return this.dyeHandler;
    }

    public void dropInventory() {
        if (!this.dyeHandler.getStackInSlot(0).func_190926_b()) {
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.dyeHandler.getStackInSlot(0));
        }
        if (!this.itemStackHandler.getStackInSlot(0).func_190926_b()) {
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.itemStackHandler.getStackInSlot(0));
        }
    }

    public class DyeHandler
    extends ItemStackHandler {
        public DyeHandler(int size) {
            super(size);
        }

        public void setSize(int size) {
            super.setSize(size);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() instanceof ItemDye;
        }
    }

    class ItemHandler
    extends ItemStackHandler {
        public ItemHandler(int size) {
            super(size);
        }

        public void setSize(int size) {
            super.setSize(size);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() == HLItems.WIRELESS_POWER_CARD;
        }
    }
}

