/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.solarpower;

import net.hypherionmc.toggletorch.solarpower.ISolarEnergyStorage;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.IEnergyStorage;

public class SolarEnergyStorage
implements ISolarEnergyStorage,
IEnergyStorage {
    protected int energy;
    protected int capacity;
    protected int maxReceive;
    protected int maxExtract;

    public SolarEnergyStorage(int capacity) {
        this(capacity, capacity, capacity, 0);
    }

    public SolarEnergyStorage(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, 0);
    }

    public SolarEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        this(capacity, maxReceive, maxExtract, 0);
    }

    public SolarEnergyStorage(int capacity, int maxReceive, int maxExtract, int energy) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.energy = Math.max(0, Math.min(capacity, energy));
    }

    @Override
    public int receiveSolar(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public int receiveSolarInternal(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    @Override
    public int extractSolar(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    public int extractSolarInternal(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    @Override
    public int getSolarEnergyStored() {
        return this.energy;
    }

    @Override
    public int getMaxSolarEnergyStored() {
        return this.capacity;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.receiveSolar(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.extractSolar(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.getSolarEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.getMaxSolarEnergyStored();
    }

    @Override
    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    @Override
    public boolean canReceive() {
        return this.maxReceive > 0;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public NBTTagCompound writeNBT(NBTTagCompound compound) {
        compound.func_74768_a("energy", this.energy);
        compound.func_74768_a("capacity", this.capacity);
        compound.func_74768_a("maxReceive", this.maxReceive);
        compound.func_74768_a("maxExtract", this.maxExtract);
        return compound;
    }

    public void readNBT(NBTTagCompound compound) {
        this.capacity = compound.func_74762_e("capacity");
        this.energy = compound.func_74762_e("energy");
        this.maxExtract = compound.func_74762_e("maxExtract");
        this.maxReceive = compound.func_74762_e("maxReceive");
    }
}

