/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.network;

import io.netty.buffer.ByteBuf;
import net.hypherionmc.toggletorch.tileentities.TileNeonSign;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketSignUpdate
implements IMessage {
    private BlockPos posToSet;
    private String text;

    public PacketSignUpdate() {
    }

    public PacketSignUpdate(BlockPos pos, String fireMachine) {
        this.posToSet = pos;
        this.text = fireMachine;
    }

    public void fromBytes(ByteBuf buf) {
        this.posToSet = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.text = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.posToSet.func_177958_n());
        buf.writeInt(this.posToSet.func_177956_o());
        buf.writeInt(this.posToSet.func_177952_p());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.text);
    }

    public static class ServerHandler
    implements IMessageHandler<PacketSignUpdate, IMessage> {
        public IMessage onMessage(PacketSignUpdate message, MessageContext ctx) {
            if (ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(PacketSignUpdate message, MessageContext ctx) {
            TileEntity te = ctx.getServerHandler().field_147369_b.func_71121_q().func_175625_s(message.posToSet);
            if (te != null && te instanceof TileNeonSign) {
                TileNeonSign TE = (TileNeonSign)te;
                ((TileNeonSign)te).setSignText(message.text);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSignUpdate, IMessage> {
        public IMessage onMessage(PacketSignUpdate message, MessageContext ctx) {
            if (ctx.side != Side.CLIENT) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(PacketSignUpdate message, MessageContext ctx) {
            TileEntity te = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_175625_s(message.posToSet);
            if (te != null && te instanceof TileNeonSign) {
                TileNeonSign TE = (TileNeonSign)te;
                ((TileNeonSign)te).setSignText(message.text);
            }
        }
    }
}

