/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.vecmath.Vector2d;
import net.hypherionmc.toggletorch.gui.containers.ContainerSwitchBoard;
import net.hypherionmc.toggletorch.tileentities.TileSwitchBoard;
import net.hypherionmc.toggletorch.utils.helpers.SwitchBoardHelper;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class GuiSwitchBoard
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("hmctt:textures/gui/switchboard_gui.png");
    private final InventoryPlayer player;
    private final TileSwitchBoard te;
    private GuiButtonImage buttonImage;
    private List<SwitchBoardHelper> slots = new ArrayList<SwitchBoardHelper>();

    public GuiSwitchBoard(InventoryPlayer player, TileSwitchBoard te) {
        super((Container)new ContainerSwitchBoard(player, te));
        this.player = player;
        this.te = te;
        this.slots.add(new SwitchBoardHelper(new Vector2d(17.0, 36.0), new Vector2d(24.0, 32.0), new Vector2d(29.0, 32.0), new Vector2d(43.0, 14.0)));
        this.slots.add(new SwitchBoardHelper(new Vector2d(66.0, 36.0), new Vector2d(73.0, 32.0), new Vector2d(78.0, 32.0), new Vector2d(92.0, 14.0)));
        this.slots.add(new SwitchBoardHelper(new Vector2d(115.0, 36.0), new Vector2d(122.0, 32.0), new Vector2d(127.0, 32.0), new Vector2d(141.0, 14.0)));
        this.slots.add(new SwitchBoardHelper(new Vector2d(17.0, 66.0), new Vector2d(24.0, 62.0), new Vector2d(29.0, 62.0), new Vector2d(43.0, 44.0)));
        this.slots.add(new SwitchBoardHelper(new Vector2d(66.0, 66.0), new Vector2d(73.0, 62.0), new Vector2d(78.0, 62.0), new Vector2d(92.0, 44.0)));
        this.slots.add(new SwitchBoardHelper(new Vector2d(115.0, 66.0), new Vector2d(122.0, 62.0), new Vector2d(127.0, 62.0), new Vector2d(141.0, 44.0)));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int id = 0;
        for (SwitchBoardHelper itm : this.slots) {
            this.buttonImage = new GuiButtonImage(id, this.field_147003_i + (int)itm.getButtonPos().x, this.field_147009_r + (int)itm.getButtonPos().y, 16, 16, 176, 0, 0, TEXTURE);
            this.field_146292_n.add(this.buttonImage);
            ++id;
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (int j = 0; j < 6; ++j) {
            if (!this.field_147002_h.func_75139_a(j).func_75216_d() || !this.te.isLinked(j)) continue;
            Slot invslot = this.field_147002_h.func_75139_a(j);
            int i = this.te.getPowerLevel(j);
            SwitchBoardHelper helper = this.slots.get(j);
            this.func_73729_b(this.field_147003_i + (int)helper.getBarPos().x, this.field_147009_r + (int)helper.getBarPos().y - i + 1, 176, 39 - i, 4, i + 1);
            if (this.te.getCharging(j)) {
                this.func_73729_b(this.field_147003_i + (int)helper.getChargePos().x, this.field_147009_r + (int)helper.getChargePos().y, 189, 17, 4, 4);
            }
            if (this.te.getState(j)) {
                this.func_73729_b(this.field_147003_i + (int)helper.getStatepos().x, this.field_147009_r + (int)helper.getStatepos().y, 181, 17, 4, 4);
                continue;
            }
            this.func_73729_b(this.field_147003_i + (int)helper.getStatepos().x, this.field_147009_r + (int)helper.getStatepos().y, 185, 17, 4, 4);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String tileName = Objects.requireNonNull(this.te.func_145748_c_()).func_150260_c();
        this.field_146289_q.func_78276_b(tileName, 7, 4, 0x404040);
        this.field_146289_q.func_78276_b(this.player.func_145748_c_().func_150260_c(), 7, this.field_147000_g - 96 + 2, 0x404040);
        for (int i = 0; i < this.slots.size(); ++i) {
            if (!this.field_147002_h.func_75139_a(i).func_75216_d() || !this.te.isLinked(i)) continue;
            SwitchBoardHelper helper = this.slots.get(i);
            this.drawPowerToolTip(mouseX, mouseY, this.field_147003_i + (int)helper.getBarPos().x, this.field_147009_r + (int)helper.getBarPos().y - 22, 4, 23, "Battery Level", TextFormatting.YELLOW + "" + Math.round(this.te.getPowerLevelPer(i)) + "%");
            this.drawPowerToolTip(mouseX, mouseY, this.field_147003_i + (int)helper.getChargePos().x, this.field_147009_r + (int)helper.getChargePos().y, 4, 4, "Charging State", this.te.getCharging(i) ? TextFormatting.GREEN + "Charging" : TextFormatting.RED + "Not Charging");
            this.drawPowerToolTip(mouseX, mouseY, this.field_147003_i + (int)helper.getStatepos().x, this.field_147009_r + (int)helper.getStatepos().y, 4, 4, "Power State", this.te.getState(i) ? TextFormatting.GREEN + "On" : TextFormatting.RED + "Off");
        }
    }

    private void drawPowerToolTip(int mouseX, int mouseY, int startX, int startY, int sizeX, int sizeY, String title, String description) {
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        if (mouseX > startX && mouseX < startX + sizeX && mouseY > startY && mouseY < startY + sizeY) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(title);
            list.add(description);
            this.drawHoveringText(list, mouseX - k, mouseY - l, this.field_146289_q);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 0: {
                if (!this.field_147002_h.func_75139_a(0).func_75216_d()) break;
                this.te.toggleState(0);
                break;
            }
            case 1: {
                if (!this.field_147002_h.func_75139_a(1).func_75216_d()) break;
                this.te.toggleState(1);
                break;
            }
            case 2: {
                if (!this.field_147002_h.func_75139_a(2).func_75216_d()) break;
                this.te.toggleState(2);
                break;
            }
            case 3: {
                if (!this.field_147002_h.func_75139_a(3).func_75216_d()) break;
                this.te.toggleState(3);
                break;
            }
            case 4: {
                if (!this.field_147002_h.func_75139_a(4).func_75216_d()) break;
                this.te.toggleState(4);
                break;
            }
            case 5: {
                if (!this.field_147002_h.func_75139_a(5).func_75216_d()) break;
                this.te.toggleState(5);
            }
        }
    }
}

