/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import net.hypherionmc.toggletorch.gui.containers.ContainerFogMachine;
import net.hypherionmc.toggletorch.gui.widgets.HLButton;
import net.hypherionmc.toggletorch.gui.widgets.HLSlider;
import net.hypherionmc.toggletorch.network.PacketFoggerFireTime;
import net.hypherionmc.toggletorch.network.PacketHandler;
import net.hypherionmc.toggletorch.network.PacketSetFoggerAutoFire;
import net.hypherionmc.toggletorch.tileentities.TileFogMachine;
import net.hypherionmc.toggletorch.utils.LangUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiFogMachine
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("hmctt:textures/gui/fogger_gui.png");
    private final InventoryPlayer player;
    private final TileFogMachine te;
    private int lastSliderVal = 0;
    private final HLButton autoFireToggle = new HLButton(0, this.field_147003_i + 40, this.field_147009_r + 13, 80, 12, "Auto Fire: " + TextFormatting.RED + "Off");
    private final HLSlider timerSlider = new HLSlider(1, 0, 0, 135, 12, "slider", 0.0f, 6000.0f, 0.0f);

    public GuiFogMachine(InventoryPlayer player, TileFogMachine te) {
        super((Container)new ContainerFogMachine(player, te));
        this.player = player;
        this.te = te;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(this.autoFireToggle);
        this.field_146292_n.add(this.timerSlider);
        this.lastSliderVal = this.te.getAutoFireTime();
        this.timerSlider.setSliderValue(this.lastSliderVal, false);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int barHeight = this.te.getFluidLevelGui();
        this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + 37 - barHeight + 1, 176, 24 - barHeight, 5, barHeight + 1);
        if (this.te.canFire()) {
            this.func_73729_b(this.field_147003_i + 21, this.field_147009_r + 33, 176, 32, 5, 5);
        } else {
            this.func_73729_b(this.field_147003_i + 21, this.field_147009_r + 33, 181, 32, 5, 5);
        }
        if (this.te.isCooldown()) {
            this.func_73729_b(this.field_147003_i + 15, this.field_147009_r + 33, 186, 32, 5, 5);
        }
        if (this.te.isFireMachine() && this.te.canFire()) {
            this.func_73729_b(this.field_147003_i + 27, this.field_147009_r + 33, 176, 32, 5, 5);
        }
        if (!this.te.hasFluid) {
            this.func_73729_b(this.field_147003_i + 27, this.field_147009_r + 33, 191, 32, 5, 5);
        }
        this.autoFireToggle.field_146126_j = "Auto Fire: " + (this.te.autoFireEnabled ? TextFormatting.GREEN + "On" : TextFormatting.RED + "Off");
        this.autoFireToggle.field_146128_h = this.field_147003_i + 35;
        this.autoFireToggle.field_146129_i = this.field_147009_r + 13;
        this.timerSlider.field_146128_h = this.field_147003_i + 35;
        this.timerSlider.field_146129_i = this.field_147009_r + 28;
        if (this.lastSliderVal != (int)this.timerSlider.getSliderValue()) {
            this.lastSliderVal = (int)this.timerSlider.getSliderValue();
            PacketFoggerFireTime packetFoggerFireTime = new PacketFoggerFireTime(this.te.func_174877_v(), this.lastSliderVal);
            PacketHandler.INSTANCE.sendToServer((IMessage)packetFoggerFireTime);
            PacketHandler.INSTANCE.sendToAll((IMessage)packetFoggerFireTime);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String tileName = Objects.requireNonNull(this.te.func_145748_c_()).func_150260_c();
        this.field_146289_q.func_78276_b(tileName, 7, 4, 0x404040);
        this.field_146289_q.func_78276_b(this.player.func_145748_c_().func_150260_c(), 7, this.field_147000_g - 127 + 2, 0x404040);
        this.drawPowerToolTip(mouseX, mouseY, this.field_147003_i + 7, this.field_147009_r + 14, 5, 24, TextFormatting.YELLOW + new TextComponentTranslation("gui.fogger.fluidtooltipname", new Object[0]).func_150261_e(), "" + Math.round((float)this.te.getFluidLevelGui() / 24.0f * 100.0f) + "%");
        this.drawPowerToolTip(mouseX, mouseY, this.field_147003_i + 15, this.field_147009_r + 33, 4, 4, TextFormatting.YELLOW + new TextComponentTranslation("gui.fogger.cooldownstatetipname", new Object[0]).func_150261_e(), this.te.isCooldown ? TextFormatting.RED + new TextComponentTranslation("gui.fogger.cooldownstatecooldown", new Object[0]).func_150261_e() : TextFormatting.BLUE + new TextComponentTranslation("gui.fogger.cooldownstatereheating", new Object[0]).func_150261_e());
        this.drawPowerToolTip(mouseX, mouseY, this.field_147003_i + 21, this.field_147009_r + 33, 4, 4, TextFormatting.YELLOW + new TextComponentTranslation("gui.fogger.statetooltipname", new Object[0]).func_150261_e(), this.te.canFire() ? TextFormatting.GREEN + new TextComponentTranslation("gui.fogger.stateready", new Object[0]).func_150261_e() : TextFormatting.RED + new TextComponentTranslation("gui.fogger.statenotready", new Object[0]).func_150261_e());
        this.drawPowerToolTip(mouseX, mouseY, this.field_147003_i + 27, this.field_147009_r + 33, 4, 4, TextFormatting.YELLOW + new TextComponentTranslation("gui.fogger.statustooltipname", new Object[0]).func_150261_e(), (this.te.isFireMachine() ? TextFormatting.GREEN + new TextComponentTranslation("gui.fogger.firing", new Object[0]).func_150261_e() : TextFormatting.RESET + "") + (this.te.hasFluid ? TextFormatting.RESET + "" : TextFormatting.RED + new TextComponentTranslation("gui.foger.outoffluid", new Object[0]).func_150261_e()));
        this.drawPowerToolTip(mouseX, mouseY, this.autoFireToggle.field_146128_h, this.autoFireToggle.field_146129_i, this.autoFireToggle.field_146120_f, this.autoFireToggle.field_146121_g, TextFormatting.YELLOW + LangUtils.getTranslatedString("gui.fogger.autofiretooltipname"), LangUtils.getTranslatedString("gui.fogger.autofiretooltip1"), LangUtils.getTranslatedString("gui.fogger.autofiretooltip2"));
        this.drawPowerToolTip(mouseX, mouseY, this.timerSlider.field_146128_h, this.timerSlider.field_146129_i, this.timerSlider.field_146120_f, this.timerSlider.field_146121_g, TextFormatting.YELLOW + LangUtils.getTranslatedString("gui.fogger.autofiretimetooltipname"), LangUtils.getTranslatedString("gui.fogger.autofiretimetooltipline1"), LangUtils.getTranslatedString("gui.fogger.autofiretimetooltipline2"));
        this.drawPowerToolTip(mouseX, mouseY, this.field_147003_i + this.field_147002_h.func_75139_a((int)0).field_75223_e, this.field_147009_r + this.field_147002_h.func_75139_a((int)0).field_75221_f, 16, 16, TextFormatting.YELLOW + LangUtils.getTranslatedString("gui.fogger.dyetooltipname"), LangUtils.getTranslatedString("gui.fogger.dyetooltipline1"), LangUtils.getTranslatedString("gui.fogger.dyetooltipline2"));
    }

    private void drawPowerToolTip(int mouseX, int mouseY, int startX, int startY, int sizeX, int sizeY, String title, String ... description) {
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        if (mouseX > startX && mouseX < startX + sizeX && mouseY > startY && mouseY < startY + sizeY) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(title);
            for (String desc : description) {
                list.add(desc);
            }
            this.drawHoveringText(list, mouseX - k, mouseY - l, this.field_146289_q);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 0: {
                PacketSetFoggerAutoFire setFoggerAutoFire = new PacketSetFoggerAutoFire(this.te.func_174877_v(), !this.te.isAutoFireEnabled());
                PacketHandler.INSTANCE.sendToServer((IMessage)setFoggerAutoFire);
                break;
            }
        }
    }
}

