/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.blocks;

import com.zeitheron.hammercore.api.lighting.ColoredLight;
import com.zeitheron.hammercore.api.lighting.impl.IGlowingBlock;
import java.util.Random;
import net.hypherionmc.toggletorch.HyperLightingConfig;
import net.hypherionmc.toggletorch.Main;
import net.hypherionmc.toggletorch.init.HLBlocks;
import net.hypherionmc.toggletorch.init.HLItems;
import net.hypherionmc.toggletorch.particles.ParticleEnum;
import net.hypherionmc.toggletorch.utils.IHasModel;
import net.hypherionmc.toggletorch.utils.ModUtils;
import net.hypherionmc.toggletorch.utils.dyes.DyeUtil;
import net.hypherionmc.toggletorch.utils.dyes.IDyeAble;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemDye;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.BooleanUtils;

@Optional.Interface(iface="com.zeitheron.hammercore.api.lighting.impl.IGlowingBlock", modid="hammercore")
public class ColoredRedstoneLamp
extends Block
implements IHasModel,
IDyeAble,
IGlowingBlock {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    private ParticleEnum lightColor = ParticleEnum.DEFAULT_FLAME;

    public ColoredRedstoneLamp(String name, ParticleEnum lightColor) {
        super(Material.field_151591_t);
        this.lightColor = lightColor;
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(Main.lightingTab);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185853_f);
        HLBlocks.BLOCKS.add(this);
        HLItems.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    @Override
    public void registerModels() {
        Main.proxy.registerItemRenderer(Item.func_150898_a((Block)this), 0, "inventory");
    }

    public ColoredLight produceColoredLight(World world, BlockPos pos, IBlockState state, float partialTicks) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && HyperLightingConfig.redstoneConfig.useColoredLight) {
            return ModUtils.getLight(this.lightColor, pos);
        }
        return null;
    }

    public int func_149750_m(IBlockState state) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && HyperLightingConfig.redstoneConfig.useVanillaLight) {
                return 15;
            }
            return 0;
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
                return 15;
            }
            return 0;
        }
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        Boolean powered = BooleanUtils.toBoolean((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)powered);
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && !worldIn.func_175640_z(pos)) {
                worldIn.func_175684_a(pos, (Block)this, 4);
            } else if (!((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && worldIn.func_175640_z(pos)) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && !worldIn.func_175640_z(pos)) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED});
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && !worldIn.func_175640_z(pos)) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)), 2);
            } else if (!((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && worldIn.func_175640_z(pos)) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        worldIn.func_175664_x(pos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!playerIn.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && playerIn.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemDye) {
            DyeUtil.doDyeCheck(worldIn, state, playerIn.func_184586_b(EnumHand.MAIN_HAND), pos);
        }
        return true;
    }

    @Override
    public void onDye(World world, IBlockState blockState, BlockPos pos) {
        world.func_180501_a(pos, blockState, 3);
    }
}

