/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.blocks;

import com.google.common.base.Predicate;
import com.zeitheron.hammercore.api.lighting.ColoredLight;
import com.zeitheron.hammercore.api.lighting.impl.IGlowingBlock;
import java.util.Random;
import javax.annotation.Nullable;
import net.hypherionmc.toggletorch.HyperLightingConfig;
import net.hypherionmc.toggletorch.Main;
import net.hypherionmc.toggletorch.init.HLBlocks;
import net.hypherionmc.toggletorch.init.HLItems;
import net.hypherionmc.toggletorch.particles.FlameEngine;
import net.hypherionmc.toggletorch.particles.ParticleEnum;
import net.hypherionmc.toggletorch.utils.IHasModel;
import net.hypherionmc.toggletorch.utils.ModUtils;
import net.hypherionmc.toggletorch.utils.dyes.DyeUtil;
import net.hypherionmc.toggletorch.utils.dyes.IDyeAble;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.BooleanUtils;

@Optional.Interface(iface="com.zeitheron.hammercore.api.lighting.impl.IGlowingBlock", modid="hammercore")
public class BlockLantern
extends Block
implements IHasModel,
IDyeAble,
IGlowingBlock {
    private static final AxisAlignedBB BB_TOP = new AxisAlignedBB(0.312, 0.0, 0.25, 0.688, 0.688, 0.688);
    private static final AxisAlignedBB BB_NORTH = new AxisAlignedBB(0.312, 0.188, 0.5, 0.688, 1.0, 1.062);
    private static final AxisAlignedBB BB_SOUTH = new AxisAlignedBB(0.312, 0.188, -0.062, 0.688, 1.0, 0.5);
    private static final AxisAlignedBB BB_EAST = new AxisAlignedBB(-0.062, 0.188, 0.312, 0.5, 1.0, 0.688);
    private static final AxisAlignedBB BB_WEST = new AxisAlignedBB(0.5, 0.188, 0.312, 1.062, 1.0, 0.688);
    private static final AxisAlignedBB BB_CEILING = new AxisAlignedBB(0.307, 0.188, 0.318, 0.744, 1.0, 0.693);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)new Predicate<EnumFacing>(){

        public boolean apply(@Nullable EnumFacing p_apply_1_) {
            return true;
        }
    });
    ParticleEnum particleEnum;

    public BlockLantern(String name, Material material, ParticleEnum flameParticle) {
        super(material);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(HyperLightingConfig.lanternConfig.onByDefault)));
        this.func_149675_a(true);
        this.func_149647_a(Main.lightingTab);
        this.particleEnum = flameParticle;
        HLBlocks.BLOCKS.add(this);
        HLItems.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        return state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)worldIn, pos);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : FACING.func_177700_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        BlockFaceShape blockfaceshape = iblockstate.func_193401_d((IBlockAccess)worldIn, blockpos, facing);
        if (facing.equals((Object)EnumFacing.UP) || facing.equals((Object)EnumFacing.DOWN) && this.canPlaceOn(worldIn, blockpos)) {
            return true;
        }
        if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return !BlockLantern.func_193382_c((Block)block) && blockfaceshape == BlockFaceShape.SOLID;
        }
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(HyperLightingConfig.lanternConfig.onByDefault));
        if (this.canPlaceAt(worldIn, pos, facing)) {
            return iblockstate.func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return iblockstate.func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        return iblockstate;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.checkForDrop(worldIn, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.onNeighborChangeInternal(worldIn, pos, state);
    }

    protected boolean onNeighborChangeInternal(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.checkForDrop(worldIn, pos, state)) {
            return true;
        }
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumFacing.Axis enumfacing$axis = enumfacing.func_176740_k();
        EnumFacing enumfacing1 = enumfacing.func_176734_d();
        BlockPos blockpos = pos.func_177972_a(enumfacing1);
        boolean flag = false;
        if (enumfacing$axis.func_176722_c() && worldIn.func_180495_p(blockpos).func_193401_d((IBlockAccess)worldIn, blockpos, enumfacing) != BlockFaceShape.SOLID) {
            flag = true;
        } else if (enumfacing$axis.func_176720_b() && !this.canPlaceOn(worldIn, blockpos)) {
            flag = true;
        }
        if (flag) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return true;
        }
        return false;
    }

    protected boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceAt(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        worldIn.func_175664_x(pos);
        EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)FACING);
        Boolean powerState = (Boolean)stateIn.func_177229_b((IProperty)POWERED);
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.7;
        double d2 = (double)pos.func_177952_p() + 0.5;
        double d3 = 0.22;
        double d4 = 0.27;
        if (enumfacing.func_176740_k().func_176722_c() && powerState.booleanValue()) {
            EnumFacing enumfacing1 = enumfacing.func_176734_d();
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.27 * (double)enumfacing1.func_82601_c(), d1 + 0.22, d2 + 0.27 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
            FlameEngine part = new FlameEngine(worldIn, d0 + 0.27 * (double)enumfacing1.func_82601_c(), d1 - (double)0.3f, d2 + 0.27 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, this.particleEnum, HyperLightingConfig.lanternConfig.useHDFlame);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)part);
        } else if (powerState.booleanValue() && enumfacing == EnumFacing.DOWN) {
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1 + (double)0.2f, d2, 0.0, 0.0, 0.0, new int[0]);
            FlameEngine part = new FlameEngine(worldIn, d0, d1 - (double)0.3f, d2, 0.0, 0.0, 0.0, this.particleEnum, HyperLightingConfig.lanternConfig.useHDFlame);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)part);
        } else if (powerState.booleanValue()) {
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            FlameEngine part = new FlameEngine(worldIn, d0, d1 - 0.5, d2, 0.0, 0.0, 0.0, this.particleEnum, HyperLightingConfig.lanternConfig.useHDFlame);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)part);
        }
    }

    public IBlockState func_176203_a(int meta) {
        Boolean powered = BooleanUtils.toBoolean((int)(meta / EnumFacing.values().length % 2));
        EnumFacing facing = EnumFacing.values()[meta % EnumFacing.values().length];
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)POWERED, (Comparable)powered);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        int powered = (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        int meta = powered * EnumFacing.values().length + facing.ordinal();
        return meta;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING))).func_177226_a((IProperty)POWERED, state.func_177229_b((IProperty)POWERED));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING))).func_177226_a((IProperty)POWERED, state.func_177229_b((IProperty)POWERED));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public void registerModels() {
        Main.proxy.registerItemRenderer(Item.func_150898_a((Block)this), 0, "inventory");
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            if (!playerIn.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && playerIn.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == HLItems.TORCH_LIGHTER || !HyperLightingConfig.lanternConfig.requiresTool) {
                state = state.func_177231_a((IProperty)POWERED);
                worldIn.func_180501_a(pos, state, 2);
                if (!((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.3f, 1.0f);
                }
                worldIn.func_175685_c(pos, (Block)this, false);
                return true;
            }
            if (!playerIn.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && playerIn.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemDye) {
                DyeUtil.doDyeCheck(worldIn, state, playerIn.func_184586_b(EnumHand.MAIN_HAND), pos);
            }
        }
        return true;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && HyperLightingConfig.lanternConfig.useVanillaLight) {
                return 14;
            }
            return 0;
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
                return 14;
            }
            return 0;
        }
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                return BB_EAST;
            }
            case WEST: {
                return BB_WEST;
            }
            case SOUTH: {
                return BB_SOUTH;
            }
            case NORTH: {
                return BB_NORTH;
            }
            case DOWN: {
                return BB_CEILING;
            }
        }
        return BB_TOP;
    }

    @Optional.Method(modid="hammercore")
    public ColoredLight produceColoredLight(World world, BlockPos blockPos, IBlockState iBlockState, float v) {
        if (((Boolean)iBlockState.func_177229_b((IProperty)POWERED)).booleanValue() && HyperLightingConfig.lanternConfig.useColoredLight) {
            return ModUtils.getLight(this.particleEnum, blockPos);
        }
        return null;
    }

    @Override
    public void onDye(World world, IBlockState blockState, BlockPos pos) {
        world.func_180501_a(pos, blockState, 3);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!worldIn.field_72995_K && HyperLightingConfig.lanternConfig.onByDefault) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
            worldIn.func_184138_a(pos, state, state, 4);
        }
    }
}

