/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.blocks;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.hypherionmc.toggletorch.Main;
import net.hypherionmc.toggletorch.References;
import net.hypherionmc.toggletorch.init.HLBlocks;
import net.hypherionmc.toggletorch.init.HLItems;
import net.hypherionmc.toggletorch.tileentities.TileFogMachine;
import net.hypherionmc.toggletorch.utils.IHasModel;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class BlockFogMachine
extends BlockContainer
implements IHasModel {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.304, 0.0, 0.121, 0.679, 0.328, 0.902);
    private static final AxisAlignedBB BOUNDING_BOX_INVERTED = new AxisAlignedBB(0.121, 0.0, 0.321, 0.902, 0.328, 0.696);

    public BlockFogMachine(String name) {
        super(Material.field_151574_g);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(Main.lightingMachineTab);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        HLItems.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(name));
        HLBlocks.BLOCKS.add((Block)this);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH || state.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            return BOUNDING_BOX;
        }
        return BOUNDING_BOX_INVERTED;
    }

    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flags) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            NBTTagCompound nbt = tagCompound.func_74775_l("tank");
            FluidStack fluidStack = null;
            if (!nbt.func_74764_b("Empty")) {
                fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
            }
            if (fluidStack == null) {
                tooltip.add("empty");
            } else {
                String name = fluidStack.getLocalizedName();
                tooltip.add(name + " (" + fluidStack.amount + ")");
            }
        }
    }

    @Override
    public void registerModels() {
        Main.proxy.registerItemRenderer(Item.func_150898_a((Block)this), 0, "inventory");
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileFogMachine();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && !FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (World)worldIn, (BlockPos)pos, (EnumFacing)facing)) {
            playerIn.openGui((Object)Main.instance, References.GUI_FOG_MACHINE, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing != EnumFacing.DOWN && enumfacing != EnumFacing.UP) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing face = placer.func_174811_aO();
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)face.func_176734_d());
    }
}

