/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.blocks;

import com.google.common.base.Predicate;
import com.zeitheron.hammercore.api.lighting.ColoredLight;
import com.zeitheron.hammercore.api.lighting.impl.IGlowingBlock;
import java.util.Random;
import javax.annotation.Nullable;
import net.hypherionmc.toggletorch.blocks.HLBaseBlock;
import net.hypherionmc.toggletorch.particles.ParticleEnum;
import net.hypherionmc.toggletorch.utils.IHasModel;
import net.hypherionmc.toggletorch.utils.ModUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.BooleanUtils;

@Optional.Interface(iface="com.zeitheron.hammercore.api.lighting.impl.IGlowingBlock", modid="hammercore")
public class BlockDiscoLight
extends HLBaseBlock
implements IHasModel,
IGlowingBlock {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)new Predicate<EnumFacing>(){

        public boolean apply(@Nullable EnumFacing p_apply_1_) {
            return true;
        }
    });
    protected static final AxisAlignedBB STANDING_AABB = new AxisAlignedBB(0.312, 0.0, 0.25, 0.688, 0.312, 0.75);
    protected static final AxisAlignedBB STANDING_AAB = new AxisAlignedBB(0.312, 0.781, 0.25, 0.688, 1.031, 0.75);
    protected int thisTick = 0;
    private ParticleEnum[] lights = ParticleEnum.values();
    private ParticleEnum curLight = this.lights[0];
    private int nextTick = 60;
    private Random rr = new Random();

    public BlockDiscoLight(String name, Material material) {
        super(name, material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                return STANDING_AABB;
            }
            case WEST: {
                return STANDING_AABB;
            }
            case SOUTH: {
                return STANDING_AABB;
            }
            case NORTH: {
                return STANDING_AABB;
            }
            case DOWN: {
                return STANDING_AAB;
            }
        }
        return STANDING_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        return state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)worldIn, pos);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : FACING.func_177700_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        BlockFaceShape blockfaceshape = iblockstate.func_193401_d((IBlockAccess)worldIn, blockpos, facing);
        if (facing.equals((Object)EnumFacing.UP) || facing.equals((Object)EnumFacing.DOWN) && this.canPlaceOn(worldIn, blockpos)) {
            return true;
        }
        if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return !BlockDiscoLight.func_193382_c((Block)block) && blockfaceshape == BlockFaceShape.SOLID;
        }
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
        if (this.canPlaceAt(worldIn, pos, facing)) {
            return iblockstate.func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return iblockstate.func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        return iblockstate;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.checkForDrop(worldIn, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.onNeighborChangeInternal(worldIn, pos, state);
    }

    protected boolean onNeighborChangeInternal(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.checkForDrop(worldIn, pos, state)) {
            return true;
        }
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumFacing.Axis enumfacing$axis = enumfacing.func_176740_k();
        EnumFacing enumfacing1 = enumfacing.func_176734_d();
        BlockPos blockpos = pos.func_177972_a(enumfacing1);
        boolean flag = false;
        if (enumfacing$axis.func_176722_c() && worldIn.func_180495_p(blockpos).func_193401_d((IBlockAccess)worldIn, blockpos, enumfacing) != BlockFaceShape.SOLID) {
            flag = true;
        } else if (enumfacing$axis.func_176720_b() && !this.canPlaceOn(worldIn, blockpos)) {
            flag = true;
        }
        if (flag) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return true;
        }
        return false;
    }

    protected boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceAt(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        Boolean powered = BooleanUtils.toBoolean((int)(meta / EnumFacing.values().length % 2));
        EnumFacing facing = EnumFacing.values()[meta % EnumFacing.values().length];
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)POWERED, (Comparable)powered);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        int powered = (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        int meta = powered * EnumFacing.values().length + facing.ordinal();
        return meta;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING))).func_177226_a((IProperty)POWERED, state.func_177229_b((IProperty)POWERED));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING))).func_177226_a((IProperty)POWERED, state.func_177229_b((IProperty)POWERED));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        state = state.func_177231_a((IProperty)POWERED);
        worldIn.func_180501_a(pos, state, 2);
        if (!((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 1.0f);
        } else {
            if (!Loader.isModLoaded((String)"lux")) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "[Hyper Lighting] " + TextFormatting.RESET + "Colored Lux is not installed. This light will just act like a normal light."));
            }
            worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 1.5f);
        }
        worldIn.func_175685_c(pos, (Block)this, false);
        return true;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 8;
        }
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    @Optional.Method(modid="hammercore")
    public ColoredLight produceColoredLight(World world, BlockPos blockPos, IBlockState iBlockState, float v) {
        ++this.thisTick;
        if (this.thisTick >= this.nextTick) {
            this.curLight = this.lights[this.rr.nextInt(this.lights.length)];
            this.nextTick = this.rr.nextInt(100);
            this.thisTick = 0;
        }
        if (((Boolean)iBlockState.func_177229_b((IProperty)POWERED)).booleanValue() && this.curLight != ParticleEnum.BLACK_FLAME) {
            return ModUtils.getLight(this.curLight, blockPos);
        }
        return null;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        Boolean powerState = (Boolean)state.func_177229_b((IProperty)POWERED);
    }
}

