/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.blocks;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.hypherionmc.toggletorch.HyperLightingConfig;
import net.hypherionmc.toggletorch.Main;
import net.hypherionmc.toggletorch.init.HLBlocks;
import net.hypherionmc.toggletorch.init.HLItems;
import net.hypherionmc.toggletorch.tileentities.TileCampFire;
import net.hypherionmc.toggletorch.utils.IHasModel;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.BooleanUtils;

public class BlockCampSoulFire
extends BlockContainer
implements IHasModel {
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyInteger LEVEL = PropertyInteger.func_177719_a((String)"level", (int)0, (int)15);
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.016, 0.0, 0.0, 0.984, 0.312, 1.0);

    public BlockCampSoulFire(String name) {
        super(Material.field_151586_h);
        this.setRegistryName(name);
        this.func_149663_c(name);
        this.func_149715_a(15.0f);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pick_axe", 2);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(Main.lightingTab);
        this.func_149675_a(true);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(HyperLightingConfig.campFireConfig.onByDefault)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
        HLItems.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(name));
        HLBlocks.BLOCKS.add((Block)this);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    @Override
    public void registerModels() {
        Main.proxy.registerItemRenderer(Item.func_150898_a((Block)this), 0, "inventory");
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            ItemStack itemStack;
            TileCampFire tileCampFire;
            TileEntity te;
            if (!playerIn.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && playerIn.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == HLItems.TORCH_LIGHTER || !HyperLightingConfig.campFireConfig.requiresTool) {
                state = state.func_177231_a((IProperty)LIT);
                worldIn.func_180501_a(pos, state, 2);
                if (!((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.3f, 1.0f);
                }
                worldIn.func_175685_c(pos, (Block)this, false);
                return true;
            }
            if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && (te = worldIn.func_175625_s(pos)) instanceof TileCampFire && (tileCampFire = (TileCampFire)te).findMatchingRecipe(itemStack = playerIn.func_184586_b(hand)) && ((TileCampFire)te).addItem(playerIn.func_184812_l_() ? itemStack.func_77946_l() : itemStack, 100)) {
                return true;
            }
        }
        return true;
    }

    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(new TextComponentTranslation("tooltip.camp_fire_soul", new Object[0]).func_150261_e());
        tooltip.add(new TextComponentTranslation("tooltip.camp_fire_soul_line1", new Object[0]).func_150261_e());
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        super.func_180634_a(worldIn, pos, state, entityIn);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_149750_m(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 15 : 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random random) {
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            if (random.nextInt(10) == 0) {
                worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
            }
            if (random.nextInt(5) == 0) {
                for (int i = 0; i < random.nextInt(1) + 1; ++i) {
                    worldIn.func_175688_a(EnumParticleTypes.LAVA, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), (double)(random.nextFloat() / 2.0f), 5.0E-5, (double)(random.nextFloat() / 2.0f), new int[0]);
                }
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        Boolean powered = BooleanUtils.toBoolean((int)(meta / EnumFacing.values().length % 2));
        EnumFacing facing = EnumFacing.values()[meta % EnumFacing.values().length];
        if (facing != EnumFacing.DOWN && facing != EnumFacing.UP) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)LIT, (Comparable)powered);
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)powered);
    }

    public int func_176201_c(IBlockState state) {
        int powered = (Boolean)state.func_177229_b((IProperty)LIT) != false ? 1 : 0;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        int meta = powered * EnumFacing.values().length + facing.ordinal();
        return meta;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LIT, LEVEL});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing face = placer.func_174811_aO();
        if (face == EnumFacing.NORTH || face == EnumFacing.EAST) {
            face = face.func_176734_d();
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)face);
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileCampFire();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!worldIn.field_72995_K && HyperLightingConfig.campFireConfig.onByDefault) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
            worldIn.func_184138_a(pos, state, state, 4);
        }
    }
}

