/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch;

import java.util.HashMap;
import java.util.List;
import net.hypherionmc.toggletorch.blocks.handheld.BlockHandheldTorch;
import net.hypherionmc.toggletorch.network.PacketHandler;
import net.hypherionmc.toggletorch.proxy.CommonProxy;
import net.hypherionmc.toggletorch.tabs.HyperLighting;
import net.hypherionmc.toggletorch.tabs.HyperLightingMachines;
import net.hypherionmc.toggletorch.utils.UpdateEngine;
import net.hypherionmc.toggletorch.utils.handlers.EventHandlers;
import net.hypherionmc.toggletorch.utils.handlers.RegistryHandler;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="hmctt", name="Hyper Lighting", version="1.12.2-1.5", acceptedMinecraftVersions="[1.12.2]", updateJSON="https://raw.githubusercontent.com/hypherionmc/hyperlighting_public/master/mod_version.json")
public class Main {
    @Mod.Instance
    public static Main instance;
    public static final CreativeTabs lightingTab;
    public static final CreativeTabs lightingMachineTab;
    public static final Logger logger;
    public static UpdateEngine checker;
    public static boolean haveWarnedVersionOutOfDate;
    public static boolean isDevBuild;
    public static HashMap<ChunkPos, Integer> ticketList;
    private static ForgeChunkManager.Ticket chunkLoaderTicket;
    @SidedProxy(clientSide="net.hypherionmc.toggletorch.proxy.ClientProxy", serverSide="net.hypherionmc.toggletorch.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public static void PreInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlers());
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        logger.info("Initializing Mod");
        String checkLux = Loader.isModLoaded((String)"lux") ? "Colored Lux is installed. Colored lighting will be supported" : "Colored Lux not found. Colored Lighting will not be supported";
        logger.info(checkLux);
        RegistryHandler.init();
        PacketHandler.registerMessages("hmctt");
        proxy.init();
    }

    @Mod.EventHandler
    public void PostInit(FMLPostInitializationEvent event) {
        logger.info("Mod Initialized");
        checker = new UpdateEngine();
        BlockHandheldTorch.initMapLightSources();
        HyperLighting.init();
        HyperLightingMachines.init();
        ticketList = new HashMap();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new ForgeChunkManager.LoadingCallback(){

            public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
            }
        });
    }

    public static void forceChunkLoad(World w, ChunkPos pos) {
        if (!ticketList.containsKey(pos)) {
            if (chunkLoaderTicket == null) {
                chunkLoaderTicket = ForgeChunkManager.requestTicket((Object)instance, (World)w, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            }
            ticketList.put(pos, 1);
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)chunkLoaderTicket, (ChunkPos)pos);
        } else {
            ticketList.put(pos, ticketList.get(pos) + 1);
        }
    }

    public static void releaseChunkLoad(World w, ChunkPos pos) {
        if (!ticketList.containsKey(pos) || chunkLoaderTicket == null) {
            return;
        }
        int num = ticketList.get(pos) - 1;
        if (num > 0) {
            ticketList.put(pos, num);
        } else {
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)chunkLoaderTicket, (ChunkPos)pos);
        }
    }

    static {
        lightingTab = new HyperLighting("hyperlights");
        lightingMachineTab = new HyperLightingMachines("hyperlightsmachines");
        logger = LogManager.getLogger((String)"hmctt");
        haveWarnedVersionOutOfDate = false;
        isDevBuild = true;
    }
}

