/*
 * Decompiled with CFR 0.152.
 */
package thaumicperiphery.items;

import baubles.api.IBauble;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumicperiphery.items.ItemBase;

public abstract class ItemAttributeBauble
extends ItemBase
implements IBauble {
    protected final Multimap<String, AttributeModifier> attributeMap = HashMultimap.create();

    public ItemAttributeBauble(String name) {
        super(name);
        this.func_77625_d(1);
    }

    public void onEquipped(ItemStack stack, EntityLivingBase player) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_110140_aT().func_111147_b(this.attributeMap);
        }
    }

    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_110140_aT().func_111148_a(this.attributeMap);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("");
        tooltip.add(I18n.func_135052_a((String)"bauble.worn", (Object[])new Object[0]));
        for (Map.Entry entry : this.attributeMap.entries()) {
            AttributeModifier modifier = (AttributeModifier)entry.getValue();
            int op = modifier.func_111169_c();
            double amount = modifier.func_111164_d();
            String name = "attribute.name." + (String)entry.getKey();
            if (op == 1) {
                amount *= 100.0;
            }
            if (modifier.func_111164_d() < 0.0) {
                tooltip.add(TextFormatting.RED + " " + I18n.func_135052_a((String)("attribute.modifier.take." + op), (Object[])new Object[]{ItemStack.field_111284_a.format(Math.abs(amount)), I18n.func_135052_a((String)name, (Object[])new Object[0])}));
                continue;
            }
            tooltip.add(TextFormatting.BLUE + " " + I18n.func_135052_a((String)("attribute.modifier.plus." + op), (Object[])new Object[]{ItemStack.field_111284_a.format(amount), I18n.func_135052_a((String)name, (Object[])new Object[0])}));
        }
    }
}

