/*
 * Decompiled with CFR 0.152.
 */
package thaumicperiphery.handler;

import java.awt.Color;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import teamroots.embers.util.EmberInventoryUtil;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.config.ModConfig;
import thaumicperiphery.Config;
import thaumicperiphery.items.ItemCasterElementium;
import thaumicperiphery.items.ItemCasterEmber;
import thaumicperiphery.util.ManaUtil;

@Mod.EventBusSubscriber(modid="thaumicperiphery", value={Side.CLIENT})
public class HUDHandler {
    public static final ResourceLocation TC_HUD = new ResourceLocation("thaumcraft", "textures/gui/hud.png");
    private static final DecimalFormat smallFormatter = new DecimalFormat("####");
    private static final DecimalFormat largeFormatter = new DecimalFormat("#.#k");

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc;
        if (event.phase != TickEvent.Phase.START && (mc = FMLClientHandler.instance().getClient()).func_175606_aa() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().func_175606_aa();
            long time = System.currentTimeMillis();
            if (player != null && mc.field_71415_G && Minecraft.func_71382_s()) {
                ItemStack stack = player.func_184614_ca();
                for (int i = 0; i < 2; ++i) {
                    if (Config.emberCaster && stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemCasterEmber) {
                        HUDHandler.renderEmberCasterHUD(mc, event.renderTickTime, player, time);
                        break;
                    }
                    if (Config.manaCaster && stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemCasterElementium) {
                        HUDHandler.renderManaCasterHUD(mc, event.renderTickTime, player, time);
                        break;
                    }
                    stack = player.func_184592_cb();
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderEmberCasterHUD(Minecraft mc, float renderTickTime, EntityPlayer player, long time) {
        int short1 = 240;
        int short2 = 240;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)short1 / 1.0f), (float)((float)short2 / 1.0f));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(mc);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.func_78327_c(), (double)sr.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        int l = sr.func_78328_b();
        int dialLocation = ModConfig.CONFIG_GRAPHICS.dialBottom ? l - 32 : 0;
        GL11.glTranslatef((float)0.0f, (float)dialLocation, (float)-2000.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        mc.field_71446_o.func_110577_a(TC_HUD);
        GL11.glTranslatef((float)16.0f, (float)16.0f, (float)0.0f);
        double max = EmberInventoryUtil.getEmberCapacityTotal((EntityPlayer)player);
        double amount = EmberInventoryUtil.getEmberTotal((EntityPlayer)player);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)16.0f, (float)-10.0f, (float)0.0f);
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int loc = (int)(30.0 * amount / max);
        GL11.glPushMatrix();
        Color ac = new Color(Aspect.FIRE.getColor());
        UtilsFX.drawTexturedQuad((float)-4.0f, (float)5.0f, (float)104.0f, (float)0.0f, (float)8.0f, (float)30.0f, (double)-90.0);
        GL11.glColor4f((float)((float)ac.getRed() / 255.0f), (float)((float)ac.getGreen() / 255.0f), (float)((float)ac.getBlue() / 255.0f), (float)0.8f);
        UtilsFX.drawTexturedQuad((float)-4.0f, (float)(35 - loc), (float)104.0f, (float)0.0f, (float)8.0f, (float)loc, (double)-90.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        UtilsFX.drawTexturedQuad((float)-8.0f, (float)-3.0f, (float)72.0f, (float)0.0f, (float)16.0f, (float)42.0f, (double)-90.0);
        GL11.glPopMatrix();
        boolean sh = false;
        if (player.func_70093_af()) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            String msg = MathHelper.func_76128_c((double)amount) > 9999 ? largeFormatter.format(amount / 1000.0) : smallFormatter.format(amount);
            mc.field_71456_v.func_73731_b(mc.field_71466_p, msg, -32, -4, 0xFFFFFF);
            GL11.glPopMatrix();
            mc.field_71446_o.func_110577_a(TC_HUD);
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderManaCasterHUD(Minecraft mc, float renderTickTime, EntityPlayer player, long time) {
        int short1 = 240;
        int short2 = 240;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)short1 / 1.0f), (float)((float)short2 / 1.0f));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(mc);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.func_78327_c(), (double)sr.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        int l = sr.func_78328_b();
        int dialLocation = ModConfig.CONFIG_GRAPHICS.dialBottom ? l - 32 : 0;
        GL11.glTranslatef((float)0.0f, (float)dialLocation, (float)-2000.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        mc.field_71446_o.func_110577_a(TC_HUD);
        GL11.glTranslatef((float)16.0f, (float)16.0f, (float)0.0f);
        double manaPercentage = ManaUtil.getStoredMana(player);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)16.0f, (float)-10.0f, (float)0.0f);
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int loc = (int)(30.0 * manaPercentage);
        GL11.glPushMatrix();
        Color ac = new Color(Aspect.ALCHEMY.getColor());
        UtilsFX.drawTexturedQuad((float)-4.0f, (float)5.0f, (float)104.0f, (float)0.0f, (float)8.0f, (float)30.0f, (double)-90.0);
        GL11.glColor4f((float)((float)ac.getRed() / 255.0f), (float)((float)ac.getGreen() / 255.0f), (float)((float)ac.getBlue() / 255.0f), (float)0.8f);
        UtilsFX.drawTexturedQuad((float)-4.0f, (float)(35 - loc), (float)104.0f, (float)0.0f, (float)8.0f, (float)loc, (double)-90.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        UtilsFX.drawTexturedQuad((float)-8.0f, (float)-3.0f, (float)72.0f, (float)0.0f, (float)16.0f, (float)42.0f, (double)-90.0);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }
}

