/*
 * Decompiled with CFR 0.152.
 */
package thaumicperiphery.entities;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.common.lib.SoundsTC;

public class EntityMagicArrow
extends EntityArrow {
    private static final Predicate<Entity> ARROW_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_.func_70067_L();
        }
    }});
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    private int inData;
    private int knockbackStrength;
    private int ticksInGround;
    private int ticksInAir;

    public EntityMagicArrow(World world) {
        super(world);
        this.func_70239_b(2.0);
        this.field_70178_ae = true;
        this.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
    }

    public EntityMagicArrow(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    public EntityMagicArrow(World world, EntityLivingBase shooter) {
        this(world, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - 0.1, shooter.field_70161_v);
        this.field_70250_c = shooter;
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        if (this.field_70254_i) {
            this.xTile = MathHelper.func_76128_c((double)this.field_70165_t);
            this.yTile = MathHelper.func_76128_c((double)this.field_70163_u);
            this.zTile = MathHelper.func_76128_c((double)this.field_70161_v);
        }
    }

    public void func_70071_h_() {
        AxisAlignedBB axisalignedbb;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        BlockPos blockpos = new BlockPos(this.xTile, this.yTile, this.zTile);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (iblockstate.func_185904_a() != Material.field_151579_a && (axisalignedbb = iblockstate.func_185890_d((IBlockAccess)this.field_70170_p, blockpos)) != Block.field_185506_k && axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.field_70254_i = true;
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.field_70254_i) {
            int j = block.func_176201_c(iblockstate);
            if (!(block == this.inTile && j == this.inData || this.field_70170_p.func_184143_b(this.func_174813_aQ().func_186662_g(0.05)))) {
                this.field_70254_i = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            } else {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1) {
                    if (this.field_70170_p.field_72995_K) {
                        this.createHitParticles();
                    }
                    this.func_70106_y();
                }
            }
            ++this.field_184552_b;
        } else {
            Entity entity;
            this.field_184552_b = 0;
            ++this.ticksInAir;
            Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
            vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (raytraceresult != null) {
                vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
            }
            if ((entity = this.func_184551_a(vec3d1, vec3d)) != null) {
                raytraceresult = new RayTraceResult(entity);
            }
            if (raytraceresult != null && raytraceresult.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)raytraceresult.field_72308_g;
                if (this.field_70250_c instanceof EntityPlayer && !((EntityPlayer)this.field_70250_c).func_96122_a(entityplayer)) {
                    raytraceresult = null;
                }
            }
            if (raytraceresult != null && !ForgeEventFactory.onProjectileImpact((EntityArrow)this, (RayTraceResult)raytraceresult)) {
                this.func_184549_a(raytraceresult);
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f4 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f4) * 57.29577951308232);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float f1 = 0.99f;
            float f2 = 0.05f;
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    float f3 = 0.25f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                f1 = 0.6f;
            }
            if (this.func_70026_G()) {
                this.func_70066_B();
            }
            this.field_70159_w *= (double)f1;
            this.field_70181_x *= (double)f1;
            this.field_70179_y *= (double)f1;
            if (!this.func_189652_ae()) {
                this.field_70181_x -= (double)0.05f;
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void createHitParticles() {
        int p = this.field_70146_Z.nextInt(7) + 9;
        for (int i = 0; i < 9; ++i) {
            FXGeneric fb = new FXGeneric(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextGaussian() * 0.05, this.field_70146_Z.nextGaussian() * 0.05, this.field_70146_Z.nextGaussian() * 0.05);
            fb.func_187114_a(15 + this.field_70146_Z.nextInt(20));
            if (this.func_70241_g()) {
                fb.func_70538_b(1.0f, 0.2f, 0.6f);
            } else {
                fb.func_70538_b(1.0f, 0.2f, 0.8f);
            }
            fb.func_82338_g(0.5f);
            fb.setGridSize(64);
            fb.setParticles(264, 8, 1);
            fb.setScale(new float[]{3.0f, 1.0f});
            fb.setLayer(0);
            fb.setSlowDown(1.0);
            fb.setGravity(0.1f);
            fb.setWind(0.001);
            ParticleEngine.addEffect((World)this.field_70170_p, (Particle)fb);
        }
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        Entity entity = raytraceResultIn.field_72308_g;
        if (entity != null) {
            DamageSource damagesource;
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            int i = MathHelper.func_76143_f((double)((double)f * this.func_70242_d()));
            if (this.func_70241_g()) {
                i += this.field_70146_Z.nextInt(i / 3 + 1);
            }
            if (entity.func_70097_a(damagesource = this.field_70250_c == null ? DamageSource.func_76354_b((Entity)this, (Entity)this) : DamageSource.func_76354_b((Entity)this, (Entity)this.field_70250_c), (float)i)) {
                if (entity instanceof EntityLivingBase) {
                    float f1;
                    EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                    if (this.knockbackStrength > 0 && (f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                        entitylivingbase.func_70024_g(this.field_70159_w * (double)this.knockbackStrength * (double)0.6f / (double)f1, 0.1, this.field_70179_y * (double)this.knockbackStrength * (double)0.6f / (double)f1);
                    }
                    if (this.field_70250_c instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)this.field_70250_c);
                        EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.field_70250_c), (Entity)entitylivingbase);
                    }
                    this.func_184548_a(entitylivingbase);
                    if (this.field_70250_c != null && entitylivingbase != this.field_70250_c && entitylivingbase instanceof EntityPlayer && this.field_70250_c instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)this.field_70250_c).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                    }
                }
                this.func_184185_a(SoundsTC.zap, 0.75f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                if (!(entity instanceof EntityEnderman)) {
                    this.func_70106_y();
                }
            } else {
                this.field_70159_w *= (double)-0.1f;
                this.field_70181_x *= (double)-0.1f;
                this.field_70179_y *= (double)-0.1f;
                this.field_70177_z += 180.0f;
                this.field_70126_B += 180.0f;
                this.ticksInAir = 0;
                if (!this.field_70170_p.field_72995_K && this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y < (double)0.001f) {
                    this.func_70106_y();
                }
            }
        } else {
            BlockPos blockpos = raytraceResultIn.func_178782_a();
            this.xTile = blockpos.func_177958_n();
            this.yTile = blockpos.func_177956_o();
            this.zTile = blockpos.func_177952_p();
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            this.inTile = iblockstate.func_177230_c();
            this.inData = this.inTile.func_176201_c(iblockstate);
            this.field_70159_w = (float)(raytraceResultIn.field_72307_f.field_72450_a - this.field_70165_t);
            this.field_70181_x = (float)(raytraceResultIn.field_72307_f.field_72448_b - this.field_70163_u);
            this.field_70179_y = (float)(raytraceResultIn.field_72307_f.field_72449_c - this.field_70161_v);
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            this.field_70165_t -= this.field_70159_w / (double)f2 * (double)0.05f;
            this.field_70163_u -= this.field_70181_x / (double)f2 * (double)0.05f;
            this.field_70161_v -= this.field_70179_y / (double)f2 * (double)0.05f;
            this.func_184185_a(SoundsTC.zap, 0.75f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.field_70254_i = true;
            this.field_70249_b = 7;
            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                this.inTile.func_180634_a(this.field_70170_p, blockpos, iblockstate, (Entity)this);
            }
        }
    }

    @Nullable
    protected Entity func_184551_a(Vec3d start, Vec3d end) {
        Entity entity = null;
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), ARROW_TARGETS);
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            Entity entity1 = (Entity)list.get(i);
            if (entity1 == this.field_70250_c && this.ticksInAir < 5 || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    public void func_70240_a(int knockbackStrengthIn) {
        super.func_70240_a(knockbackStrengthIn);
        this.knockbackStrength = knockbackStrengthIn;
    }

    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("xTile", this.xTile);
        compound.func_74768_a("yTile", this.yTile);
        compound.func_74768_a("zTile", this.zTile);
        compound.func_74777_a("life", (short)this.ticksInGround);
        ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.inTile);
        compound.func_74778_a("inTile", resourcelocation == null ? "" : resourcelocation.toString());
        compound.func_74774_a("inData", (byte)this.inData);
        compound.func_74774_a("shake", (byte)this.field_70249_b);
        compound.func_74774_a("inGround", (byte)(this.field_70254_i ? 1 : 0));
        compound.func_74774_a("pickup", (byte)this.field_70251_a.ordinal());
        compound.func_74780_a("damage", this.func_70242_d());
        compound.func_74757_a("crit", this.func_70241_g());
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.xTile = compound.func_74762_e("xTile");
        this.yTile = compound.func_74762_e("yTile");
        this.zTile = compound.func_74762_e("zTile");
        this.ticksInGround = compound.func_74765_d("life");
        this.inTile = compound.func_150297_b("inTile", 8) ? Block.func_149684_b((String)compound.func_74779_i("inTile")) : Block.func_149729_e((int)(compound.func_74771_c("inTile") & 0xFF));
        this.inData = compound.func_74771_c("inData") & 0xFF;
        this.field_70249_b = compound.func_74771_c("shake") & 0xFF;
        boolean bl = this.field_70254_i = compound.func_74771_c("inGround") == 1;
        if (compound.func_150297_b("damage", 99)) {
            this.func_70239_b(compound.func_74769_h("damage"));
        }
        if (compound.func_150297_b("pickup", 99)) {
            this.field_70251_a = EntityArrow.PickupStatus.func_188795_a((int)compound.func_74771_c("pickup"));
        } else if (compound.func_150297_b("player", 99)) {
            this.field_70251_a = compound.func_74767_n("player") ? EntityArrow.PickupStatus.ALLOWED : EntityArrow.PickupStatus.DISALLOWED;
        }
        this.func_70243_d(compound.func_74767_n("crit"));
    }
}

