/*
 * Decompiled with CFR 0.152.
 */
package thaumicperiphery;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectEventProxy;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.AspectRegistryEvent;
import thaumicperiphery.Config;
import thaumicperiphery.ThaumicPeriphery;
import thaumicperiphery.compat.MysticalMechanicsCompat;
import thaumicperiphery.crafting.PhantomInkRecipe;
import thaumicperiphery.entities.EntityMagicArrow;
import thaumicperiphery.items.ItemBase;
import thaumicperiphery.items.ItemCasterElementium;
import thaumicperiphery.items.ItemCasterEmber;
import thaumicperiphery.items.ItemMagicQuiver;
import thaumicperiphery.items.ItemMalignantHeart;
import thaumicperiphery.items.ItemPauldron;
import thaumicperiphery.items.ItemPauldronRepulsion;
import thaumicperiphery.items.ItemVisPhylactery;
import thaumicperiphery.render.LayerExtraBaubles;

@Mod.EventBusSubscriber(modid="thaumicperiphery")
@GameRegistry.ObjectHolder(value="thaumicperiphery")
public class ModContent {
    public static final Item caster_ember = null;
    public static final Item caster_elementium = null;
    public static final Item pauldron = null;
    public static final Item pauldron_repulsion = null;
    public static final Item malignant_heart = null;
    public static final Item magic_quiver = null;
    public static final Item vis_phylactery = null;
    public static final Item gear_brass = null;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        if (Config.emberCaster) {
            registry.register((IForgeRegistryEntry)new ItemCasterEmber());
        }
        if (Config.manaCaster) {
            registry.register((IForgeRegistryEntry)new ItemCasterElementium());
        }
        registry.register((IForgeRegistryEntry)new ItemPauldron());
        registry.register((IForgeRegistryEntry)new ItemPauldronRepulsion());
        registry.register((IForgeRegistryEntry)new ItemMalignantHeart());
        registry.register((IForgeRegistryEntry)new ItemMagicQuiver());
        registry.register((IForgeRegistryEntry)new ItemVisPhylactery());
        if (ThaumicPeriphery.mysticalMechanicsLoaded) {
            registry.register((IForgeRegistryEntry)new ItemBase("gear_brass"));
        }
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        int id = 0;
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(EntityMagicArrow.class).id(new ResourceLocation("thaumicperiphery", "magic_arrow"), id++).name("magic_arrow").tracker(64, 1, true).build());
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register(new ShapedOreRecipe(null, new ItemStack(pauldron), new Object[]{" PP", "PIL", "I B", Character.valueOf('P'), "plateIron", Character.valueOf('I'), "ingotIron", Character.valueOf('L'), "leather", Character.valueOf('B'), "ingotBrass"}).setRegistryName("thaumicperiphery", "pauldron"));
        if (ThaumicPeriphery.botaniaLoaded) {
            registry.register(new PhantomInkRecipe().setRegistryName("thaumicperiphery", "phantom_ink"));
        }
        if (ThaumicPeriphery.mysticalMechanicsLoaded) {
            MysticalMechanicsCompat.initRecipes(event);
        }
    }

    @SubscribeEvent
    public static void registerAspects(AspectRegistryEvent event) {
        AspectEventProxy registry = event.register;
        registry.registerComplexObjectTag(new ItemStack(pauldron), new AspectList().add(Aspect.PROTECT, 10));
        registry.registerComplexObjectTag(new ItemStack(pauldron_repulsion), new AspectList().add(Aspect.PROTECT, 15));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        if (Config.emberCaster) {
            ModelLoader.setCustomModelResourceLocation((Item)caster_ember, (int)0, (ModelResourceLocation)new ModelResourceLocation(caster_ember.getRegistryName().toString()));
        }
        if (Config.manaCaster) {
            ModelLoader.setCustomModelResourceLocation((Item)caster_elementium, (int)0, (ModelResourceLocation)new ModelResourceLocation(caster_elementium.getRegistryName().toString()));
        }
        ModelLoader.setCustomModelResourceLocation((Item)pauldron, (int)0, (ModelResourceLocation)new ModelResourceLocation(pauldron.getRegistryName().toString()));
        ModelLoader.setCustomModelResourceLocation((Item)pauldron_repulsion, (int)0, (ModelResourceLocation)new ModelResourceLocation(pauldron_repulsion.getRegistryName().toString()));
        ModelLoader.setCustomModelResourceLocation((Item)malignant_heart, (int)0, (ModelResourceLocation)new ModelResourceLocation(malignant_heart.getRegistryName().toString()));
        ModelLoader.setCustomModelResourceLocation((Item)magic_quiver, (int)0, (ModelResourceLocation)new ModelResourceLocation(magic_quiver.getRegistryName().toString()));
        ModelLoader.setCustomModelResourceLocation((Item)vis_phylactery, (int)0, (ModelResourceLocation)new ModelResourceLocation(vis_phylactery.getRegistryName().toString()));
        if (ThaumicPeriphery.mysticalMechanicsLoaded) {
            ModelLoader.setCustomModelResourceLocation((Item)gear_brass, (int)0, (ModelResourceLocation)new ModelResourceLocation(gear_brass.getRegistryName().toString()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        LayerExtraBaubles.visAmuletSprite = event.getMap().func_174942_a(new ResourceLocation("thaumicperiphery", "model/vis_amulet"));
    }
}

