/*
 * Decompiled with CFR 0.152.
 */
package com.mujmajnkraft.bettersurvival.items;

import com.google.common.collect.Multimap;
import com.mujmajnkraft.bettersurvival.Bettersurvival;
import com.mujmajnkraft.bettersurvival.ICustomWeapon;
import com.mujmajnkraft.bettersurvival.config.ConfigHandler;
import com.mujmajnkraft.bettersurvival.entities.projectiles.EntityFlyingSpear;
import com.mujmajnkraft.bettersurvival.init.ModItems;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemSpear
extends Item
implements ICustomWeapon {
    private final float attackDamage;
    private Item.ToolMaterial mat;

    public ItemSpear(Item.ToolMaterial material) {
        this.setRegistryName("Item" + material.name().toLowerCase() + "Spear");
        this.func_77655_b(material.name().toLowerCase() + "spear");
        this.field_77777_bU = 16;
        this.attackDamage = (float)(0.75 * (double)(3.0f + material.func_78000_c()));
        this.func_77637_a(CreativeTabs.field_78037_j);
        this.mat = material;
    }

    public Item.ToolMaterial getMaterial() {
        return this.mat;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        boolean flag = playerIn.field_71075_bZ.field_75098_d;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (!itemstack.func_190926_b() || flag) {
            float f = 1.0f;
            boolean flag1 = playerIn.field_71075_bZ.field_75098_d;
            if (!worldIn.field_72995_K) {
                EntityFlyingSpear entityspear = new EntityFlyingSpear(worldIn, (EntityLivingBase)playerIn);
                ItemStack itemstack1 = itemstack.func_77946_l();
                itemstack1.func_190920_e(1);
                entityspear.setSpear(itemstack1);
                entityspear.func_184547_a((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, f * 2.0f, 1.0f);
                ItemSpear spear = (ItemSpear)itemstack.func_77973_b();
                entityspear.func_70239_b((double)(spear.getMaterial().func_78000_c() + 3.0f) * 0.75);
                entityspear.field_70251_a = flag1 ? EntityArrow.PickupStatus.CREATIVE_ONLY : EntityArrow.PickupStatus.ALLOWED;
                worldIn.func_72838_d((Entity)entityspear);
            }
            worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            if (!flag1) {
                playerIn.func_184586_b(handIn).func_190918_g(1);
            }
            playerIn.func_71029_a(StatList.func_188057_b((Item)this));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    @Override
    public float getReach() {
        return 7.0f;
    }

    @Override
    public boolean noSweepAttack() {
        return false;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public float breakChance() {
        return 32.0f / (float)this.mat.func_77997_a();
    }

    public CreativeTabs func_77640_w() {
        if (this.getMaterial() == Item.ToolMaterial.DIAMOND || this.getMaterial() == Item.ToolMaterial.GOLD || this.getMaterial() == Item.ToolMaterial.IRON || this.getMaterial() == Item.ToolMaterial.STONE || this.getMaterial() == Item.ToolMaterial.WOOD) {
            return super.func_77640_w();
        }
        if ((this.getMaterial() == ModItems.JUNGLE_CHITIN || this.getMaterial() == ModItems.DESERT_CHITIN || this.getMaterial() == ModItems.DRAGON_BONE) && Bettersurvival.isIafLoaded && ConfigHandler.integration) {
            return super.func_77640_w();
        }
        if (ConfigHandler.integration && !OreDictionary.getOres((String)("ingot" + this.getMaterial().name())).isEmpty()) {
            return super.func_77640_w();
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.mat == ModItems.SILVER && Bettersurvival.isIafLoaded) {
            String s = I18n.func_74838_a((String)"silvertools.hurt");
            tooltip.add(TextFormatting.GREEN + s);
        } else if (this.mat == ModItems.JUNGLE_CHITIN || this.mat == ModItems.DESERT_CHITIN) {
            String s = I18n.func_74838_a((String)"mujmajnkraftsbettersurvival.chitintools.hurt");
            tooltip.add(TextFormatting.GREEN + s);
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (this.mat == ModItems.SILVER && Bettersurvival.isIafLoaded) {
            if (target.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
                target.func_70097_a(DamageSource.field_76376_m, 2.0f);
                target.field_70172_ad = 0;
            }
        } else if ((this.mat == ModItems.DESERT_CHITIN || this.mat == ModItems.JUNGLE_CHITIN) && target.func_70668_bt() != EnumCreatureAttribute.ARTHROPOD) {
            target.field_70172_ad = 0;
            target.func_70097_a(DamageSource.field_76376_m, 4.0f);
        }
        return super.func_77644_a(stack, target, attacker);
    }
}

