/*
 * Decompiled with CFR 0.152.
 */
package com.mujmajnkraft.bettersurvival.items;

import com.google.common.collect.Multimap;
import com.mujmajnkraft.bettersurvival.Bettersurvival;
import com.mujmajnkraft.bettersurvival.CrushingRecipe;
import com.mujmajnkraft.bettersurvival.ICustomWeapon;
import com.mujmajnkraft.bettersurvival.config.ConfigHandler;
import com.mujmajnkraft.bettersurvival.init.ModEnchantments;
import com.mujmajnkraft.bettersurvival.init.ModItems;
import com.mujmajnkraft.bettersurvival.init.ModPotions;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.block.BlockGlass;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentSweepingEdge;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemHammer
extends ItemSword
implements ICustomWeapon {
    private int stunduration;
    private Item.ToolMaterial mat;

    public ItemHammer(Item.ToolMaterial material) {
        super(material);
        this.setRegistryName("Item" + material.name().toLowerCase() + "Hammer");
        this.func_77655_b(material.name().toLowerCase() + "hammer");
        this.mat = material;
        this.stunduration = 20;
    }

    public Item.ToolMaterial getMaterial() {
        return this.mat;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            this.replaceModifier((Multimap<String, AttributeModifier>)modifiers, SharedMonsterAttributes.field_111264_e, field_111210_e, 1.2);
            this.replaceModifier((Multimap<String, AttributeModifier>)modifiers, SharedMonsterAttributes.field_188790_f, field_185050_h, 1.35);
        }
        return modifiers;
    }

    private void replaceModifier(Multimap<String, AttributeModifier> modifierMultimap, IAttribute attribute, UUID id, double multiplier) {
        Collection modifiers = modifierMultimap.get((Object)attribute.func_111108_a());
        Optional<AttributeModifier> modifierOptional = modifiers.stream().filter(attributeModifier -> attributeModifier.func_111167_a().equals(id)).findFirst();
        if (modifierOptional.isPresent()) {
            AttributeModifier modifier = modifierOptional.get();
            modifiers.remove(modifier);
            modifiers.add(new AttributeModifier(modifier.func_111167_a(), modifier.func_111166_b(), modifier.func_111164_d() * multiplier, modifier.func_111169_c()));
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.OFF_HAND) {
            return EnumActionResult.FAIL;
        }
        float d = Math.min(this.func_150931_i(), 9.0f) + 1.0f;
        double xd = 1.0;
        double yd = 1.0;
        double zd = 1.0;
        if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
            xd += 9.0;
            zd += 9.0;
        } else if (facing == EnumFacing.EAST || facing == EnumFacing.WEST) {
            yd += 9.0;
            zd += 9.0;
        } else if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
            xd += 9.0;
            yd += 9.0;
        }
        for (EntityLivingBase entitylivingbase : playerIn.func_130014_f_().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos).func_72314_b(xd, yd, zd))) {
            if (entitylivingbase == playerIn || !(entitylivingbase.func_174818_b(pos) < (double)(2.0f * d)) || !entitylivingbase.field_70122_E) continue;
            entitylivingbase.func_70653_a((Entity)playerIn, 0.4f, (double)MathHelper.func_76126_a((float)(playerIn.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(playerIn.field_70177_z * ((float)Math.PI / 180)))));
            entitylivingbase.func_70097_a(DamageSource.func_76365_a((EntityPlayer)playerIn), (float)((double)(this.func_150931_i() + 3.0f) * (1.0 - entitylivingbase.func_174818_b(pos) / 20.0)));
            PotionEffect potioneffectIn = new PotionEffect(ModPotions.stun, (int)((double)this.stunduration * (1.0 - entitylivingbase.func_174818_b(pos) / 20.0)));
            entitylivingbase.func_70690_d(potioneffectIn);
        }
        for (int x = -5; x < 6; ++x) {
            if ((facing == EnumFacing.WEST || facing == EnumFacing.EAST) && x != 0 || !playerIn.field_71075_bZ.field_75099_e) continue;
            for (float y = -d; y < 6.0f; y += 1.0f) {
                if ((facing == EnumFacing.UP || facing == EnumFacing.DOWN) && y != 0.0f) continue;
                for (int z = -5; z < 6; ++z) {
                    BlockPos pos2;
                    if ((facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) && z != 0 || !((float)(x * x) + y * y + (float)(z * z) <= 2.0f * d)) continue;
                    boolean particles = (float)(x * x) + y * y + (float)(z * z) >= 2.0f * (d - 2.0f);
                    BlockPos position = pos.func_177963_a((double)x, (double)y, (double)z);
                    if (worldIn.func_180495_p(position.func_177972_a(facing)).func_177230_c() instanceof BlockGlass) {
                        worldIn.func_175655_b(position.func_177972_a(facing), true);
                    }
                    if (worldIn.func_180495_p(position.func_177972_a(facing.func_176734_d())).func_177230_c() instanceof BlockGlass) {
                        worldIn.func_175655_b(position.func_177972_a(facing.func_176734_d()), true);
                    }
                    if (worldIn.func_180495_p(position).func_177230_c() instanceof BlockGlass) {
                        worldIn.func_175655_b(position, true);
                    }
                    if (worldIn.func_180495_p(position.func_177972_a(facing)).isSideSolid((IBlockAccess)worldIn, position, EnumFacing.UP)) {
                        pos2 = position.func_177972_a(facing);
                        if (worldIn.func_180495_p(pos2.func_177972_a(facing)).isSideSolid((IBlockAccess)worldIn, pos2, EnumFacing.UP)) continue;
                        CrushingRecipe.Crush(playerIn, pos2, particles);
                        continue;
                    }
                    if (!worldIn.func_180495_p(position).isSideSolid((IBlockAccess)worldIn, position, EnumFacing.UP)) {
                        pos2 = position.func_177972_a(facing.func_176734_d());
                        CrushingRecipe.Crush(playerIn, pos2, particles);
                        continue;
                    }
                    CrushingRecipe.Crush(playerIn, position, particles);
                }
            }
        }
        if (!playerIn.func_184812_l_()) {
            playerIn.func_184586_b(hand).func_77972_a(10, (EntityLivingBase)playerIn);
        }
        worldIn.func_184133_a(null, pos, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
        if (!playerIn.field_71075_bZ.field_75098_d) {
            for (ItemHammer hammer : ModItems.hammers) {
                playerIn.func_184811_cZ().func_185145_a((Item)hammer, 200);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment instanceof EnchantmentSweepingEdge) {
            return false;
        }
        return enchantment.field_77351_y.func_77557_a(stack.func_77973_b());
    }

    @Override
    public float getReach() {
        return 0.0f;
    }

    @Override
    public boolean noSweepAttack() {
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if ((double)player.func_184825_o(0.5f) > 0.9 && entity instanceof EntityLivingBase) {
            int l = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.bash, (ItemStack)stack);
            if (player.func_70681_au().nextInt(20) < 2 + l && !entity.func_190530_aW()) {
                EntityLivingBase living = (EntityLivingBase)entity;
                PotionEffect potioneffectIn = new PotionEffect(ModPotions.stun, this.stunduration);
                living.func_70690_d(potioneffectIn);
            }
            player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            AttributeModifier modifier = new AttributeModifier(UUID.fromString("a6107045-134f-4c04-a645-75c3ae5c7a27"), "compensation", 4.0, 2);
            if (!player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_180374_a(modifier)) {
                player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(modifier);
            }
            player.func_184821_cY();
        }
        return false;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        target.func_70653_a((Entity)attacker, 0.5f, (double)MathHelper.func_76126_a((float)(attacker.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(attacker.field_70177_z * ((float)Math.PI / 180)))));
        if (this.mat == ModItems.SILVER && Bettersurvival.isIafLoaded) {
            if (target.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
                target.field_70172_ad = 0;
                target.func_70097_a(DamageSource.field_76376_m, 2.0f);
            }
        } else if ((this.mat == ModItems.DESERT_CHITIN || this.mat == ModItems.JUNGLE_CHITIN) && target.func_70668_bt() != EnumCreatureAttribute.ARTHROPOD) {
            target.field_70172_ad = 0;
            target.func_70097_a(DamageSource.field_76376_m, 4.0f);
        }
        return super.func_77644_a(stack, target, attacker);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        if (ConfigHandler.integration && OreDictionary.doesOreNameExist((String)("ingot" + this.getMaterial().name()))) {
            for (ItemStack stack : OreDictionary.getOres((String)("ingot" + this.getMaterial().name()))) {
                if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)repair, (boolean)false)) continue;
                return true;
            }
        }
        return super.func_82789_a(toRepair, repair);
    }

    public CreativeTabs func_77640_w() {
        if (this.getMaterial() == Item.ToolMaterial.DIAMOND || this.getMaterial() == Item.ToolMaterial.GOLD || this.getMaterial() == Item.ToolMaterial.IRON || this.getMaterial() == Item.ToolMaterial.STONE || this.getMaterial() == Item.ToolMaterial.WOOD) {
            return super.func_77640_w();
        }
        if ((this.getMaterial() == ModItems.JUNGLE_CHITIN || this.getMaterial() == ModItems.DESERT_CHITIN || this.getMaterial() == ModItems.DRAGON_BONE) && Bettersurvival.isIafLoaded && ConfigHandler.integration) {
            return super.func_77640_w();
        }
        if (ConfigHandler.integration && !OreDictionary.getOres((String)("ingot" + this.getMaterial().name())).isEmpty()) {
            return super.func_77640_w();
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.mat == ModItems.SILVER && Bettersurvival.isIafLoaded) {
            String s = I18n.func_74838_a((String)"silvertools.hurt");
            tooltip.add(TextFormatting.GREEN + s);
        } else if (this.mat == ModItems.JUNGLE_CHITIN || this.mat == ModItems.DESERT_CHITIN) {
            String s = I18n.func_74838_a((String)"mujmajnkraftsbettersurvival.chitintools.hurt");
            tooltip.add(TextFormatting.GREEN + s);
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

