/*
 * Decompiled with CFR 0.152.
 */
package com.mujmajnkraft.bettersurvival.eventhandlers;

import com.mujmajnkraft.bettersurvival.ICustomWeapon;
import com.mujmajnkraft.bettersurvival.capabilities.nunchakucombo.INunchakuCombo;
import com.mujmajnkraft.bettersurvival.capabilities.nunchakucombo.NunchakuComboProwider;
import com.mujmajnkraft.bettersurvival.capabilities.spearsinentity.ISpearsIn;
import com.mujmajnkraft.bettersurvival.capabilities.spearsinentity.SpearsInProvider;
import com.mujmajnkraft.bettersurvival.capabilities.weaponeffect.IWeaponEffect;
import com.mujmajnkraft.bettersurvival.capabilities.weaponeffect.WeaponEffectProvider;
import com.mujmajnkraft.bettersurvival.entities.siegeweapons.EntityPotionThrower;
import com.mujmajnkraft.bettersurvival.entities.siegeweapons.EntitySiegeWeapon;
import com.mujmajnkraft.bettersurvival.init.ModBlocks;
import com.mujmajnkraft.bettersurvival.init.ModEnchantments;
import com.mujmajnkraft.bettersurvival.init.ModPotions;
import com.mujmajnkraft.bettersurvival.items.ItemDagger;
import com.mujmajnkraft.bettersurvival.items.ItemNunchaku;
import com.mujmajnkraft.bettersurvival.items.ItemSpear;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModWeaponHandler {
    public static final ResourceLocation SPEARSIN_CAP = new ResourceLocation("mujmajnkraftsbettersurvival", "spearsin");
    public static final ResourceLocation WEAPONEWWECT_CAP = new ResourceLocation("mujmajnkraftsbettersurvival", "weaponeff");
    public static final ResourceLocation NUNCHAKUCOMBO_CAP = new ResourceLocation("mujmajnkraftsbettersurvival", "nunchakucombo");

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntityPlayer().func_184187_bx() instanceof EntityPotionThrower) {
            EntityPotionThrower thrower = (EntityPotionThrower)event.getEntityPlayer().func_184187_bx();
            if (event.getItemStack().func_77973_b() != Items.field_185155_bH && event.getItemStack().func_77973_b() != Items.field_185156_bI || thrower.load(event.getItemStack())) {
                // empty if block
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(PlayerInteractEvent.EntityInteract event) {
        if (event.getItemStack().func_77973_b() == Items.field_151058_ca && event.getTarget() instanceof EntitySiegeWeapon) {
            EntitySiegeWeapon entity = (EntitySiegeWeapon)event.getTarget();
            if (entity.isPullable) {
                double i = entity.field_70165_t;
                double j = entity.field_70163_u;
                double k = entity.field_70161_v;
                for (EntityLiving entityliving : event.getWorld().func_72872_a(EntityLiving.class, new AxisAlignedBB(i - 7.0, j - 7.0, k - 7.0, i + 7.0, j + 7.0, k + 7.0))) {
                    if (!entityliving.func_110167_bD() || entityliving.func_110166_bE() != event.getEntityPlayer() || !(entityliving instanceof EntityHorse)) continue;
                    entityliving.func_110160_i(true, false);
                    entityliving.func_110162_b((Entity)entity, true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        if (living instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_188479_b(UUID.fromString("a6107045-134f-4c04-a645-75c3ae5c7a27"));
            if (player.hasCapability(NunchakuComboProwider.NUNCHAKUCOMBO_CAP, null)) {
                INunchakuCombo combo = (INunchakuCombo)player.getCapability(NunchakuComboProwider.NUNCHAKUCOMBO_CAP, null);
                if (player.func_184614_ca().func_77973_b() instanceof ItemNunchaku) {
                    if (combo.getComboPower() > 0.0f) {
                        combo.countDown();
                    }
                } else {
                    combo.setComboTime(0);
                }
            }
        } else if (event.getEntityLiving() instanceof EntityLiving) {
            event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111265_b).func_188479_b(UUID.fromString("a6107045-134f-4c14-a645-75c3ae5c7a27"));
            if (!event.getEntityLiving().func_70651_bq().isEmpty()) {
                Collection effects = event.getEntityLiving().func_70651_bq();
                for (PotionEffect effect : effects) {
                    if (effect.func_76453_d() != "effect.blindness") continue;
                    AttributeModifier modifier = new AttributeModifier(UUID.fromString("a6107045-134f-4c14-a645-75c3ae5c7a27"), "blind", -0.8, 1);
                    event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(modifier);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onEvent(LivingAttackEvent event) {
        if (event.getSource().func_76364_f() != null) {
            EntityPlayer player;
            if (event.getSource().func_76364_f() instanceof EntityLivingBase) {
                EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76364_f();
                if (attacker.func_184614_ca().func_77973_b() instanceof ItemSpear && attacker instanceof EntityPlayer && !((EntityPlayer)attacker).field_71075_bZ.field_75098_d && ((ItemSpear)attacker.func_184614_ca().func_77973_b()).breakChance() >= attacker.func_70681_au().nextFloat()) {
                    attacker.func_184614_ca().func_190918_g(1);
                }
                if (attacker.func_184614_ca().func_77973_b() instanceof ItemSword && !attacker.field_70170_p.field_72995_K) {
                    IWeaponEffect poison = (IWeaponEffect)attacker.func_184614_ca().getCapability(WeaponEffectProvider.WEAPONEFFECT_CAP, null);
                    int h = 0;
                    if (attacker.func_184614_ca().func_77942_o()) {
                        NBTTagCompound compound = attacker.func_184614_ca().func_77978_p();
                        if (compound.func_74764_b("remainingHits")) {
                            // empty if block
                        }
                        if ((h = compound.func_74762_e("remainingHits")) > 0 && event.getEntityLiving().field_70172_ad < 10) {
                            for (PotionEffect effect : PotionUtils.func_185189_a((ItemStack)attacker.func_184614_ca())) {
                                if (effect.func_188419_a().func_76403_b()) {
                                    effect.func_188419_a().func_180793_a(null, event.getSource().func_76364_f(), event.getEntityLiving(), effect.func_76458_c(), 0.16666666666666666);
                                    event.getEntityLiving().field_70172_ad = 0;
                                    continue;
                                }
                                event.getEntityLiving().func_70690_d(new PotionEffect(effect.func_188419_a(), effect.func_76459_b() / 8, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
                            }
                            if (attacker instanceof EntityPlayer && !((EntityPlayer)attacker).field_71075_bZ.field_75098_d) {
                                compound.func_74768_a("remainingHits", h - 1);
                            }
                            if (h - 1 <= 0) {
                                compound.func_82580_o("Potion");
                                compound.func_82580_o("CustomPotionEffects");
                            }
                        }
                    }
                }
            }
            if (event.getSource().func_76364_f() instanceof EntityPlayer && (player = (EntityPlayer)event.getSource().func_76364_f()).func_184614_ca().func_77973_b() instanceof ICustomWeapon) {
                ICustomWeapon weapon = (ICustomWeapon)player.func_184614_ca().func_77973_b();
                if (event.getAmount() == 1.0f && weapon.noSweepAttack()) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onEvent(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving().func_70660_b(ModPotions.stun) != null) {
            event.getEntityLiving().field_70181_x = 0.0;
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onAttachCapabilityEntityEvent(AttachCapabilitiesEvent<Entity> event) {
        if (!((Entity)event.getObject()).hasCapability(SpearsInProvider.SPEARSIN_CAP, null) && event.getObject() instanceof EntityLivingBase) {
            event.addCapability(SPEARSIN_CAP, (ICapabilityProvider)new SpearsInProvider());
        }
        if (!((Entity)event.getObject()).hasCapability(NunchakuComboProwider.NUNCHAKUCOMBO_CAP, null) && event.getObject() instanceof EntityLivingBase) {
            event.addCapability(NUNCHAKUCOMBO_CAP, (ICapabilityProvider)new NunchakuComboProwider());
        }
        if (!((Entity)event.getObject()).hasCapability(WeaponEffectProvider.WEAPONEFFECT_CAP, null) && event.getObject() instanceof EntityLivingBase) {
            event.addCapability(WEAPONEWWECT_CAP, (ICapabilityProvider)new WeaponEffectProvider());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onEvent(LivingHurtEvent event) {
        EntityLivingBase living;
        Entity entitysource = event.getSource().func_76364_f();
        if (entitysource instanceof EntityLivingBase && !entitysource.field_70170_p.field_72995_K && (living = (EntityLivingBase)entitysource).func_184614_ca() != null) {
            EntityPlayer player;
            if (living.func_184614_ca().func_77973_b() instanceof ItemDagger) {
                double attackerYaw = Math.toRadians(living.field_70177_z);
                double targetYaw = Math.toRadians(event.getEntity().field_70177_z);
                if (Math.abs(Math.sin(attackerYaw) - Math.sin(targetYaw)) < 0.5 && Math.abs(Math.cos(attackerYaw) - Math.cos(targetYaw)) < 0.5) {
                    int l = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.assassinate, (ItemStack)living.func_184614_ca());
                    float newdamage = event.getAmount() * (float)(2 + l / 3);
                    event.setAmount(newdamage);
                }
            }
            if (entitysource instanceof EntityPlayer && (player = (EntityPlayer)event.getSource().func_76364_f()).func_184614_ca().func_77973_b() instanceof ItemNunchaku && player.hasCapability(NunchakuComboProwider.NUNCHAKUCOMBO_CAP, null)) {
                INunchakuCombo combo = (INunchakuCombo)player.getCapability(NunchakuComboProwider.NUNCHAKUCOMBO_CAP, null);
                event.setAmount(event.getAmount() * (1.0f + combo.getComboPower()));
                int l = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.combo, (EntityLivingBase)player);
                combo.setComboPower(combo.getComboPower() + 0.1f + (float)l / 20.0f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onEvent(LivingDeathEvent event) {
        ISpearsIn spearsIn = (ISpearsIn)event.getEntity().getCapability(SpearsInProvider.SPEARSIN_CAP, null);
        ArrayList<ItemStack> spears = spearsIn.getSpearsIn();
        if (!spears.isEmpty()) {
            for (ItemStack spear : spears) {
                event.getEntity().func_70099_a(spear, 0.0f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(EnderTeleportEvent event) {
        if (event.getEntityLiving().func_70660_b(ModPotions.antiwarp) != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack() != ItemStack.field_190927_a) {
            Item item = event.getItemStack().func_77973_b();
            IBlockState state = event.getWorld().func_180495_p(event.getPos());
            if (!(state.func_177230_c() != Blocks.field_150383_bp || event.getWorld().field_72995_K || Integer.valueOf((Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a)) != 0 || item != Items.field_151117_aB && (item != Items.field_151068_bn || PotionUtils.func_185189_a((ItemStack)event.getItemStack()).isEmpty() && PotionUtils.func_185191_c((ItemStack)event.getItemStack()) == PotionTypes.field_185230_b))) {
                event.getWorld().func_175656_a(event.getPos(), ModBlocks.customcauldron.func_176223_P());
            }
        }
    }
}

