/*
 * Decompiled with CFR 0.152.
 */
package com.mujmajnkraft.bettersurvival.eventhandlers;

import com.mujmajnkraft.bettersurvival.init.ModEnchantments;
import com.mujmajnkraft.bettersurvival.items.ItemCustomShield;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.command.AdvancementCommand;
import net.minecraft.command.CommandException;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModShieldHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(LivingHurtEvent event) {
        float amount = event.getAmount();
        DamageSource source = event.getSource();
        if (event.getAmount() > 0.0f && this.canBlockDamageSource(source, event.getEntityLiving())) {
            Entity entity;
            int l;
            ItemCustomShield shield = (ItemCustomShield)event.getEntityLiving().func_184607_cu().func_77973_b();
            if (!source.func_76363_c()) {
                l = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.blockpower, (ItemStack)event.getEntityLiving().func_184607_cu());
                event.setAmount(amount * (1.0f - shield.blockpower) / (float)(1 + l));
                if (event.getEntityLiving() instanceof EntityPlayer) {
                    this.damageShield(amount, (EntityPlayer)event.getEntityLiving());
                }
            } else {
                l = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.spellshield, (ItemStack)event.getEntityLiving().func_184607_cu());
                if (l > 0) {
                    event.setAmount(amount * (1.0f - shield.blockpower * ((float)l / 3.0f)));
                    if (event.getEntityLiving() instanceof EntityPlayer) {
                        this.damageShield(amount, (EntityPlayer)event.getEntityLiving());
                    }
                }
            }
            if (!source.func_76352_a() && (entity = source.func_76364_f()) instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70653_a((Entity)event.getEntityLiving(), 0.5f, event.getEntityLiving().field_70165_t - entity.field_70165_t, event.getEntityLiving().field_70161_v - entity.field_70161_v);
            }
        }
    }

    protected void damageShield(float damage, EntityPlayer player) {
        if (damage >= 3.0f && player.func_184607_cu().func_77973_b() instanceof ItemCustomShield) {
            ItemStack copyBeforeUse = player.func_184607_cu().func_77946_l();
            int i = 1 + MathHelper.func_76141_d((float)damage);
            player.func_184607_cu().func_77972_a(i, (EntityLivingBase)player);
            if (player.func_184607_cu().func_190926_b()) {
                EnumHand enumhand = player.func_184600_cs();
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copyBeforeUse, (EnumHand)enumhand);
                if (enumhand == EnumHand.MAIN_HAND) {
                    player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                } else {
                    player.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                }
                player.func_184602_cy();
                player.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    private boolean canBlockDamageSource(DamageSource damageSourceIn, EntityLivingBase entity) {
        Vec3d vec3d;
        if (entity.func_184607_cu().func_77973_b() instanceof ItemCustomShield && (vec3d = damageSourceIn.func_188404_v()) != null) {
            Vec3d vec3d1 = entity.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.func_184607_cu().func_77973_b() instanceof ItemCustomShield) {
                AttributeModifier KRmodifier = new AttributeModifier(ItemCustomShield.knockbackModifierUUID, "shield_knockback_adjustment", 1.0, 0);
                if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.heavy, (ItemStack)player.func_184607_cu()) > 0) {
                    if (!player.func_110148_a(SharedMonsterAttributes.field_111266_c).func_180374_a(KRmodifier)) {
                        player.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(KRmodifier);
                    }
                } else {
                    player.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111124_b(KRmodifier);
                }
                int l = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.weightless, (ItemStack)player.func_184607_cu());
                int w = ((ItemCustomShield)player.func_184607_cu().func_77973_b()).getWeight();
                float i = w - 2 * l >= 0 ? (float)(w - 2 * l) : 0.0f;
                double multiplyer = Math.pow(2.0, 1.0f - i) - 1.0;
                AttributeModifier speedmodifier = new AttributeModifier(ItemCustomShield.weightModifierUUID, "shield_speed_adjustment", multiplyer, 2);
                if (!player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_180374_a(speedmodifier)) {
                    player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(speedmodifier);
                } else if (player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(ItemCustomShield.weightModifierUUID).func_111164_d() != multiplyer) {
                    player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(ItemCustomShield.weightModifierUUID);
                    player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(speedmodifier);
                }
            } else {
                player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(ItemCustomShield.knockbackModifierUUID);
                player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(ItemCustomShield.weightModifierUUID);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onEvent(LivingAttackEvent event) {
        if (!event.getEntityLiving().func_184607_cu().func_190926_b() && event.getSource().func_76364_f() instanceof EntityArrow && this.canBlockDamageSource(event.getSource(), event.getEntityLiving())) {
            if (event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187767_eL, SoundCategory.PLAYERS, 0.8f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                ItemStack copyBeforeUse = player.func_184607_cu().func_77946_l();
                player.func_184607_cu().func_77972_a(1, (EntityLivingBase)player);
                if (player instanceof EntityPlayerMP) {
                    EntityPlayerMP playerMP = (EntityPlayerMP)player;
                    try {
                        this.grantAdvancement(playerMP);
                    }
                    catch (CommandException e) {
                        e.printStackTrace();
                    }
                }
                if (player.func_184607_cu().func_190926_b()) {
                    EnumHand enumhand = player.func_184600_cs();
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copyBeforeUse, (EnumHand)enumhand);
                    if (enumhand == EnumHand.MAIN_HAND) {
                        player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                    } else {
                        player.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                    }
                    player.func_184602_cy();
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187769_eM, SoundCategory.PLAYERS, 0.8f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                }
            }
            event.setCanceled(true);
        }
    }

    public void grantAdvancement(EntityPlayerMP playerMP) throws CommandException {
        AdvancementProgress progress = playerMP.func_192039_O().func_192747_a(AdvancementCommand.func_192551_a((MinecraftServer)playerMP.func_184102_h(), (String)"minecraft:story/deflect_arrow"));
        for (String s : progress.func_192107_d()) {
            playerMP.func_192039_O().func_192750_a(AdvancementCommand.func_192551_a((MinecraftServer)playerMP.func_184102_h(), (String)"minecraft:story/deflect_arrow"), s);
        }
    }
}

