/*
 * Decompiled with CFR 0.152.
 */
package magicbees.integration.railcraft;

import javax.annotation.Nullable;
import magicbees.MagicBees;
import magicbees.api.ITransmutationHandler;
import magicbees.api.module.IMagicBeesInitialisationEvent;
import magicbees.api.module.IMagicBeesModule;
import magicbees.api.module.MagicBeesModule;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

@MagicBeesModule(owner="magicbees", name="Railcraft Integration", modDependencies="railcraft")
public class IntegrationRailcraft
implements IMagicBeesModule {
    private Block quarried;
    private Block abyssal;

    @Override
    public void init(IMagicBeesInitialisationEvent event) {
        this.quarried = event.getBlock("brick_quarried");
        this.abyssal = event.getBlock("brick_abyssal");
        MagicBees.transmutationController.addTransmutationHandler(new ITransmutationHandler(){

            @Override
            public boolean transmute(World world, BlockPos pos, ItemStack block, Biome biome) {
                IBlockState state;
                BlockStone.EnumType type = null;
                boolean hT = false;
                if (block.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150348_b)) {
                    state = Blocks.field_150348_b.func_176203_a(block.func_77960_j());
                    type = (BlockStone.EnumType)state.func_177229_b((IProperty)BlockStone.field_176247_a);
                    hT = true;
                }
                if (block.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150347_e)) {
                    hT = true;
                }
                if (hT && (state = IntegrationRailcraft.this.trySpawnRC(biome, type)) != null) {
                    world.func_180501_a(pos, state, 3);
                    return true;
                }
                return false;
            }
        });
    }

    private IBlockState trySpawnRC(Biome biome, @Nullable BlockStone.EnumType type) {
        int meta;
        int n = type == null ? 5 : (meta = type == BlockStone.EnumType.STONE ? 2 : -1);
        if (meta < 0) {
            return null;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            return this.quarried.func_176203_a(meta);
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) && !biome.func_185359_l().toLowerCase().contains("river")) {
            return this.abyssal.func_176203_a(meta);
        }
        return null;
    }
}

