/*
 * Decompiled with CFR 0.152.
 */
package magicbees.integration.botania;

import com.google.common.collect.Lists;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.ISpeciesType;
import java.util.ArrayList;
import java.util.List;
import magicbees.bees.EnumBeeSpecies;
import net.minecraft.item.ItemStack;
import vazkii.botania.api.recipe.RecipeElvenTrade;

public class RecipeElvenTradeBeeSpecies
extends RecipeElvenTrade {
    private IAlleleBeeSpecies inputSpecies;

    public RecipeElvenTradeBeeSpecies(EnumBeeSpecies inSpecies, EnumBeeSpecies outSpecies) {
        super(new ItemStack[]{BeeManager.beeRoot.getMemberStack(outSpecies.getIndividual(), (ISpeciesType)EnumBeeType.DRONE)}, new Object[]{BeeManager.beeRoot.getMemberStack(inSpecies.getIndividual(), (ISpeciesType)EnumBeeType.DRONE)});
        this.inputSpecies = inSpecies.getSpecies();
    }

    public boolean matches(List<ItemStack> stacks, boolean removeMatched) {
        ArrayList matchedStacks = Lists.newArrayList();
        boolean found = false;
        for (ItemStack inStack : stacks) {
            IBee bee;
            if (inStack == null || !BeeManager.beeRoot.isMember(inStack, (ISpeciesType)EnumBeeType.DRONE) || (bee = BeeManager.beeRoot.getMember(inStack)) == null || !bee.getGenome().getPrimary().equals(this.inputSpecies)) continue;
            matchedStacks.add(inStack);
            found = true;
            break;
        }
        if (removeMatched) {
            for (ItemStack stack : matchedStacks) {
                stacks.remove(stack);
            }
        }
        return found;
    }
}

