/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.wire;

import buildcraft.api.transport.EnumWirePart;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public enum EnumWireBetween {
    X_UP_SOUTH(EnumFacing.Axis.X, true, true),
    X_UP_NORTH(EnumFacing.Axis.X, true, false),
    X_DOWN_SOUTH(EnumFacing.Axis.X, false, true),
    X_DOWN_NORTH(EnumFacing.Axis.X, false, false),
    Y_SOUTH_EAST(EnumFacing.Axis.Y, true, true),
    Y_SOUTH_WEST(EnumFacing.Axis.Y, true, false),
    Y_NORTH_EAST(EnumFacing.Axis.Y, false, true),
    Y_NORTH_WEST(EnumFacing.Axis.Y, false, false),
    Z_UP_EAST(EnumFacing.Axis.Z, true, true),
    Z_UP_WEST(EnumFacing.Axis.Z, true, false),
    Z_DOWN_EAST(EnumFacing.Axis.Z, false, true),
    Z_DOWN_WEST(EnumFacing.Axis.Z, false, false),
    EAST_UP_SOUTH(EnumFacing.EAST, true, true),
    EAST_UP_NORTH(EnumFacing.EAST, true, false),
    EAST_DOWN_SOUTH(EnumFacing.EAST, false, true),
    EAST_DOWN_NORTH(EnumFacing.EAST, false, false),
    WEST_UP_SOUTH(EnumFacing.WEST, true, true),
    WEST_UP_NORTH(EnumFacing.WEST, true, false),
    WEST_DOWN_SOUTH(EnumFacing.WEST, false, true),
    WEST_DOWN_NORTH(EnumFacing.WEST, false, false),
    UP_SOUTH_EAST(EnumFacing.UP, true, true),
    UP_SOUTH_WEST(EnumFacing.UP, true, false),
    UP_NORTH_EAST(EnumFacing.UP, false, true),
    UP_NORTH_WEST(EnumFacing.UP, false, false),
    DOWN_SOUTH_EAST(EnumFacing.DOWN, true, true),
    DOWN_SOUTH_WEST(EnumFacing.DOWN, true, false),
    DOWN_NORTH_EAST(EnumFacing.DOWN, false, true),
    DOWN_NORTH_WEST(EnumFacing.DOWN, false, false),
    SOUTH_UP_EAST(EnumFacing.SOUTH, true, true),
    SOUTH_UP_WEST(EnumFacing.SOUTH, true, false),
    SOUTH_DOWN_EAST(EnumFacing.SOUTH, false, true),
    SOUTH_DOWN_WEST(EnumFacing.SOUTH, false, false),
    NORTH_UP_EAST(EnumFacing.NORTH, true, true),
    NORTH_UP_WEST(EnumFacing.NORTH, true, false),
    NORTH_DOWN_EAST(EnumFacing.NORTH, false, true),
    NORTH_DOWN_WEST(EnumFacing.NORTH, false, false);

    public static final EnumWireBetween[] VALUES;
    public static final EnumWireBetween[] CENTRES;
    public static final EnumWireBetween[] CONNECTIONS;
    public final EnumFacing.Axis mainAxis;
    public final EnumFacing to;
    public final boolean xy;
    public final boolean yz;
    public final AxisAlignedBB boundingBox;
    public final EnumWirePart[] parts;

    private EnumWireBetween(EnumFacing.Axis mainAxis, boolean xy, boolean yz) {
        int y1;
        int x1;
        this.mainAxis = mainAxis;
        this.to = null;
        this.xy = xy;
        this.yz = yz;
        int n2 = mainAxis == EnumFacing.Axis.X ? 4 : (x1 = xy ? 12 : 3);
        int n3 = mainAxis == EnumFacing.Axis.Y ? 4 : ((mainAxis == EnumFacing.Axis.X ? xy : yz) ? 12 : (y1 = 3));
        int z1 = mainAxis == EnumFacing.Axis.Z ? 4 : (yz ? 12 : 3);
        int x2 = x1 + (mainAxis == EnumFacing.Axis.X ? 8 : 1);
        int y2 = y1 + (mainAxis == EnumFacing.Axis.Y ? 8 : 1);
        int z2 = z1 + (mainAxis == EnumFacing.Axis.Z ? 8 : 1);
        this.boundingBox = new AxisAlignedBB((double)x1 / 16.0, (double)y1 / 16.0, (double)z1 / 16.0, (double)x2 / 16.0, (double)y2 / 16.0, (double)z2 / 16.0);
        this.parts = this.getParts();
    }

    private EnumWireBetween(EnumFacing to, boolean xy, boolean yz) {
        int y1;
        int x1;
        int start;
        this.mainAxis = to.func_176740_k();
        this.to = to;
        this.xy = xy;
        this.yz = yz;
        int n2 = start = to.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 13 : 0;
        int n3 = this.mainAxis == EnumFacing.Axis.X ? start : (x1 = xy ? 12 : 3);
        int n4 = this.mainAxis == EnumFacing.Axis.Y ? start : ((this.mainAxis == EnumFacing.Axis.X ? xy : yz) ? 12 : (y1 = 3));
        int z1 = this.mainAxis == EnumFacing.Axis.Z ? start : (yz ? 12 : 3);
        int x2 = x1 + (this.mainAxis == EnumFacing.Axis.X ? 3 : 1);
        int y2 = y1 + (this.mainAxis == EnumFacing.Axis.Y ? 3 : 1);
        int z2 = z1 + (this.mainAxis == EnumFacing.Axis.Z ? 3 : 1);
        this.boundingBox = new AxisAlignedBB((double)x1 / 16.0, (double)y1 / 16.0, (double)z1 / 16.0, (double)x2 / 16.0, (double)y2 / 16.0, (double)z2 / 16.0);
        this.parts = this.getParts();
    }

    private EnumWirePart[] getParts() {
        Function<EnumFacing.AxisDirection[], EnumWirePart> getPartFromDirections = directions -> Arrays.stream(EnumWirePart.VALUES).filter(part -> part.x == directions[0] && part.y == directions[1] && part.z == directions[2]).findFirst().orElse(null);
        EnumWirePart[] arr = new EnumWirePart[2];
        for (int i = 0; i < arr.length; ++i) {
            EnumFacing.AxisDirection[] directions2 = new EnumFacing.AxisDirection[3];
            boolean found = false;
            for (int j = 0; j < directions2.length; ++j) {
                if (this.mainAxis.ordinal() == j) {
                    if (this.to == null) {
                        directions2[j] = i == 0 ? EnumFacing.AxisDirection.NEGATIVE : EnumFacing.AxisDirection.POSITIVE;
                        continue;
                    }
                    directions2[j] = i == 0 ? this.to.func_176743_c() : this.to.func_176734_d().func_176743_c();
                    continue;
                }
                if (!found) {
                    directions2[j] = this.xy ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE;
                    found = true;
                    continue;
                }
                directions2[j] = this.yz ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE;
            }
            arr[i] = getPartFromDirections.apply(directions2);
        }
        return arr;
    }

    static {
        VALUES = EnumWireBetween.values();
        CENTRES = (EnumWireBetween[])Arrays.copyOfRange(VALUES, 0, 12, EnumWireBetween[].class);
        CONNECTIONS = (EnumWireBetween[])Arrays.copyOfRange(VALUES, 12, 36, EnumWireBetween[].class);
    }
}

