/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts;

import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.font.IFontRenderer;
import buildcraft.lib.client.guide.parts.GuidePart;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Gui;

public class GuidePartCodeBlock
extends GuidePart {
    public final List<String> lines;

    public GuidePartCodeBlock(GuiGuide gui, List<String> lines) {
        super(gui);
        this.lines = lines;
    }

    @Override
    public GuidePart.PagePosition renderIntoArea(int x, int y, int width, int height, GuidePart.PagePosition current, int index) {
        IFontRenderer font = this.gui.getCurrentFont();
        ArrayList<String> wrappedLines = new ArrayList<String>();
        TIntArrayList lineNumbers = new TIntArrayList();
        int lineNumberWidth = font.getStringWidth(Integer.toString(this.lines.size() - 1));
        int widthForDecoration = 8 + lineNumberWidth;
        int innerMaxWidth = 0;
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = this.lines.get(i);
            List<String> wrapped = font.wrapString(line, width - widthForDecoration, false, 1.0f);
            wrappedLines.addAll(wrapped);
            for (int j = 0; j < wrapped.size(); ++j) {
                lineNumbers.add(j == 0 ? i + 1 : -1);
                innerMaxWidth = Math.max(innerMaxWidth, font.getStringWidth(wrapped.get(j)));
            }
        }
        int innerHeight = wrappedLines.size() * (font.getMaxFontHeight() + 2);
        int outerHeight = innerHeight + 6;
        current = current.guaranteeSpace(outerHeight, height);
        if (index == current.page) {
            int outerWidth = innerMaxWidth + 8;
            int _y = y + current.pixel;
            GuiGuide.BOX_CODE_SLICED.draw(x + lineNumberWidth + 5, _y, outerWidth, outerHeight);
            _y += 4;
            boolean darken = true;
            for (int i = 0; i < wrappedLines.size(); ++i) {
                String line = (String)wrappedLines.get(i);
                int number = lineNumbers.get(i);
                if (number != -1) {
                    boolean bl = darken = !darken;
                    if (wrappedLines.size() > 1) {
                        String ns = Integer.toString(number);
                        int addX = lineNumberWidth - font.getStringWidth(ns);
                        font.drawString(ns, x + 4 + addX, _y, 0);
                    }
                }
                int _x = x + 8 + lineNumberWidth;
                if (darken) {
                    Gui.func_73734_a((int)(_x - 2), (int)(_y - 1), (int)(_x + innerMaxWidth + 4), (int)(_y + font.getMaxFontHeight() + 1), (int)-986896);
                }
                font.drawString(line, _x, _y, 0);
                _y += font.getMaxFontHeight() + 2;
            }
        }
        current = current.nextLine(outerHeight, height);
        return current;
    }

    @Override
    public GuidePart.PagePosition handleMouseClick(int x, int y, int width, int height, GuidePart.PagePosition current, int index, int mouseX, int mouseY) {
        return this.renderIntoArea(x, y, width, height, current, -1);
    }
}

