/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.parser.variables;

import cofh.cofhworld.data.numbers.ConstantProvider;
import cofh.cofhworld.data.numbers.INumberProvider;
import cofh.cofhworld.data.numbers.operation.BoundedProvider;
import cofh.cofhworld.data.numbers.operation.MathProvider;
import cofh.cofhworld.data.numbers.random.SkellamRandomProvider;
import cofh.cofhworld.data.numbers.random.UniformRandomProvider;
import cofh.cofhworld.data.numbers.world.WorldValueProvider;
import cofh.shade.com.typesafe.config.Config;
import cofh.shade.com.typesafe.config.ConfigObject;
import cofh.shade.com.typesafe.config.ConfigValue;

public class NumberData {
    public static INumberProvider parseNumberValue(ConfigValue numberEntry) {
        switch (numberEntry.valueType()) {
            case NUMBER: {
                return new ConstantProvider((Number)numberEntry.unwrapped());
            }
            case OBJECT: {
                ConfigObject numberProps = (ConfigObject)numberEntry;
                Config numberObject = ((ConfigObject)numberEntry).toConfig();
                switch (numberProps.size()) {
                    case 1: {
                        if (numberProps.containsKey("value")) {
                            return new ConstantProvider(numberObject.getNumber("value"));
                        }
                        if (numberProps.containsKey("variance")) {
                            return new SkellamRandomProvider(NumberData.parseNumberValue(numberObject.getValue("variance")));
                        }
                        if (!numberProps.containsKey("world-data")) break;
                        return new WorldValueProvider(numberObject.getString("world-data"));
                    }
                    case 2: {
                        if (!numberProps.containsKey("min") || !numberProps.containsKey("max")) break;
                        return new UniformRandomProvider(NumberData.parseNumberValue(numberObject.getValue("min")), NumberData.parseNumberValue(numberObject.getValue("max")));
                    }
                    case 3: {
                        if (numberProps.containsKey("operation") && numberProps.containsKey("value-a") && numberProps.containsKey("value-b")) {
                            INumberProvider a = NumberData.parseNumberValue(numberObject.getValue("value-a"));
                            INumberProvider b = NumberData.parseNumberValue(numberObject.getValue("value-b"));
                            return new MathProvider(a, b, numberObject.getString("operation"));
                        }
                        if (!numberProps.containsKey("value") || !numberProps.containsKey("min") || !numberProps.containsKey("max")) break;
                        INumberProvider v = NumberData.parseNumberValue(numberObject.getValue("value"));
                        INumberProvider a = NumberData.parseNumberValue(numberObject.getValue("min"));
                        INumberProvider b = NumberData.parseNumberValue(numberObject.getValue("max"));
                        return new BoundedProvider(v, a, b);
                    }
                    default: {
                        throw new Error(String.format("Too many properties on object at line %s", numberEntry.origin().lineNumber()));
                    }
                    case 0: 
                }
                throw new Error(String.format("Unknown properties on object at line %s", numberEntry.origin().lineNumber()));
            }
        }
        throw new Error(String.format("Unsupported data type at line %s", numberEntry.origin().lineNumber()));
    }

    public static INumberProvider parseNumberValue(ConfigValue numberEntry, Number min, Number max) {
        return new BoundedProvider(NumberData.parseNumberValue(numberEntry), new ConstantProvider(min), new ConstantProvider(max));
    }
}

