/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.tileentity;

import com.clussmanproductions.trafficcontrol.blocks.BlockType3BarrierBase;
import com.clussmanproductions.trafficcontrol.tileentity.SignTileEntity;
import com.clussmanproductions.trafficcontrol.tileentity.SyncableTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Type3BarrierTileEntity
extends SyncableTileEntity {
    private boolean renderSign;
    private SignType signType = SignType.RoadClosed;
    private boolean renderThisSign;
    private int thisSignType;
    private int thisSignVariant;

    public boolean getRenderSign() {
        return this.renderSign;
    }

    public SignType getSignType() {
        return this.signType;
    }

    public boolean getRenderThisSign() {
        return this.renderThisSign;
    }

    public int getThisSignType() {
        return this.thisSignType;
    }

    public int getThisSignVariant() {
        return this.thisSignVariant;
    }

    public void setRenderSign(boolean renderSign) {
        boolean shouldMarkDirty = renderSign != this.renderSign;
        this.renderSign = renderSign;
        if (shouldMarkDirty) {
            this.func_70296_d();
            if (this.field_145850_b != null) {
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            }
        }
    }

    public void setSignType(SignType signType) {
        boolean doMarkDirty = signType != this.signType;
        this.signType = signType;
        if (doMarkDirty) {
            this.func_70296_d();
            if (this.field_145850_b != null) {
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            }
        }
    }

    public void setRenderThisSign(boolean renderThisSign) {
        boolean shouldMarkDirty = renderThisSign != this.renderThisSign;
        this.renderThisSign = renderThisSign;
        if (shouldMarkDirty) {
            this.func_70296_d();
            if (this.field_145850_b != null) {
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            }
        }
    }

    public void setThisSignType(int thisSignType) {
        boolean shouldMarkDirty = thisSignType != this.thisSignType;
        this.thisSignType = thisSignType;
        if (shouldMarkDirty) {
            this.func_70296_d();
            if (this.field_145850_b != null) {
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            }
        }
    }

    public void setThisSignVariant(int thisSignVariant) {
        if (thisSignVariant > (Integer)SignTileEntity.MAX_VARIANTS_BY_TYPE.get((Object)this.getThisSignType())) {
            switch (this.getThisSignType()) {
                case 0: {
                    thisSignVariant = 114;
                    break;
                }
                case 1: {
                    thisSignVariant = 162;
                    break;
                }
                case 2: {
                    thisSignVariant = 119;
                    break;
                }
                case 3: {
                    thisSignVariant = 91;
                    break;
                }
                case 4: {
                    thisSignVariant = 168;
                    break;
                }
                case 5: {
                    thisSignVariant = 96;
                }
            }
        }
        boolean shouldMarkDirty = thisSignVariant != this.thisSignVariant;
        this.thisSignVariant = thisSignVariant;
        if (shouldMarkDirty) {
            this.func_70296_d();
            if (this.field_145850_b != null) {
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            }
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.setRenderSign(compound.func_74767_n("renderSign"));
        this.setSignType(SignType.getByIndex(compound.func_74762_e("signType")));
        this.setRenderThisSign(compound.func_74767_n("renderThisSign"));
        this.setThisSignType(compound.func_74762_e("thisSignType"));
        this.setThisSignVariant(compound.func_74762_e("thisSignVariant"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("renderSign", this.getRenderSign());
        compound.func_74768_a("signType", this.signType.index);
        compound.func_74757_a("renderThisSign", this.getRenderThisSign());
        compound.func_74768_a("thisSignType", this.getThisSignType());
        compound.func_74768_a("thisSignVariant", this.getThisSignVariant());
        return super.func_189515_b(compound);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        nbt.func_74757_a("renderSign", this.renderSign);
        nbt.func_74768_a("signType", this.signType.index);
        nbt.func_74757_a("renderThisSign", this.getRenderThisSign());
        nbt.func_74768_a("thisSignType", this.getThisSignType());
        nbt.func_74768_a("thisSignVariant", this.getThisSignVariant());
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.setRenderSign(tag.func_74767_n("renderSign"));
        this.setSignType(SignType.getByIndex(tag.func_74762_e("signType")));
        this.setRenderThisSign(tag.func_74767_n("renderThisSign"));
        this.setThisSignType(tag.func_74762_e("thisSignType"));
        this.setThisSignVariant(tag.func_74762_e("thisSignVariant"));
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    @Override
    public NBTTagCompound getClientToServerUpdateTag() {
        return this.func_189517_E_();
    }

    @Override
    public void handleClientToServerUpdateTag(NBTTagCompound compound) {
        this.handleUpdateTag(compound);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return !(newSate.func_177230_c() instanceof BlockType3BarrierBase);
    }

    public Type3BarrierTileEntity findFurthestLeft() {
        BlockPos workingPos = this.field_174879_c.func_185334_h();
        IBlockState currentState = this.field_145850_b.func_180495_p(workingPos).func_185899_b((IBlockAccess)this.field_145850_b, workingPos);
        Block currentStateBlockInstance = ((BlockType3BarrierBase)currentState.func_177230_c()).getBlockInstance();
        EnumFacing facing = (EnumFacing)currentState.func_177229_b((IProperty)BlockType3BarrierBase.FACING);
        while (currentState.func_177230_c() == currentStateBlockInstance && !((Boolean)currentState.func_177229_b((IProperty)BlockType3BarrierBase.ISFURTHESTLEFT)).booleanValue()) {
            workingPos = workingPos.func_177972_a(facing.func_176735_f());
            currentState = this.field_145850_b.func_180495_p(workingPos).func_185899_b((IBlockAccess)this.field_145850_b, workingPos);
        }
        return (Type3BarrierTileEntity)this.field_145850_b.func_175625_s(workingPos);
    }

    public void syncConnectedBarriers(boolean doClientToServerSync) {
        Type3BarrierTileEntity barrierTE;
        TileEntity teInPos;
        BlockPos workingPos = this.findFurthestLeft().func_174877_v();
        IBlockState currentState = this.field_145850_b.func_180495_p(workingPos).func_185899_b((IBlockAccess)this.field_145850_b, workingPos);
        Block currentStateBlockInstance = ((BlockType3BarrierBase)currentState.func_177230_c()).getBlockInstance();
        EnumFacing facing = (EnumFacing)currentState.func_177229_b((IProperty)BlockType3BarrierBase.FACING);
        while (currentState.func_177230_c() == currentStateBlockInstance && !((Boolean)currentState.func_177229_b((IProperty)BlockType3BarrierBase.ISFURTHESTRIGHT)).booleanValue()) {
            teInPos = this.field_145850_b.func_175625_s(workingPos);
            if (teInPos instanceof Type3BarrierTileEntity) {
                barrierTE = (Type3BarrierTileEntity)teInPos;
                barrierTE.setRenderSign(this.getRenderSign());
                barrierTE.setSignType(this.getSignType());
                if (doClientToServerSync) {
                    barrierTE.performClientToServerSync();
                }
            }
            workingPos = workingPos.func_177972_a(facing.func_176746_e());
            currentState = this.field_145850_b.func_180495_p(workingPos).func_185899_b((IBlockAccess)this.field_145850_b, workingPos);
        }
        teInPos = this.field_145850_b.func_175625_s(workingPos);
        if (teInPos instanceof Type3BarrierTileEntity) {
            barrierTE = (Type3BarrierTileEntity)teInPos;
            barrierTE.setRenderSign(this.getRenderSign());
            barrierTE.setSignType(this.getSignType());
            if (doClientToServerSync) {
                barrierTE.performClientToServerSync();
            }
        }
    }

    public void nextSignType() {
        int nextIndex = this.getSignType().index + 1;
        if (nextIndex > SignType.getMaxIndex()) {
            nextIndex = 0;
        }
        this.setSignType(SignType.getByIndex(nextIndex));
    }

    public void prevSignType() {
        int nextIndex = this.getSignType().index - 1;
        if (nextIndex < 0) {
            nextIndex = SignType.getMaxIndex();
        }
        this.setSignType(SignType.getByIndex(nextIndex));
    }

    public double func_145833_n() {
        return 262144.0;
    }

    public static enum SignType {
        RoadClosed(0),
        LaneClosed(1),
        RoadClosedThruTraffic(2);

        private int index;

        private SignType(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static SignType getByIndex(int index) {
            for (SignType type : SignType.values()) {
                if (type.index != index) continue;
                return type;
            }
            return null;
        }

        public static int getMaxIndex() {
            int maxIndex = -1;
            for (SignType type : SignType.values()) {
                if (type.index <= maxIndex) continue;
                maxIndex = type.index;
            }
            return maxIndex;
        }
    }
}

