/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.tileentity;

import com.clussmanproductions.trafficcontrol.ModSounds;
import com.clussmanproductions.trafficcontrol.blocks.BlockCrossingGateGate;
import com.clussmanproductions.trafficcontrol.tileentity.SyncableTileEntity;
import com.clussmanproductions.trafficcontrol.util.ILoopableSoundTileEntity;
import com.clussmanproductions.trafficcontrol.util.LoopableTileEntitySound;
import com.clussmanproductions.trafficcontrol.util.NBTUtils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CrossingGateGateTileEntity
extends SyncableTileEntity
implements ITickable,
ILoopableSoundTileEntity {
    private float gateRotation = -60.0f;
    private float gateDelay = 0.0f;
    private EnumStatuses status = EnumStatuses.Open;
    private boolean soundPlaying = false;
    private float crossingGateLength = 4.0f;
    private float upperRotationLimit = 60.0f;
    private float lowerRotationLimit = 0.0f;
    private float delay = 4.0f;

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74776_a("gateRotation", this.gateRotation);
        compound.func_74776_a("gateDelay", this.gateDelay);
        compound.func_74768_a("status", this.getCodeFromEnum(this.status));
        compound.func_74776_a("length", this.crossingGateLength);
        compound.func_74776_a("upperRotation", this.upperRotationLimit);
        compound.func_74776_a("lowerRotation", this.lowerRotationLimit);
        compound.func_74776_a("delay", this.delay);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.gateRotation = compound.func_74760_g("gateRotation");
        this.gateDelay = compound.func_74760_g("gateDelay");
        this.status = this.getStatusFromCode(compound.func_74762_e("status"));
        this.crossingGateLength = NBTUtils.getFloatOrDefault(compound, "length", 4.0f);
        this.upperRotationLimit = NBTUtils.getFloatOrDefault(compound, "upperRotation", 60.0f);
        this.lowerRotationLimit = NBTUtils.getFloatOrDefault(compound, "lowerRotation", 0.0f);
        this.delay = NBTUtils.getFloatOrDefault(compound, "delay", 4.0f);
    }

    public float getFacingRotation() {
        IBlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (!(blockState.func_177230_c() instanceof BlockCrossingGateGate)) {
            return 0.0f;
        }
        return -((Integer)blockState.func_177229_b((IProperty)BlockCrossingGateGate.ROTATION)).floatValue() * 22.5f;
    }

    public float getGateRotation() {
        return this.gateRotation;
    }

    private int getCodeFromEnum(EnumStatuses status) {
        switch (status) {
            case Closed: {
                return 0;
            }
            case Closing: {
                return 1;
            }
            case Open: {
                return 2;
            }
            case Opening: {
                return 3;
            }
        }
        return -1;
    }

    private EnumStatuses getStatusFromCode(int code) {
        switch (code) {
            case 0: {
                return EnumStatuses.Closed;
            }
            case 1: {
                return EnumStatuses.Closing;
            }
            case 2: {
                return EnumStatuses.Open;
            }
            case 3: {
                return EnumStatuses.Opening;
            }
        }
        return null;
    }

    public void func_73660_a() {
        switch (this.status) {
            case Closing: {
                if (this.gateDelay <= this.delay * 20.0f) {
                    this.gateDelay += 1.0f;
                    if (!this.field_145850_b.field_72995_K) {
                        this.func_70296_d();
                    }
                    return;
                }
                if (this.gateRotation >= -this.lowerRotationLimit) {
                    this.status = EnumStatuses.Closed;
                    if (!this.field_145850_b.field_72995_K) {
                        this.func_70296_d();
                    }
                    return;
                }
                if (this.field_145850_b.field_72995_K) {
                    this.handlePlaySound();
                }
                this.gateRotation += 0.5f;
                break;
            }
            case Opening: {
                if (this.gateRotation <= -this.upperRotationLimit) {
                    this.gateDelay = 0.0f;
                    this.status = EnumStatuses.Open;
                    if (!this.field_145850_b.field_72995_K) {
                        this.func_70296_d();
                    }
                }
                if (this.field_145850_b.field_72995_K) {
                    this.handlePlaySound();
                }
                this.gateRotation -= 0.5f;
                break;
            }
            case Closed: 
            case Open: {
                float idealAngle;
                float f = idealAngle = this.status == EnumStatuses.Open ? -this.upperRotationLimit : -this.lowerRotationLimit;
                if (this.gateRotation > idealAngle) {
                    this.gateRotation -= 0.5f;
                } else if (this.gateRotation < idealAngle) {
                    this.gateRotation += 0.5f;
                }
                if (!this.field_145850_b.field_72995_K) break;
                this.soundPlaying = false;
                break;
            }
            default: {
                return;
            }
        }
    }

    private void sendUpdates(Boolean markDirty) {
        if (markDirty.booleanValue()) {
            this.func_70296_d();
        }
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        nbt.func_74776_a("gateRotation", this.gateRotation);
        nbt.func_74776_a("gateDelay", this.gateDelay);
        nbt.func_74768_a("status", this.getCodeFromEnum(this.status));
        nbt.func_74776_a("length", this.crossingGateLength);
        nbt.func_74776_a("upperRotation", this.upperRotationLimit);
        nbt.func_74776_a("lowerRotation", this.lowerRotationLimit);
        nbt.func_74776_a("delay", this.delay);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.gateRotation = tag.func_74760_g("gateRotation");
        this.gateDelay = tag.func_74760_g("gateDelay");
        this.status = this.getStatusFromCode(tag.func_74762_e("status"));
        this.crossingGateLength = tag.func_74760_g("length");
        this.upperRotationLimit = tag.func_74760_g("upperRotation");
        this.lowerRotationLimit = tag.func_74760_g("lowerRotation");
        this.delay = tag.func_74760_g("delay");
    }

    @SideOnly(value=Side.CLIENT)
    public void handlePlaySound() {
        if (!this.soundPlaying) {
            LoopableTileEntitySound gateSound = new LoopableTileEntitySound(ModSounds.gateEvent, this, this.field_174879_c, 0.3f, 1.0f);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)gateSound);
            this.soundPlaying = true;
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.handleUpdateTag(nbt);
    }

    @Override
    public boolean isDonePlayingSound() {
        return !this.soundPlaying;
    }

    public EnumStatuses getStatus() {
        return this.status;
    }

    public void setStatus(EnumStatuses status) {
        if (status == EnumStatuses.Opening && this.status == EnumStatuses.Open || status == EnumStatuses.Closing && this.status == EnumStatuses.Closed) {
            return;
        }
        this.status = status;
        this.sendUpdates(true);
    }

    public float getCrossingGateLength() {
        return this.crossingGateLength;
    }

    public void setCrossingGateLength(float length) {
        boolean shouldMarkDirty = length != this.crossingGateLength;
        this.crossingGateLength = length;
        if (shouldMarkDirty) {
            this.sendUpdates(true);
        }
    }

    public float getUpperRotationLimit() {
        return this.upperRotationLimit;
    }

    public void setUpperRotationLimit(float upperRotationLimit) {
        boolean shouldMarkDirty = upperRotationLimit != this.upperRotationLimit;
        this.upperRotationLimit = upperRotationLimit;
        if (shouldMarkDirty) {
            this.sendUpdates(true);
        }
    }

    public float getLowerRotationLimit() {
        return this.lowerRotationLimit;
    }

    public void setLowerRotationLimit(float lowerRotationLimit) {
        boolean shouldMarkDirty = lowerRotationLimit != this.lowerRotationLimit;
        this.lowerRotationLimit = lowerRotationLimit;
        if (shouldMarkDirty) {
            this.sendUpdates(true);
        }
    }

    public float getDelay() {
        return this.delay;
    }

    public void setDelay(float delay) {
        boolean shouldMarkDirty = delay != this.delay;
        this.delay = delay;
        if (shouldMarkDirty) {
            this.sendUpdates(true);
        }
    }

    public void onChunkUnload() {
        this.soundPlaying = false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public NBTTagCompound getClientToServerUpdateTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("length", this.crossingGateLength);
        tag.func_74776_a("upperRotation", this.upperRotationLimit);
        tag.func_74776_a("lowerRotation", this.lowerRotationLimit);
        tag.func_74776_a("delay", this.delay);
        return tag;
    }

    @Override
    public void handleClientToServerUpdateTag(NBTTagCompound compound) {
        this.setCrossingGateLength(compound.func_74760_g("length"));
        this.setUpperRotationLimit(compound.func_74760_g("upperRotation"));
        this.setLowerRotationLimit(compound.func_74760_g("lowerRotation"));
        this.setDelay(compound.func_74760_g("delay"));
    }

    public double func_145833_n() {
        return 262144.0;
    }

    public static enum EnumStatuses {
        Open,
        Closing,
        Closed,
        Opening;

    }
}

