/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.proxy;

import com.clussmanproductions.trafficcontrol.ModBlocks;
import com.clussmanproductions.trafficcontrol.ModItems;
import com.clussmanproductions.trafficcontrol.blocks.model.ModelLoader;
import com.clussmanproductions.trafficcontrol.proxy.CommonProxy;
import com.clussmanproductions.trafficcontrol.tileentity.SignTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    public static KeyBinding entityClassRendererKey;

    @Override
    @SubscribeEvent
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoader());
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent e) {
        ModBlocks.initModels(e);
        ModItems.initModels(e);
    }

    @Override
    public void init(FMLInitializationEvent e) {
        super.init(e);
        SignTileEntity.initializeSigns();
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Loading sign textures", (int)SignTileEntity.SIGNS_BY_TYPE_VARIANT.size());
        for (SignTileEntity.Sign sign : SignTileEntity.SIGNS_BY_TYPE_VARIANT.values()) {
            progressBar.step(sign.getImageResourceLocation().toString());
            Minecraft.func_71410_x().field_71446_o.func_110579_a(sign.getImageResourceLocation(), (ITextureObject)new SimpleTexture(sign.getImageResourceLocation()));
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        entityClassRendererKey = new KeyBinding("key.entityclassrenderer.toggle", 27, "key.trafficcontrol.category");
        ClientRegistry.registerKeyBinding((KeyBinding)entityClassRendererKey);
    }
}

