/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.network;

import com.clussmanproductions.trafficcontrol.tileentity.SignTileEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketUpdateSign
implements IMessage {
    public int x;
    public int y;
    public int z;
    public int type;
    public int variant;

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.type = buf.readInt();
        this.variant = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.type);
        buf.writeInt(this.variant);
    }

    public static class Handler
    implements IMessageHandler<PacketUpdateSign, IMessage> {
        public IMessage onMessage(PacketUpdateSign message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketUpdateSign message, MessageContext ctx) {
            World world = ctx.getServerHandler().field_147369_b.field_70170_p;
            BlockPos pos = new BlockPos(message.x, message.y, message.z);
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof SignTileEntity) {
                SignTileEntity sign = (SignTileEntity)te;
                sign.setType(message.type);
                sign.setVariant(message.variant);
                sign.func_70296_d();
                IBlockState blockState = world.func_180495_p(pos);
                world.func_184138_a(pos, blockState, blockState, 0);
                world.func_180497_b(pos, blockState.func_177230_c(), 0, 1);
            }
        }
    }
}

