/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.gui;

import com.clussmanproductions.trafficcontrol.gui.GuiImageList;
import com.clussmanproductions.trafficcontrol.tileentity.SignTileEntity;
import com.clussmanproductions.trafficcontrol.tileentity.Type3BarrierTileEntity;
import com.clussmanproductions.trafficcontrol.util.Tuple;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import org.lwjgl.input.Mouse;

public class GuiType3Barrier
extends GuiScreen {
    private Type3BarrierTileEntity tileEntity;
    private GuiCheckBox renderSign;
    private GuiButton prevSignType;
    private GuiButton nextSignType;
    private GuiCheckBox renderThisSign;
    private GuiButton selectThisSign;
    private GuiImageList imageList;
    private GuiTextField imageListFilter;
    private GuiButtonExt close;

    public GuiType3Barrier(Type3BarrierTileEntity barrierTE) {
        this.tileEntity = barrierTE;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.renderSign = new GuiCheckBox(1, 0, 0, "Sign across barriers", this.tileEntity.getRenderSign());
        this.renderSign.setIsChecked(this.tileEntity.getRenderSign());
        this.renderSign.field_146128_h = this.field_146294_l / 2 - this.renderSign.field_146120_f - 4;
        this.renderSign.field_146129_i = this.field_146295_m / 2 - 16 - 32;
        this.prevSignType = new GuiButton(2, 0, 0, "<");
        this.prevSignType.field_146120_f = 20;
        this.prevSignType.field_146128_h = this.field_146294_l / 2 + 4;
        this.prevSignType.field_146129_i = this.field_146295_m / 2 - 16 - 32 - (this.prevSignType.field_146121_g - this.renderSign.field_146121_g) / 2;
        this.prevSignType.field_146125_m = this.tileEntity.getRenderSign();
        this.nextSignType = new GuiButton(3, 0, 0, ">");
        this.nextSignType.field_146120_f = 20;
        this.nextSignType.field_146128_h = this.field_146294_l / 2 + 64 + this.prevSignType.field_146120_f + 4 + 4 + 4;
        this.nextSignType.field_146129_i = this.field_146295_m / 2 - 16 - 32 - (this.nextSignType.field_146121_g - this.renderSign.field_146121_g) / 2;
        this.nextSignType.field_146125_m = this.tileEntity.getRenderSign();
        this.renderThisSign = new GuiCheckBox(4, 0, 0, "Sign on this barrier", this.tileEntity.getRenderThisSign());
        this.renderThisSign.field_146128_h = this.field_146294_l / 2 - this.renderSign.field_146120_f - 4;
        this.renderThisSign.field_146129_i = this.field_146295_m / 2 + 8;
        this.selectThisSign = new GuiButtonExt(5, this.field_146294_l / 2 + 4 + 32 + 4, this.field_146295_m / 2 + 6, 75, 20, "Select Sign");
        this.selectThisSign.field_146125_m = this.tileEntity.getRenderThisSign();
        this.imageList = new GuiImageList(this.field_146294_l / 2 + 4 - 100, this.field_146295_m / 2 - 100, 200, 200, sign -> {
            this.tileEntity.setThisSignType(sign.getType());
            this.tileEntity.setThisSignVariant(sign.getVariant());
            this.imageList.setVisible(false);
        });
        this.imageList.setVisible(false);
        this.imageListFilter = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 + 4 - 100, this.field_146295_m / 2 + 100 + 4, 200, 20);
        this.field_146292_n.add(this.renderSign);
        this.field_146292_n.add(this.prevSignType);
        this.field_146292_n.add(this.nextSignType);
        this.field_146292_n.add(this.renderThisSign);
        this.field_146292_n.add(this.selectThisSign);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        if (this.tileEntity.getRenderSign()) {
            this.renderSign(this.field_146294_l / 2 + 4 + 4 + this.prevSignType.field_146120_f, this.field_146295_m / 2 - 32 - 16 - this.prevSignType.field_146121_g / 2);
        }
        if (this.tileEntity.getRenderThisSign()) {
            this.renderThisSignVariant(this.field_146294_l / 2 + 4, this.field_146295_m / 2);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.imageList.draw(mouseX, mouseY, this.field_146289_q, text -> x -> y -> this.func_146283_a((List)text, (int)x, (int)y));
        if (this.imageList.isVisible()) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            this.imageListFilter.func_146194_f();
            GlStateManager.func_179145_e();
        }
    }

    private void renderSign(int left, int top) {
        ResourceLocation signRL = new ResourceLocation("trafficcontrol:textures/blocks/road_closed_sign.png");
        float signTextureBottomY = 0.25f;
        float heightFactor = 0.25f;
        if (this.tileEntity.getSignType() == Type3BarrierTileEntity.SignType.LaneClosed) {
            signTextureBottomY = 0.5f;
        } else if (this.tileEntity.getSignType() == Type3BarrierTileEntity.SignType.RoadClosedThruTraffic) {
            signTextureBottomY = 1.0f;
            heightFactor = 0.5f;
        }
        Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(signRL);
        GlStateManager.func_179094_E();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder builder = tess.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_181662_b((double)(left + 64), (double)top, 0.0).func_187315_a(0.5, (double)(signTextureBottomY - heightFactor)).func_181675_d();
        builder.func_181662_b((double)left, (double)top, 0.0).func_187315_a(0.0, (double)(signTextureBottomY - heightFactor)).func_181675_d();
        builder.func_181662_b((double)left, (double)(top + 32), 0.0).func_187315_a(0.0, (double)signTextureBottomY).func_181675_d();
        builder.func_181662_b((double)(left + 64), (double)(top + 32), 0.0).func_187315_a(0.5, (double)signTextureBottomY).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179121_F();
    }

    private void renderThisSignVariant(int left, int top) {
        ResourceLocation signTexture = ((SignTileEntity.Sign)SignTileEntity.SIGNS_BY_TYPE_VARIANT.get(new Tuple<Integer, Integer>(this.tileEntity.getThisSignType(), this.tileEntity.getThisSignVariant()))).getImageResourceLocation();
        Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(signTexture);
        GlStateManager.func_179094_E();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder builder = tess.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_181662_b((double)(left + 32), (double)top, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        builder.func_181662_b((double)left, (double)top, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        builder.func_181662_b((double)left, (double)(top + 32), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        builder.func_181662_b((double)(left + 32), (double)(top + 32), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179121_F();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 1: {
                boolean checked = ((GuiCheckBox)button).isChecked();
                this.tileEntity.setRenderSign(checked);
                this.prevSignType.field_146125_m = checked;
                this.nextSignType.field_146125_m = checked;
                break;
            }
            case 3: {
                this.tileEntity.nextSignType();
                break;
            }
            case 2: {
                this.tileEntity.prevSignType();
                break;
            }
            case 4: {
                boolean thisSignChecked = ((GuiCheckBox)button).isChecked();
                this.tileEntity.setRenderThisSign(thisSignChecked);
                this.selectThisSign.field_146125_m = thisSignChecked;
                break;
            }
            case 5: {
                this.imageList.setVisible(true);
                this.imageListFilter.func_146189_e(true);
            }
        }
        super.func_146284_a(button);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.imageList.isVisible()) {
            this.imageList.onMouseClick(mouseX, mouseY);
            this.imageListFilter.func_146192_a(mouseX, mouseY, mouseButton);
        } else {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.imageList.onMouseRelease();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode != 1 || !this.imageList.isVisible()) {
            super.func_73869_a(typedChar, keyCode);
        }
        if (this.imageList.isVisible()) {
            this.imageListFilter.func_146201_a(typedChar, keyCode);
            this.imageList.filter(this.imageListFilter.func_146179_b());
            if (keyCode == 1) {
                this.imageList.setVisible(false);
                this.imageList.filter(null);
                this.imageListFilter.func_146189_e(false);
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.imageList.isVisible()) {
            int scroll = Integer.signum(Mouse.getEventDWheel());
            this.imageList.scroll(scroll);
        }
    }

    public void func_146281_b() {
        this.tileEntity.syncConnectedBarriers(true);
        super.func_146281_b();
    }

    public static class CMPT_IDs {
        public static final int RENDER_SIGN = 1;
        public static final int PREV_SIGN_TYPE = 2;
        public static final int NEXT_SIGN_TYPE = 3;
        public static final int RENDER_THIS_SIGN = 4;
        public static final int SELECT_THIS_SIGN = 5;
    }
}

