/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.gui;

import com.clussmanproductions.trafficcontrol.gui.BaseTrafficLightFrameContainer;
import com.clussmanproductions.trafficcontrol.gui.SlotItemHandlerListenable;
import com.clussmanproductions.trafficcontrol.item.BaseItemTrafficLightFrame;
import com.clussmanproductions.trafficcontrol.network.PacketHandler;
import com.clussmanproductions.trafficcontrol.network.PacketTrafficLightFrameGuiUpdate;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class BaseTrafficLightFrameGui
extends GuiContainer {
    ItemStack frameStack;
    BaseTrafficLightFrameContainer container;

    public BaseTrafficLightFrameGui(BaseTrafficLightFrameContainer container) {
        super((Container)container);
        this.container = container;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ItemStack frameStack = this.container.getFrameStack();
        BaseItemTrafficLightFrame frameItem = (BaseItemTrafficLightFrame)frameStack.func_77973_b();
        for (BaseTrafficLightFrameContainer.FrameSlotInfo slotInfo : this.container.getItemSlots(this.container.frameStackHandler)) {
            int left = this.field_146294_l / 2 - this.field_146999_f / 2;
            int top = this.field_146295_m / 2 - this.field_147000_g / 2;
            int x = left + slotInfo.getSlot().field_75223_e;
            int y = top + slotInfo.getSlot().field_75221_f;
            GuiCheckBox doNotFlash = new GuiCheckBox(slotInfo.getSlot().getSlotIndex() * 10, 0, 0, "Allow Flash", true);
            doNotFlash.field_146125_m = slotInfo.getSlot().func_75216_d();
            doNotFlash.setIsChecked(frameItem.getAlwaysFlash(frameStack, slotInfo.getSlot().getSlotIndex()));
            ((SlotItemHandlerListenable)this.container.func_75139_a(slotInfo.getSlot().getSlotIndex() + 36)).setOnSlotChangedListener(ind -> this.onSlotClick((int)ind));
            switch (slotInfo.getCheckboxOrientation()) {
                case ABOVE: {
                    y -= 24;
                    break;
                }
                case BELOW: {
                    y += 28;
                    break;
                }
                case LEFT: {
                    x -= doNotFlash.func_146117_b() + 12;
                    break;
                }
                case RIGHT: {
                    x += 30;
                }
            }
            doNotFlash.field_146128_h = x;
            doNotFlash.field_146129_i = y;
            this.field_146292_n.add(doNotFlash);
        }
    }

    private void onSlotClick(int slotId) {
        int inventorySlot = slotId;
        if (inventorySlot < 0) {
            return;
        }
        GuiCheckBox box = this.findCheckboxById(inventorySlot *= 10);
        if (box == null) {
            return;
        }
        box.field_146125_m = this.container.func_75139_a(slotId + 36).func_75216_d();
    }

    private GuiCheckBox findCheckboxById(int id) {
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof GuiCheckBox) || button.field_146127_k != id) continue;
            return (GuiCheckBox)button;
        }
        return null;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("trafficcontrol:textures/gui/" + this.getGuiPngName()));
        BaseTrafficLightFrameGui.func_146110_a((int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (float)this.field_146999_f, (float)this.field_147000_g);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (!(button instanceof GuiCheckBox)) {
            return;
        }
        GuiCheckBox checkbox = (GuiCheckBox)button;
        int type = button.field_146127_k % 10;
        int slotId = button.field_146127_k / 10;
        switch (type) {
            case 0: {
                BaseItemTrafficLightFrame baseFrameItem = (BaseItemTrafficLightFrame)this.container.getFrameStack().func_77973_b();
                baseFrameItem.handleGuiAlwaysUpdate(this.container.getFrameStack(), slotId, checkbox.isChecked());
                PacketTrafficLightFrameGuiUpdate packet = new PacketTrafficLightFrameGuiUpdate();
                packet.slotId = slotId;
                packet.alwaysFlash = checkbox.isChecked();
                PacketHandler.INSTANCE.sendToServer((IMessage)packet);
            }
        }
    }

    protected abstract String getGuiPngName();
}

