/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.gui;

import com.clussmanproductions.trafficcontrol.gui.SlotItemHandlerListenable;
import com.clussmanproductions.trafficcontrol.item.BaseItemTrafficLightFrame;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class BaseTrafficLightFrameContainer
extends Container {
    IItemHandler frameStackHandler;
    ItemStack frameStack;

    public BaseTrafficLightFrameContainer(InventoryPlayer inventory, ItemStack frameStack) {
        int i;
        int ySize = this.getYSize();
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventory, i, 7 + i * 18, 177 + (ySize - 200)));
        }
        for (i = 9; i < 36; ++i) {
            int rowWork = i;
            int row = 0;
            while (rowWork - 9 >= 9) {
                ++row;
                rowWork -= 9;
            }
            int column = i % 9;
            this.func_75146_a(new Slot((IInventory)inventory, i, 7 + column * 18, 119 + (ySize - 200) + 18 * row));
        }
        this.frameStackHandler = (IItemHandler)frameStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (Slot slot : this.getItemSlots(this.frameStackHandler).stream().map(fsi -> fsi.getSlot()).collect(Collectors.toList())) {
            this.func_75146_a(slot);
        }
        this.frameStack = frameStack;
    }

    protected abstract List<FrameSlotInfo> getItemSlots(IItemHandler var1);

    protected abstract int getYSize();

    public ItemStack getFrameStack() {
        return this.frameStack;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return playerIn.func_184614_ca().func_77973_b() == this.getValidFrameItem();
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        ItemStack originStack = null;
        ItemStack destinationStack = ItemStack.field_190927_a;
        if (slot.func_75216_d()) {
            originStack = slot.func_75211_c();
            destinationStack = originStack.func_77946_l();
            if (index > 35) {
                if (!this.func_75135_a(originStack, 0, 35, false)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                BaseItemTrafficLightFrame heldFrame = (BaseItemTrafficLightFrame)playerIn.func_184614_ca().func_77973_b();
                boolean didMerge = false;
                for (int i = 0; i < heldFrame.getBulbCount(); ++i) {
                    Slot frameSlot = (Slot)this.field_75151_b.get(i + 36);
                    if (frameSlot.func_75216_d() || !frameSlot.func_75214_a(originStack)) continue;
                    this.func_75135_a(originStack, i + 36, i + 37, false);
                    didMerge = true;
                    break;
                }
                if (!didMerge) {
                    return ItemStack.field_190927_a;
                }
            }
        } else {
            return ItemStack.field_190927_a;
        }
        if (originStack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        return destinationStack;
    }

    protected abstract BaseItemTrafficLightFrame getValidFrameItem();

    public static class FrameSlotInfo {
        private EnumCheckboxOrientation checkboxOrientation;
        private SlotItemHandlerListenable slot;

        public FrameSlotInfo(EnumCheckboxOrientation checkboxOrienation, SlotItemHandlerListenable slot) {
            this.checkboxOrientation = checkboxOrienation;
            this.slot = slot;
        }

        public EnumCheckboxOrientation getCheckboxOrientation() {
            return this.checkboxOrientation;
        }

        public SlotItemHandlerListenable getSlot() {
            return this.slot;
        }

        public static enum EnumCheckboxOrientation {
            LEFT,
            RIGHT,
            ABOVE,
            BELOW;

        }
    }
}

