/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.blocks;

import com.clussmanproductions.trafficcontrol.ModItems;
import com.clussmanproductions.trafficcontrol.ModTrafficControl;
import com.clussmanproductions.trafficcontrol.tileentity.StreetSign;
import com.clussmanproductions.trafficcontrol.tileentity.StreetSignTileEntity;
import com.clussmanproductions.trafficcontrol.tileentity.render.StreetSignRenderer;
import com.clussmanproductions.trafficcontrol.util.CustomAngleCalculator;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStreetSign
extends Block {
    public BlockStreetSign() {
        super(Material.field_151573_f);
        this.setRegistryName("street_sign");
        this.func_149663_c("trafficcontrol.street_sign");
        this.func_149713_g(1);
        this.func_149711_c(1.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149647_a(ModTrafficControl.CREATIVE_TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ClientRegistry.bindTileEntitySpecialRenderer(StreetSignTileEntity.class, (TileEntitySpecialRenderer)new StreetSignRenderer());
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public float func_185485_f(IBlockState state) {
        return 1.0f;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new StreetSignTileEntity();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        StreetSignTileEntity te = (StreetSignTileEntity)worldIn.func_175625_s(pos);
        StreetSign newSign = new StreetSign();
        newSign.setRotation(CustomAngleCalculator.getRotationForYaw(placer.field_70177_z));
        te.addStreetSign(newSign);
        if (!worldIn.field_72995_K) {
            return;
        }
        if (placer != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        Minecraft.func_71410_x().field_71439_g.openGui((Object)ModTrafficControl.instance, 6, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntity tileEntity = source.func_175625_s(pos);
        if (tileEntity == null || !(tileEntity instanceof StreetSignTileEntity)) {
            return field_185505_j;
        }
        StreetSignTileEntity streetSignTileEntity = (StreetSignTileEntity)tileEntity;
        double pixelsHigh = 0.0;
        for (int i = 0; i < 4; ++i) {
            if (streetSignTileEntity.getStreetSign(i) == null) continue;
            pixelsHigh += 4.0;
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, pixelsHigh / 16.0, 1.0);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K && !(hand != EnumHand.MAIN_HAND ? playerIn.func_184592_cb().func_77973_b() == ModItems.street_sign : playerIn.func_184614_ca().func_77973_b() == ModItems.street_sign)) {
            playerIn.openGui((Object)ModTrafficControl.instance, 6, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        StreetSignTileEntity streetSignTileEntity = (StreetSignTileEntity)world.func_175625_s(pos);
        if (streetSignTileEntity == null) {
            return;
        }
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            if (streetSignTileEntity.getStreetSign(i) == null) continue;
            ++count;
        }
        drops.add((Object)new ItemStack((Item)ModItems.street_sign, count));
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }
}

