/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.blocks;

import com.clussmanproductions.trafficcontrol.ModBlocks;
import com.clussmanproductions.trafficcontrol.ModTrafficControl;
import com.clussmanproductions.trafficcontrol.blocks.BlockBaseTrafficLight;
import com.clussmanproductions.trafficcontrol.blocks.BlockHorizontalPole;
import com.clussmanproductions.trafficcontrol.tileentity.SignTileEntity;
import com.clussmanproductions.trafficcontrol.tileentity.render.SignRenderer;
import com.clussmanproductions.trafficcontrol.util.CustomAngleCalculator;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSign
extends Block
implements ITileEntityProvider {
    public static final PropertyInteger ROTATION = PropertyInteger.func_177719_a((String)"rotation", (int)0, (int)15);
    public static final PropertyBool VALIDHORIZONTALBAR = PropertyBool.func_177716_a((String)"validhorizontalbar");
    public static final PropertyBool ISHALFHEIGHT = PropertyBool.func_177716_a((String)"ishalfheight");

    public BlockSign() {
        super(Material.field_151573_f);
        this.setRegistryName("sign");
        this.func_149663_c("trafficcontrol.sign");
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149647_a(ModTrafficControl.CREATIVE_TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ClientRegistry.bindTileEntitySpecialRenderer(SignTileEntity.class, (TileEntitySpecialRenderer)new SignRenderer());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION, VALIDHORIZONTALBAR, ISHALFHEIGHT});
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new SignTileEntity();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int variant;
        SignTileEntity signTE;
        boolean validHorizontalBar = false;
        boolean isHalfHeight = false;
        int rotation = (Integer)state.func_177229_b((IProperty)ROTATION);
        boolean isCardinal = CustomAngleCalculator.isCardinal(rotation);
        if (isCardinal && CustomAngleCalculator.isNorthSouth(rotation)) {
            validHorizontalBar = this.getValidStateForAttachableSubModels(state, worldIn.func_180495_p(pos.func_177976_e()), EnumFacing.NORTH, EnumFacing.SOUTH) || this.getValidStateForAttachableSubModels(state, worldIn.func_180495_p(pos.func_177974_f()), EnumFacing.NORTH, EnumFacing.SOUTH);
        } else if (isCardinal) {
            validHorizontalBar = this.getValidStateForAttachableSubModels(state, worldIn.func_180495_p(pos.func_177978_c()), EnumFacing.WEST, EnumFacing.EAST) || this.getValidStateForAttachableSubModels(state, worldIn.func_180495_p(pos.func_177968_d()), EnumFacing.WEST, EnumFacing.EAST);
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof SignTileEntity && (signTE = (SignTileEntity)te).getType() == 2 && ((variant = signTE.getVariant()) >= 33 && variant <= 40 || variant >= 106 && variant <= 107 || variant >= 110 && variant <= 111 || variant >= 120 && variant <= 124)) {
            isHalfHeight = true;
        }
        return state.func_177226_a((IProperty)VALIDHORIZONTALBAR, (Comparable)Boolean.valueOf(validHorizontalBar)).func_177226_a((IProperty)ISHALFHEIGHT, (Comparable)Boolean.valueOf(isHalfHeight));
    }

    private boolean getValidStateForAttachableSubModels(IBlockState signState, IBlockState state, EnumFacing ... validFacings) {
        if (state.func_177230_c() == ModBlocks.crossing_gate_pole) {
            return true;
        }
        if (state.func_177230_c() == ModBlocks.horizontal_pole) {
            EnumFacing facing2 = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontalPole.FACING);
            return Arrays.stream(validFacings).noneMatch(vf -> vf.equals((Object)facing2));
        }
        if (state.func_177230_c() instanceof BlockBaseTrafficLight) {
            return true;
        }
        if (state.func_177230_c() == ModBlocks.sign) {
            int otherRotation = (Integer)state.func_177229_b((IProperty)ROTATION);
            boolean otherIsCardinal = CustomAngleCalculator.isCardinal(otherRotation);
            boolean isForNorthSouth = Arrays.stream(validFacings).anyMatch(facing -> facing == EnumFacing.NORTH);
            boolean thisSignNorthSouth = CustomAngleCalculator.isNorthSouth((Integer)signState.func_177229_b((IProperty)ROTATION));
            return otherIsCardinal && (isForNorthSouth && thisSignNorthSouth || !isForNorthSouth && !thisSignNorthSouth);
        }
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return CustomAngleCalculator.rotationToMeta((Integer)state.func_177229_b((IProperty)ROTATION));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(CustomAngleCalculator.metaToRotation(meta)));
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            return true;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof SignTileEntity)) {
            return false;
        }
        playerIn.openGui((Object)ModTrafficControl.instance, 1, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(CustomAngleCalculator.getRotationForYaw(placer.field_70177_z)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        double poleHeight = 1.0;
        TileEntity worldTE = source.func_175625_s(pos);
        if (!(worldTE instanceof SignTileEntity)) {
            return field_185505_j;
        }
        SignTileEntity te = (SignTileEntity)worldTE;
        if (te != null) {
            int type = te.getType();
            int variant = te.getVariant();
            if (type == 2 && variant >= 33 && variant <= 40 || variant >= 106 && variant <= 107 || variant >= 110 && variant <= 111 || variant >= 120 && variant <= 124) {
                poleHeight = 0.5;
            }
        }
        int rotation = (Integer)state.func_177229_b((IProperty)ROTATION);
        switch (rotation) {
            case 0: 
            case 8: {
                return new AxisAlignedBB(0.0, 0.0, 0.43125, 1.0, poleHeight, 0.5625);
            }
            case 4: 
            case 12: {
                return new AxisAlignedBB(0.4375, 0.0, 0.0, 0.56875, poleHeight, 1.0);
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                return new AxisAlignedBB(0.375, 0.0, 0.375, 0.75, poleHeight, 0.75);
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                return new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, poleHeight, 0.8);
            }
        }
        return field_185505_j;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }
}

