/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.environmentalcreepers.event;

import fi.dy.masa.environmentalcreepers.EnvironmentalCreepers;
import fi.dy.masa.environmentalcreepers.config.Configs;
import java.lang.reflect.Field;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CreeperEventHandler {
    private static final Field field_Creeper_timeSinceIgnited = ObfuscationReflectionHelper.findField(EntityCreeper.class, (String)"field_70833_d");
    private static final Field field_Creeper_fuseTime = ObfuscationReflectionHelper.findField(EntityCreeper.class, (String)"field_82225_f");
    private static CreeperEventHandler instance = new CreeperEventHandler();
    private boolean registered;

    public static CreeperEventHandler getInstance() {
        return instance;
    }

    public void register() {
        if (!this.registered) {
            EnvironmentalCreepers.logInfo("Registering CreeperEventHandler", new Object[0]);
            MinecraftForge.EVENT_BUS.register((Object)this);
            this.registered = true;
        }
    }

    public void unregister() {
        if (this.registered) {
            EnvironmentalCreepers.logInfo("Unregistering CreeperEventHandler", new Object[0]);
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            this.registered = false;
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityCreeper creeper;
        int state;
        if (Configs.disableCreeperExplosionCompletely && event.getEntity() instanceof EntityCreeper && (state = (creeper = (EntityCreeper)event.getEntity()).func_70832_p()) > 0) {
            try {
                int timeSinceIgnited = (Integer)field_Creeper_timeSinceIgnited.get(creeper);
                int fuseTime = (Integer)field_Creeper_fuseTime.get(creeper);
                if (timeSinceIgnited >= fuseTime - state - 1) {
                    field_Creeper_timeSinceIgnited.set(creeper, fuseTime - state - 1);
                }
            }
            catch (Exception e) {
                EnvironmentalCreepers.logger.warn("CreeperEventHandler.onLivingUpdate(): Exception while trying to reflect Creeper fields");
            }
        }
    }
}

