/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.environmentalcreepers.config;

import fi.dy.masa.environmentalcreepers.EnvironmentalCreepers;
import fi.dy.masa.environmentalcreepers.config.ConfigFileUtils;
import fi.dy.masa.environmentalcreepers.event.CreeperEventHandler;
import java.io.File;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.world.Explosion;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Configs {
    public static final HashSet<Class<? extends Explosion>> EXPLOSION_CLASS_BLACKLIST = new HashSet();
    public static final HashSet<Class<? extends Explosion>> EXPLOSION_CLASS_WHITELIST = new HashSet();
    public static final HashSet<Class<? extends Entity>> EXPLOSION_ENTITY_BLACKLIST = new HashSet();
    public static final HashSet<Class<? extends Entity>> EXPLOSION_ENTITY_WHITELIST = new HashSet();
    private static boolean copyConfigToWorld;
    private static boolean usePerWorldConfig;
    public static boolean disableCreeperExplosionBlockDamage;
    public static boolean disableCreeperExplosionCompletely;
    public static boolean disableCreeperExplosionItemDamage;
    public static boolean disableOtherExplosionBlockDamage;
    public static boolean disableOtherExplosionItemDamage;
    public static boolean enableCreeperExplosionChainReaction;
    public static boolean enableCreeperAltitudeCondition;
    public static boolean modifyCreeperExplosionDropChance;
    public static boolean modifyCreeperExplosionStrength;
    public static boolean modifyOtherExplosionDropChance;
    public static double creeperAltitudeDamageMaxY;
    public static double creeperAltitudeDamageMinY;
    public static double creeperChainReactionChance;
    public static double creeperChainReactionMaxDistance;
    public static double creeperExplosionBlockDropChance;
    public static double creeperExplosionStrengthNormal;
    public static double creeperExplosionStrengthCharged;
    public static double otherExplosionBlockDropChance;
    public static ListType explosionClassListType;
    public static ListType explosionEntityListType;
    public static boolean verboseLogging;
    private static String[] explosionEntityBlacklistClassNames;
    private static String[] explosionEntityWhitelistClassNames;
    private static String[] explosionBlacklistClassNames;
    private static String[] explosionWhitelistClassNames;
    private static File configFileGlobal;
    private static Configuration config;
    public static final String CATEGORY_GENERIC = "Generic";
    public static final String CATEGORY_LISTS = "Lists";

    public static Configuration getConfig() {
        return config;
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("environmentalcreepers".equals(event.getModID())) {
            Configs.reloadConfig();
        }
    }

    public static void reloadConfig() {
        if (config != null) {
            EnvironmentalCreepers.logInfo("Reloading the configs from file '{}'", config.getConfigFile().getAbsolutePath());
            Configs.loadConfigs(config);
        }
    }

    public static void setGlobalConfigDirAndLoadConfigs(File configDirCommon) {
        File configFile;
        configFileGlobal = configFile = new File(configDirCommon, "environmentalcreepers.cfg");
        Configs.loadConfigsFromGlobalConfigFile();
    }

    public static void loadConfigsFromPerWorldConfigIfExists(@Nullable File worldDir) {
        if (worldDir != null) {
            File configDir = new File(new File(worldDir, "data"), "environmentalcreepers");
            File configFile = new File(configDir, "environmentalcreepers.cfg");
            if (copyConfigToWorld) {
                ConfigFileUtils.createDirIfNotExists(configDir);
                ConfigFileUtils.tryCopyConfigIfMissing(configFile, configFileGlobal);
            }
            if (usePerWorldConfig && configFile.exists() && configFile.isFile() && configFile.canRead()) {
                Configs.loadConfigsFromFile(configFile);
                return;
            }
        }
        Configs.loadConfigsFromGlobalConfigFile();
    }

    public static void loadConfigsFromGlobalConfigFile() {
        Configs.loadConfigsFromFile(configFileGlobal);
    }

    private static void loadConfigsFromFile(File configFile) {
        config = new Configuration(configFile, null, true);
        Configs.reloadConfig();
    }

    private static void loadConfigs(Configuration conf) {
        conf.load();
        Property prop = conf.get(CATEGORY_GENERIC, "copyConfigToWorld", true);
        prop.setComment("If true, then the global config file is copied to the world\n (in data/environmentalcreepers/environmentalcreepers.cfg), if one doesn't exist there yet.");
        copyConfigToWorld = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "creeperAltitudeDamageMaxY", 64);
        prop.setComment("The maximum y position where Creeper explosions will do block damage,\nif enableCreeperAltitudeCondition is enabled.");
        creeperAltitudeDamageMaxY = prop.getDouble();
        prop = conf.get(CATEGORY_GENERIC, "creeperAltitudeDamageMinY", -64);
        prop.setComment("The minimum y position where Creeper explosions will do block damage,\nif enableCreeperAltitudeCondition is enabled.");
        creeperAltitudeDamageMinY = prop.getDouble();
        prop = conf.get(CATEGORY_GENERIC, "creeperChainReactionChance", 1.0);
        prop.setComment("The chance of Creeper explosions to cause other Creepers to trigger within range. Set to 1.0 to always trigger.");
        creeperChainReactionChance = prop.getDouble();
        prop = conf.get(CATEGORY_GENERIC, "creeperChainReactionMaxDistance", 16.0);
        prop.setComment("The maximum distance within which a Creeper exploding will cause a chain reaction.");
        creeperChainReactionMaxDistance = prop.getDouble();
        prop = conf.get(CATEGORY_GENERIC, "creeperExplosionBlockDropChance", 1.0);
        prop.setComment("The chance of Creeper explosions to drop the blocks as items. Set to 1.0 to always drop.");
        creeperExplosionBlockDropChance = prop.getDouble();
        prop = conf.get(CATEGORY_GENERIC, "creeperExplosionStrengthNormal", 3.0);
        prop.setComment("The strength of Creeper explosions. Default in vanilla: 3.0 for normal Creepers (becomes double ie. 6.0 for Charged Creepers).");
        creeperExplosionStrengthNormal = prop.getDouble();
        prop = conf.get(CATEGORY_GENERIC, "creeperExplosionStrengthCharged", 6.0);
        prop.setComment("The strength of Charged Creeper explosions. Default in vanilla: 6.0 (double of normal Creepers).");
        creeperExplosionStrengthCharged = prop.getDouble();
        prop = conf.get(CATEGORY_GENERIC, "disableCreeperExplosionBlockDamage", false);
        prop.setComment("Completely disable Creeper explosion from damaging blocks");
        disableCreeperExplosionBlockDamage = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "disableCreeperExplosionCompletely", false);
        prop.setComment("Completely disable Creepers from exploding");
        disableCreeperExplosionCompletely = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "disableCreeperExplosionItemDamage", false);
        prop.setComment("Disable Creeper explosions from damaging items on the ground");
        disableCreeperExplosionItemDamage = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "disableOtherExplosionBlockDamage", false);
        prop.setComment("Completely disable other explosions than Creepers from damaging blocks");
        disableOtherExplosionBlockDamage = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "disableOtherExplosionItemDamage", false);
        prop.setComment("Disable other explosions than Creepers from damaging items on the ground");
        disableOtherExplosionItemDamage = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "enableCreeperAltitudeCondition", false);
        prop.setComment("Enable setting a y range for Creepers to do block damage.\nSet the range in 'creeperAltitudeDamageMaxY' and 'creeperAltitudeDamageMinY'.");
        enableCreeperAltitudeCondition = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "enableCreeperExplosionChainReaction", false);
        prop.setComment("When enabled, a Creeper exploding has a chance to trigger other nearby Creepers.");
        enableCreeperExplosionChainReaction = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "modifyCreeperExplosionDropChance", true);
        prop.setComment("Modify the chance of Creeper explosions to drop the blocks as items. Set the chance in creeperExplosionBlockDropChance.");
        modifyCreeperExplosionDropChance = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "modifyCreeperExplosionStrength", false);
        prop.setComment("Modify the strength of Creeper explosions.");
        modifyCreeperExplosionStrength = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "modifyOtherExplosionDropChance", true);
        prop.setComment("Modify the chance of other explosions than Creepers to drop the blocks as items. Set the chance in otherExplosionBlockDropChance.");
        modifyOtherExplosionDropChance = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "otherExplosionBlockDropChance", 1.0);
        prop.setComment("The chance of other explosions than Creepers to drop the blocks as items. Set to 1.0 to always drop.");
        otherExplosionBlockDropChance = prop.getDouble();
        prop = conf.get(CATEGORY_GENERIC, "usePerWorldConfig", true);
        prop.setComment("If true, then configs are attempted to be read from a config inside the world\n(in data/environmentalcreepers/environmentalcreepers.cfg), if one exists there.");
        usePerWorldConfig = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "verboseLogging", false);
        prop.setComment("Log some messages on each explosion, for debugging purposes. Leave disabled for normal use.");
        verboseLogging = prop.getBoolean();
        prop = conf.get(CATEGORY_LISTS, "entityClassListType", "blacklist");
        prop.setComment("The list type for the explosion class filtering.\nEither 'none' or 'blacklist' or 'whitelist'.\nBlacklisted (or non-whitelisted) entities will not be removed from the explosion damage list.\nThis allows for example those entities to run their custom code when damaged by explosions.");
        explosionEntityListType = ListType.fromName(prop.getString());
        prop = conf.get(CATEGORY_LISTS, "entityTypeBlacklist", new String[]{"appeng.entity.EntitySingularity"});
        prop.setComment("A list of full class names of entities that should be ignored.\nThis means that these entities will not get removed from the\nlist of entities to be damaged by the explosion, allowing these\nentities to handle the explosion code themselves.\nUsed if entityClassListType = blacklist");
        explosionEntityBlacklistClassNames = prop.getStringList();
        prop = conf.get(CATEGORY_LISTS, "entityTypeWhitelist", new String[0]);
        prop.setComment("A list of full class names of entities that are the only ones\nthat should be acted on, see the comment on entityTypeBlacklist.\nUsed if entityClassListType = whitelist");
        explosionEntityWhitelistClassNames = prop.getStringList();
        prop = conf.get(CATEGORY_LISTS, "explosionClassListType", "blacklist");
        prop.setComment("The list type for the explosion class filtering.\nEither 'none' or 'blacklist' or 'whitelist'.\nBlacklisted (or non-whitelisted) explosion types won't be handled by this mod.");
        explosionClassListType = ListType.fromName(prop.getString());
        prop = conf.get(CATEGORY_LISTS, "explosionTypeBlacklist", new String[]{"slimeknights.tconstruct.gadgets.entity.ExplosionEFLN"});
        prop.setComment("A list of full class names of explosions that should be ignored. Used if explosionClassListType = blacklist");
        explosionBlacklistClassNames = prop.getStringList();
        prop = conf.get(CATEGORY_LISTS, "explosionTypeWhitelist", new String[0]);
        prop.setComment("A list of full class names of explosions that are the only ones that should be acted on. Used if explosionClassListType = whitelist");
        explosionWhitelistClassNames = prop.getStringList();
        Configs.clearAndSetEntityClasses(EXPLOSION_ENTITY_BLACKLIST, explosionEntityBlacklistClassNames);
        Configs.clearAndSetEntityClasses(EXPLOSION_ENTITY_WHITELIST, explosionEntityWhitelistClassNames);
        Configs.clearAndSetExplosionClasses(EXPLOSION_CLASS_BLACKLIST, explosionBlacklistClassNames);
        Configs.clearAndSetExplosionClasses(EXPLOSION_CLASS_WHITELIST, explosionWhitelistClassNames);
        if (disableCreeperExplosionCompletely) {
            CreeperEventHandler.getInstance().register();
        } else {
            CreeperEventHandler.getInstance().unregister();
        }
        if (conf.hasChanged()) {
            conf.save();
        }
    }

    private static void clearAndSetEntityClasses(HashSet<Class<? extends Entity>> set, String[] classNames) {
        set.clear();
        for (String name : classNames) {
            try {
                Class<?> clazz = Class.forName(name);
                if (Entity.class.isAssignableFrom(clazz)) {
                    set.add(clazz);
                    continue;
                }
                EnvironmentalCreepers.logger.warn("Invalid entity class name (not an Entity): '{}'", (Object)name);
            }
            catch (Exception e) {
                EnvironmentalCreepers.logger.warn("Invalid entity class name (class not found): '{}'", (Object)name);
            }
        }
    }

    private static void clearAndSetExplosionClasses(HashSet<Class<? extends Explosion>> set, String[] classNames) {
        set.clear();
        for (String name : classNames) {
            try {
                Class<?> clazz = Class.forName(name);
                if (Explosion.class.isAssignableFrom(clazz)) {
                    set.add(clazz);
                    continue;
                }
                EnvironmentalCreepers.logger.warn("Invalid explosion class name (not an explosion class): '{}'", (Object)name);
            }
            catch (Exception e) {
                EnvironmentalCreepers.logger.warn("Invalid explosion class name (class not found): '{}'", (Object)name);
            }
        }
    }

    static {
        explosionClassListType = ListType.NONE;
        explosionEntityListType = ListType.NONE;
    }

    public static enum ListType {
        NONE("none"),
        BLACKLIST("blacklist"),
        WHITELIST("whitelist");

        private final String name;

        private ListType(String name) {
            this.name = name;
        }

        public static ListType fromName(String name) {
            for (ListType val : ListType.values()) {
                if (!val.name.equalsIgnoreCase(name)) continue;
                return val;
            }
            return NONE;
        }
    }
}

