/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.render;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import cofh.core.util.helpers.RenderHelper;
import cofh.thermaldynamics.block.BlockDuct;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.TravelingItem;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.render.RenderDuct;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderEntityItem;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.ItemHandlerHelper;

public class RenderDuctItems
extends TileEntitySpecialRenderer<TileGrid> {
    public static final RenderDuctItems INSTANCE = new RenderDuctItems();
    static final int ITEMS_TO_RENDER_PER_DUCT = 16;
    static final float ITEM_RENDER_SCALE = 0.7f;
    static RenderEntityItem travelingItemRender;
    static EntityItem travelingEntityItem;
    static float travelingItemSpin;
    public static float spinStep;

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        travelingItemSpin += spinStep;
        travelingItemSpin %= 180.0f;
    }

    public void render(TileGrid tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        DuctUnitItem duct = (DuctUnitItem)tile.getDuct(DuctToken.ITEMS);
        if (duct == null) {
            return;
        }
        CCRenderState ccrs = CCRenderState.instance();
        if (!duct.myItems.isEmpty() || !duct.itemsToAdd.isEmpty()) {
            this.renderTravelingItems(Iterators.concat(duct.itemsToAdd.iterator(), duct.myItems.iterator()), duct, tile.func_145831_w(), x, y, z, partialTicks);
        }
        if (duct.centerLine > 0) {
            GlStateManager.func_179094_E();
            Translation trans = new Vector3(x, y, z).translation();
            ccrs.reset();
            GlStateManager.func_179141_d();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179089_o();
            GlStateManager.func_179112_b((int)770, (int)1);
            RenderHelper.bindTexture((ResourceLocation)RenderHelper.MC_BLOCK_SHEET);
            ccrs.preRenderWorld((IBlockAccess)tile.func_145831_w(), tile.func_174877_v());
            ccrs.colour = -1;
            ccrs.brightness = 0xF000F0;
            int[] connections = RenderDuct.INSTANCE.getDuctConnections(tile);
            ccrs.startDrawing(7, DefaultVertexFormats.field_181712_l);
            for (int s = 0; s < 6; ++s) {
                if (BlockDuct.ConnectionType.VALUES[connections[s]].renderDuct() && duct.centerLineSub[s] != 0) {
                    ccrs.alphaOverride = RenderDuctItems.getAlphaLevel(duct.centerLineSub[s], partialTicks);
                    RenderDuct.modelLine[s].render(ccrs, new IVertexOperation[]{trans, RenderUtils.getIconTransformation((TextureAtlasSprite)RenderDuct.textureCenterLine)});
                    continue;
                }
                ccrs.alphaOverride = RenderDuctItems.getAlphaLevel(duct.centerLine, partialTicks);
                RenderDuct.modelLineCenter.render(ccrs, s * 4, s * 4 + 4, new IVertexOperation[]{trans, RenderUtils.getIconTransformation((TextureAtlasSprite)RenderDuct.textureCenterLine)});
            }
            ccrs.draw();
            ccrs.alphaOverride = -1;
            ccrs.reset();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }

    public static int getAlphaLevel(int centerLine, float frame) {
        return (int)Math.min(80.0, 0.7 * ((double)((float)centerLine - frame) * 255.0) / 10.0);
    }

    public void renderTravelingItems(Iterator<TravelingItem> items, DuctUnitItem duct, World world, double x, double y, double z, float frame) {
        if (!items.hasNext()) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        for (int i = 0; items.hasNext() && i < 16; ++i) {
            TravelingItem renderItem = items.next();
            if (renderItem == null || renderItem.stack.func_190926_b()) continue;
            double v = ((float)renderItem.progress + frame * (float)renderItem.step) / (float)duct.getDuctLength();
            if (renderItem.shouldDie && (v -= 0.5) > 0.0) continue;
            GlStateManager.func_179094_E();
            if (v < 0.0) {
                this.translateItem(renderItem.oldDirection, v);
            } else {
                this.translateItem(renderItem.direction, v);
            }
            GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
            RenderDuctItems.travelingEntityItem.field_70290_d = travelingItemSpin + frame * spinStep;
            travelingEntityItem.func_92058_a(ItemHandlerHelper.copyStackWithSize((ItemStack)renderItem.stack, (int)1));
            travelingItemRender.func_76986_a(travelingEntityItem, 0.0, (double)-0.3f, 0.0, 0.0f, 0.0f);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    private void translateItem(byte direction, double v) {
        EnumFacing face = EnumFacing.field_82609_l[direction];
        GlStateManager.func_179137_b((double)((double)face.func_82601_c() * v), (double)((double)face.func_96559_d() * v), (double)((double)face.func_82599_e() * v));
    }

    static {
        travelingEntityItem = new EntityItem(null);
        travelingItemSpin = 0.25f;
        Minecraft minecraft = Minecraft.func_71410_x();
        travelingItemRender = new RenderEntityItem(minecraft.func_175598_ae(), minecraft.func_175599_af()){

            public boolean shouldBob() {
                return false;
            }

            public boolean shouldSpreadItems() {
                return false;
            }
        };
        RenderDuctItems.travelingEntityItem.field_70290_d = 0.0f;
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        spinStep = 0.026175f;
    }
}

