/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.helpers;

import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;

public enum EnumColor implements IStringSerializable
{
    WHITE(0, "white"),
    LIGHT_GRAY(1, "silver"),
    GRAY(2, "gray"),
    BLACK(3, "black"),
    RED(4, "red"),
    ORANGE(5, "orange"),
    YELLOW(6, "yellow"),
    LIME(7, "lime"),
    GREEN(8, "green"),
    CYAN(9, "cyan"),
    LIGHT_BLUE(10, "light_blue"),
    BLUE(11, "blue"),
    PURPLE(12, "purple"),
    MAGENTA(13, "magenta"),
    PINK(14, "pink"),
    BROWN(15, "brown");

    private int ID;
    private String name;
    private String texturePath;
    private static final EnumColor[] META_LOOKUP;

    private EnumColor(int id, String name) {
        this.ID = id;
        this.name = name;
        this.texturePath = "minecraft:blocks/wool_colored_" + name;
    }

    public String func_176610_l() {
        return this.name;
    }

    public int getID() {
        return this.ID;
    }

    public String getWoolTextureString() {
        return this.texturePath;
    }

    public static EnumColor getColorFromCarpetOrWool(ItemStack stack) {
        EnumColor color = WHITE;
        if (stack != null) {
            switch (stack.func_77952_i()) {
                case 0: {
                    color = WHITE;
                    break;
                }
                case 1: {
                    color = ORANGE;
                    break;
                }
                case 2: {
                    color = MAGENTA;
                    break;
                }
                case 3: {
                    color = LIGHT_BLUE;
                    break;
                }
                case 4: {
                    color = YELLOW;
                    break;
                }
                case 5: {
                    color = LIME;
                    break;
                }
                case 6: {
                    color = PINK;
                    break;
                }
                case 7: {
                    color = GRAY;
                    break;
                }
                case 8: {
                    color = LIGHT_GRAY;
                    break;
                }
                case 9: {
                    color = CYAN;
                    break;
                }
                case 10: {
                    color = PURPLE;
                    break;
                }
                case 11: {
                    color = BLUE;
                    break;
                }
                case 12: {
                    color = BROWN;
                    break;
                }
                case 13: {
                    color = GREEN;
                    break;
                }
                case 14: {
                    color = RED;
                    break;
                }
                case 15: {
                    color = BLACK;
                }
            }
        }
        return color;
    }

    public static EnumColor getColorEnumFromID(int id) {
        EnumColor color = META_LOOKUP[id];
        return color;
    }

    static {
        META_LOOKUP = new EnumColor[EnumColor.values().length];
        EnumColor[] enumColorArray = EnumColor.values();
        int n = enumColorArray.length;
        for (int i = 0; i < n; ++i) {
            EnumColor color;
            EnumColor.META_LOOKUP[color.getID()] = color = enumColorArray[i];
        }
    }
}

