/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.gui;

import java.io.IOException;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.gui.GuiBiblioTextField;
import jds.bibliocraft.gui.GuiButtonClipboard;
import jds.bibliocraft.network.BiblioNetworking;
import jds.bibliocraft.network.packet.server.BiblioMapPin;
import jds.bibliocraft.tileentities.TileEntityMapFrame;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiMapWaypoint
extends GuiScreen {
    private int guiImageWidth = 256;
    private int guiImageHeight = 128;
    private GuiBiblioTextField textField;
    private String text = " ";
    private int colorState = 1;
    private float xLoc;
    private float yLoc;
    private int xcoord;
    private int ycoord;
    private int zcoord;
    private boolean editing = false;
    private int waypointNumber;
    private String wayPointName = " ";
    private GuiButton buttonAccept;
    private GuiButton buttonCancel;
    private GuiButton buttonRemove;
    TileEntityMapFrame mapFrame;

    public GuiMapWaypoint(World world, EntityPlayer player, float xPin, float yPin, TileEntityMapFrame tile, int pinPoint) {
        this.xLoc = xPin;
        this.yLoc = yPin;
        this.mapFrame = tile;
        this.xcoord = tile.func_174877_v().func_177958_n();
        this.ycoord = tile.func_174877_v().func_177956_o();
        this.zcoord = tile.func_174877_v().func_177952_p();
        if (pinPoint == -1) {
            this.editing = false;
            this.waypointNumber = this.mapFrame.getPinXCoords().size() + 1;
            this.wayPointName = I18n.func_74838_a((String)"gui.mapWaypoint.waypoint") + " " + this.waypointNumber;
        } else {
            this.editing = true;
            this.waypointNumber = pinPoint;
            if (this.mapFrame.getPinNames().size() > 0) {
                System.out.println("attempting to get waypoint name");
                this.wayPointName = (String)this.mapFrame.getPinNames().get(this.waypointNumber);
                System.out.println(this.wayPointName);
            }
            if (this.mapFrame.getPinColors().size() > 0) {
                float cs = ((Float)this.mapFrame.getPinColors().get(this.waypointNumber)).floatValue();
                this.colorState = (int)cs;
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        int widthRender = (this.field_146294_l - this.guiImageWidth) / 2;
        int heightRender = (this.field_146295_m - this.guiImageHeight) / 2;
        this.field_146292_n.add(new GuiButtonClipboard(0, widthRender + 120, heightRender + 58, 16, 16, "", true));
        this.buttonAccept = new GuiButton(1, widthRender + 166, heightRender + 56, 52, 20, I18n.func_74838_a((String)"gui.mapWaypoint.accept"));
        this.field_146292_n.add(this.buttonAccept);
        if (this.editing) {
            this.buttonRemove = new GuiButton(3, widthRender + 38, heightRender + 56, 52, 20, I18n.func_74838_a((String)"gui.mapWaypoint.remove"));
            this.field_146292_n.add(this.buttonRemove);
        } else {
            this.buttonCancel = new GuiButton(2, widthRender + 38, heightRender + 56, 52, 20, I18n.func_74838_a((String)"gui.mapWaypoint.cancel"));
            this.field_146292_n.add(this.buttonCancel);
        }
        this.textField = new GuiBiblioTextField(this.field_146289_q, widthRender + 17, heightRender + 34, 222, 12);
        this.textField.setEnableBackgroundDrawing(false);
        this.textField.setTextColor(0x404040);
        this.textField.setMaxStringLength(42);
        this.textField.setText(this.wayPointName);
    }

    public void func_73863_a(int x, int y, float f) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.MAPPINGUI);
        int widthRender = (this.field_146294_l - this.guiImageWidth) / 2;
        int heightRender = (this.field_146295_m - this.guiImageHeight) / 2;
        this.func_73729_b(widthRender, heightRender, 0, 0, this.guiImageWidth, this.guiImageHeight);
        this.textField.drawTextBox();
        super.func_73863_a(x, y, f);
        switch (this.colorState) {
            case 0: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.BLACKWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 1: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.REDWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 2: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.GREENWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 3: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.LIMEWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 4: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.BROWNWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 5: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.BLUEWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 6: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.CYANWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 7: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.LBLUEWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 8: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.PURPLEWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 9: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.MAGENTAWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 10: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.PINKWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 11: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.YELOOWWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 12: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.ORANGEWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 13: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.GRAYWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 14: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.LGRAYWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 15: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.WHITEWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
        }
    }

    public void increaseColor() {
        this.colorState = this.colorState >= 15 ? 0 : ++this.colorState;
    }

    public void decreaseColor() {
        this.colorState = this.colorState <= 0 ? 15 : --this.colorState;
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    protected void func_146284_a(GuiButton click) {
        if (click.field_146127_k == 0) {
            // empty if block
        }
        if (click.field_146127_k == 1) {
            this.sendPacket(false);
            Keyboard.enableRepeatEvents((boolean)false);
            this.field_146297_k.func_147108_a((GuiScreen)null);
        }
        if (click.field_146127_k == 2) {
            Keyboard.enableRepeatEvents((boolean)false);
            this.field_146297_k.func_147108_a((GuiScreen)null);
        }
        if (click.field_146127_k == 3) {
            this.sendPacket(true);
            Keyboard.enableRepeatEvents((boolean)false);
            this.field_146297_k.func_147108_a((GuiScreen)null);
        }
    }

    public void sendPacket(boolean removePin) {
        try {
            BiblioNetworking.INSTANCE.sendToServer((IMessage)new BiblioMapPin(new BlockPos(this.xcoord, this.ycoord, this.zcoord), this.xLoc, this.yLoc, this.textField.getText(), this.colorState, this.waypointNumber, removePin, this.editing));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void func_146281_b() {
    }

    protected void func_73864_a(int x, int y, int click) {
        try {
            super.func_73864_a(x, y, click);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.textField.mouseClicked(x, y, click);
        int w = (this.field_146294_l - 256) / 2;
        int h = (this.field_146295_m - 128) / 2;
        if (x >= w + 120 && x <= w + 135 && y >= h + 58 && y <= h + 73) {
            if (click == 0) {
                this.increaseColor();
            } else if (click == 1) {
                this.decreaseColor();
            }
        }
    }

    protected void func_73869_a(char par1, int par2) {
        if (!this.textField.textboxKeyTyped(par1, par2)) {
            try {
                super.func_73869_a(par1, par2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void updateButtons() {
    }
}

