/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.blocks.BiblioSimpleBlock;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityCookieJar;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;

public class BlockCookieJar
extends BiblioSimpleBlock {
    public static final BlockCookieJar instance = new BlockCookieJar();
    public static final String name = "CookieJar";

    public BlockCookieJar() {
        super(Material.field_151592_s, SoundType.field_185852_e, name);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return this.getBlockBounds(0.18f, 0.0f, 0.18f, 0.82f, 0.75f, 0.82f);
    }

    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (!world.field_72995_K && tile != null && tile instanceof TileEntityCookieJar) {
            TileEntityCookieJar cookiejar = (TileEntityCookieJar)world.func_175625_s(pos);
            if (cookiejar != null) {
                cookiejar.setIsOpen(true);
            }
            player.openGui((Object)BiblioCraft.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCookieJar();
    }

    @Override
    public TRSRTransformation getAdditionalTransforms(TRSRTransformation transform, BiblioTileEntity tile) {
        transform = transform.compose(new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f)));
        return transform;
    }

    @Override
    public List<String> getModelParts(BiblioTileEntity tile) {
        ArrayList<String> modelParts = new ArrayList<String>();
        modelParts.add("jar");
        modelParts.add("lid");
        int numberOfCookies = 0;
        for (int i = 0; i < tile.func_70302_i_(); ++i) {
            if (tile.func_70301_a(i) == ItemStack.field_190927_a) continue;
            ++numberOfCookies;
        }
        if (numberOfCookies >= 1) {
            modelParts.add("cookie001");
        }
        if (numberOfCookies >= 2) {
            modelParts.add("cookie002");
        }
        if (numberOfCookies >= 3) {
            modelParts.add("cookie003");
        }
        if (numberOfCookies >= 4) {
            modelParts.add("cookie004");
        }
        if (numberOfCookies >= 5) {
            modelParts.add("cookie005");
        }
        if (numberOfCookies >= 6) {
            modelParts.add("cookie006");
        }
        if (numberOfCookies >= 7) {
            modelParts.add("cookie007");
        }
        if (numberOfCookies >= 8) {
            modelParts.add("cookie008");
        }
        return modelParts;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState state, IBlockAccess blocka, BlockPos pos, EnumFacing side) {
        boolean ison;
        TileEntityCookieJar cookiejar = (TileEntityCookieJar)blocka.func_175625_s(pos);
        if (cookiejar != null && (ison = cookiejar.getIsOpen())) {
            return 15;
        }
        return 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(state, worldIn, pos, side);
    }
}

