/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.server.command.sub;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import thaumcraft.common.world.aura.AuraHandler;
import thecodex6824.thaumicaugmentation.common.integration.IntegrationAuraControl;
import thecodex6824.thaumicaugmentation.common.integration.IntegrationHandler;
import thecodex6824.thaumicaugmentation.common.world.biome.BiomeUtil;
import thecodex6824.thaumicaugmentation.server.command.sub.ISubCommand;

public class SubCommandFixAura
implements ISubCommand {
    private static final BiFunction<World, ChunkPos, Boolean> AURACONTROL_RESET_AURA = (world, pos) -> SubCommandFixAura.invoke((w, p) -> ((IntegrationAuraControl)IntegrationHandler.getIntegration("auracontrol")).resetAura((World)w, p.field_77276_a, p.field_77275_b), world, pos);

    private static <A, B, C> C invoke(BiFunction<A, B, C> func, A a, B b) {
        return func.apply(a, b);
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 5) {
            BlockPos pos;
            Entity e;
            int x = 0;
            int z = 0;
            int dim = 0;
            boolean force = false;
            if (args.length == 0) {
                e = sender.func_174793_f();
                if (e == null) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("thaumicaugmentation.command.not_entity", new Object[0]));
                    return;
                }
                pos = e.func_180425_c();
                x = pos.func_177958_n() >> 4;
                z = pos.func_177952_p() >> 4;
                dim = e.field_71093_bK;
            } else {
                if (args.length < 3) {
                    throw new WrongUsageException("thaumicaugmentation.command.fixaura.usage", new Object[0]);
                }
                e = sender.func_174793_f();
                pos = e != null ? e.func_180425_c() : BlockPos.field_177992_a;
                x = (int)CommandBase.func_175770_a((double)(pos.func_177958_n() >> 4), (String)args[0], (boolean)false).func_179628_a();
                z = (int)CommandBase.func_175770_a((double)(pos.func_177952_p() >> 4), (String)args[1], (boolean)false).func_179628_a();
                int n = dim = e != null && args[2].equals("~") ? e.field_71093_bK : CommandBase.func_175755_a((String)args[2]);
                if (args.length == 4) {
                    force = Boolean.parseBoolean(args[3]);
                }
            }
            WorldServer world = DimensionManager.getWorld((int)dim);
            if (world != null) {
                if (!world.func_190526_b(x, z)) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("thaumicaugmentation.command.chunk_not_generated", new Object[0]));
                    return;
                }
                if (AuraHandler.getAuraChunk((int)dim, (int)x, (int)z) == null || force) {
                    ChunkPos pos2;
                    if (AuraHandler.getAuraChunk((int)dim, (int)x, (int)z) == null) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("thaumicaugmentation.command.fixaura.aura_regen", new Object[0]));
                    }
                    if (!(IntegrationHandler.isIntegrationPresent("auracontrol") && AURACONTROL_RESET_AURA.apply((World)world, new ChunkPos(x * 16, z * 16)).booleanValue() || BiomeUtil.generateNewAura((World)world, new BlockPos(x * 16, 0, z * 16), false))) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("thaumicaugmentation.command.fixaura.warn_rng_failed", new Object[0]));
                    }
                    CopyOnWriteArrayList<ChunkPos> list = (CopyOnWriteArrayList<ChunkPos>)AuraHandler.dirtyChunks.get(dim);
                    if (!AuraHandler.dirtyChunks.containsKey(dim)) {
                        list = new CopyOnWriteArrayList<ChunkPos>();
                        AuraHandler.dirtyChunks.put(dim, list);
                    }
                    if (!list.contains(pos2 = new ChunkPos(x, z))) {
                        list.add(pos2);
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("thaumicaugmentation.command.fixaura.aura_regen_done", new Object[0]));
                } else {
                    if (!world.func_82736_K().func_82766_b("doDaylightCycle")) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("thaumicaugmentation.command.fixaura.warn_daylight", new Object[0]));
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("thaumicaugmentation.command.fixaura.aura_ok", new Object[0]));
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("thaumicaugmentation.command.dim_unloaded", new Object[0]));
            }
        } else {
            throw new WrongUsageException("thaumicaugmentation.command.fixaura.usage", new Object[0]);
        }
    }

    @Override
    public String getName() {
        return "fixaura";
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(String[] args, int index) {
        return false;
    }
}

