/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.init.proxy;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IRegistryDelegate;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.ICaster;
import thaumcraft.api.golems.seals.ISealEntity;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.client.renderers.models.entity.ModelEldritchGolem;
import thaumcraft.common.config.ModConfig;
import thaumcraft.common.entities.EntityFluxRift;
import thaumcraft.common.golems.client.gui.SealBaseGUI;
import thaumcraft.common.items.casters.ItemFocus;
import thaumcraft.common.lib.events.EssentiaHandler;
import thaumcraft.common.lib.network.fx.PacketFXShield;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TABlocks;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.augment.AugmentAPI;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugment;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugmentableItem;
import thecodex6824.thaumicaugmentation.api.augment.IAugment;
import thecodex6824.thaumicaugmentation.api.augment.IAugmentableItem;
import thecodex6824.thaumicaugmentation.api.augment.builder.IElytraHarnessAugment;
import thecodex6824.thaumicaugmentation.api.augment.builder.caster.CasterAugmentBuilder;
import thecodex6824.thaumicaugmentation.api.augment.builder.caster.ICustomCasterAugment;
import thecodex6824.thaumicaugmentation.api.client.ImpetusRenderingManager;
import thecodex6824.thaumicaugmentation.api.config.TAConfigManager;
import thecodex6824.thaumicaugmentation.api.impetus.CapabilityImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.IImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.ImpetusAPI;
import thecodex6824.thaumicaugmentation.api.impetus.node.CapabilityImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusNode;
import thecodex6824.thaumicaugmentation.api.item.CapabilityBiomeSelector;
import thecodex6824.thaumicaugmentation.api.item.CapabilityMorphicTool;
import thecodex6824.thaumicaugmentation.api.item.IBiomeSelector;
import thecodex6824.thaumicaugmentation.api.item.IDyeableItem;
import thecodex6824.thaumicaugmentation.api.item.IMorphicTool;
import thecodex6824.thaumicaugmentation.api.tile.IEssentiaTube;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;
import thecodex6824.thaumicaugmentation.api.ward.storage.CapabilityWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.ClientWardStorageValue;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorageClient;
import thecodex6824.thaumicaugmentation.api.ward.storage.WardStorageClient;
import thecodex6824.thaumicaugmentation.api.ward.storage.WardStorageServer;
import thecodex6824.thaumicaugmentation.client.event.ClientEventHandler;
import thecodex6824.thaumicaugmentation.client.event.ClientLivingEquipmentChangeEvent;
import thecodex6824.thaumicaugmentation.client.event.RenderEventHandler;
import thecodex6824.thaumicaugmentation.client.event.ResourceReloadDispatcher;
import thecodex6824.thaumicaugmentation.client.fx.FXBlockWardFixed;
import thecodex6824.thaumicaugmentation.client.fx.FXGenericP2ECustomSpeed;
import thecodex6824.thaumicaugmentation.client.fx.FXImpulseBeam;
import thecodex6824.thaumicaugmentation.client.gui.GUIArcaneTerraformer;
import thecodex6824.thaumicaugmentation.client.gui.GUIAutocaster;
import thecodex6824.thaumicaugmentation.client.gui.GUICelestialObserver;
import thecodex6824.thaumicaugmentation.client.gui.GUIWardedChest;
import thecodex6824.thaumicaugmentation.client.model.BuiltInRendererModel;
import thecodex6824.thaumicaugmentation.client.model.CustomCasterAugmentModel;
import thecodex6824.thaumicaugmentation.client.model.DirectionalRetexturingModel;
import thecodex6824.thaumicaugmentation.client.model.GlassTubeModel;
import thecodex6824.thaumicaugmentation.client.model.ModelEldritchGuardianFixed;
import thecodex6824.thaumicaugmentation.client.model.MorphicArmorExclusions;
import thecodex6824.thaumicaugmentation.client.model.MorphicToolModel;
import thecodex6824.thaumicaugmentation.client.model.ProviderModel;
import thecodex6824.thaumicaugmentation.client.model.TAModelLoader;
import thecodex6824.thaumicaugmentation.client.renderer.TARenderHelperClient;
import thecodex6824.thaumicaugmentation.client.renderer.entity.RenderAutocaster;
import thecodex6824.thaumicaugmentation.client.renderer.entity.RenderCelestialObserver;
import thecodex6824.thaumicaugmentation.client.renderer.entity.RenderDimensionalFracture;
import thecodex6824.thaumicaugmentation.client.renderer.entity.RenderFluxRiftOptimized;
import thecodex6824.thaumicaugmentation.client.renderer.entity.RenderFocusShield;
import thecodex6824.thaumicaugmentation.client.renderer.entity.RenderItemImportant;
import thecodex6824.thaumicaugmentation.client.renderer.entity.RenderPrimalWisp;
import thecodex6824.thaumicaugmentation.client.renderer.entity.RenderTAEldritchGolem;
import thecodex6824.thaumicaugmentation.client.renderer.entity.RenderTAEldritchGuardian;
import thecodex6824.thaumicaugmentation.client.renderer.entity.RenderTAGolemOrb;
import thecodex6824.thaumicaugmentation.client.renderer.layer.RenderLayerHarness;
import thecodex6824.thaumicaugmentation.client.renderer.tile.ListeningAnimatedTESR;
import thecodex6824.thaumicaugmentation.client.renderer.tile.RenderAltar;
import thecodex6824.thaumicaugmentation.client.renderer.tile.RenderEldritchLock;
import thecodex6824.thaumicaugmentation.client.renderer.tile.RenderGlassTube;
import thecodex6824.thaumicaugmentation.client.renderer.tile.RenderImpetusMirror;
import thecodex6824.thaumicaugmentation.client.renderer.tile.RenderObelisk;
import thecodex6824.thaumicaugmentation.client.renderer.tile.RenderObeliskVisual;
import thecodex6824.thaumicaugmentation.client.renderer.tile.RenderRiftBarrier;
import thecodex6824.thaumicaugmentation.client.renderer.tile.RenderRiftJar;
import thecodex6824.thaumicaugmentation.client.renderer.tile.RenderRiftMonitor;
import thecodex6824.thaumicaugmentation.client.renderer.tile.RenderRiftMoverOutput;
import thecodex6824.thaumicaugmentation.client.renderer.tile.RenderStarfieldGlass;
import thecodex6824.thaumicaugmentation.client.renderer.tile.RenderVoidRechargePedestal;
import thecodex6824.thaumicaugmentation.client.shader.TAShaderManager;
import thecodex6824.thaumicaugmentation.client.shader.TAShaders;
import thecodex6824.thaumicaugmentation.client.sound.ClientSoundHandler;
import thecodex6824.thaumicaugmentation.client.sound.MovingSoundRecord;
import thecodex6824.thaumicaugmentation.client.sound.SoundHandleSpecialSound;
import thecodex6824.thaumicaugmentation.common.container.ContainerArcaneTerraformer;
import thecodex6824.thaumicaugmentation.common.container.ContainerAutocaster;
import thecodex6824.thaumicaugmentation.common.container.ContainerCelestialObserver;
import thecodex6824.thaumicaugmentation.common.container.ContainerWardedChest;
import thecodex6824.thaumicaugmentation.common.entity.EntityAutocaster;
import thecodex6824.thaumicaugmentation.common.entity.EntityAutocasterEldritch;
import thecodex6824.thaumicaugmentation.common.entity.EntityCelestialObserver;
import thecodex6824.thaumicaugmentation.common.entity.EntityDimensionalFracture;
import thecodex6824.thaumicaugmentation.common.entity.EntityFocusShield;
import thecodex6824.thaumicaugmentation.common.entity.EntityItemImportant;
import thecodex6824.thaumicaugmentation.common.entity.EntityPrimalWisp;
import thecodex6824.thaumicaugmentation.common.entity.EntityTAEldritchGolem;
import thecodex6824.thaumicaugmentation.common.entity.EntityTAEldritchGuardian;
import thecodex6824.thaumicaugmentation.common.entity.EntityTAEldritchWarden;
import thecodex6824.thaumicaugmentation.common.entity.EntityTAGolemOrb;
import thecodex6824.thaumicaugmentation.common.item.ItemCustomCasterEffectProvider;
import thecodex6824.thaumicaugmentation.common.item.ItemCustomCasterStrengthProvider;
import thecodex6824.thaumicaugmentation.common.item.ItemFractureLocator;
import thecodex6824.thaumicaugmentation.common.item.ItemKey;
import thecodex6824.thaumicaugmentation.common.network.PacketAugmentableItemSync;
import thecodex6824.thaumicaugmentation.common.network.PacketBaubleChange;
import thecodex6824.thaumicaugmentation.common.network.PacketBiomeUpdate;
import thecodex6824.thaumicaugmentation.common.network.PacketBoostState;
import thecodex6824.thaumicaugmentation.common.network.PacketConfigSync;
import thecodex6824.thaumicaugmentation.common.network.PacketEntityCast;
import thecodex6824.thaumicaugmentation.common.network.PacketEssentiaUpdate;
import thecodex6824.thaumicaugmentation.common.network.PacketFlightState;
import thecodex6824.thaumicaugmentation.common.network.PacketFollowingOrb;
import thecodex6824.thaumicaugmentation.common.network.PacketFractureLocatorUpdate;
import thecodex6824.thaumicaugmentation.common.network.PacketFullImpetusNodeSync;
import thecodex6824.thaumicaugmentation.common.network.PacketFullWardSync;
import thecodex6824.thaumicaugmentation.common.network.PacketImpetusNodeUpdate;
import thecodex6824.thaumicaugmentation.common.network.PacketImpetusTransaction;
import thecodex6824.thaumicaugmentation.common.network.PacketImpulseBeam;
import thecodex6824.thaumicaugmentation.common.network.PacketImpulseBurst;
import thecodex6824.thaumicaugmentation.common.network.PacketImpulseRailgunProjectile;
import thecodex6824.thaumicaugmentation.common.network.PacketLivingEquipmentChange;
import thecodex6824.thaumicaugmentation.common.network.PacketParticleEffect;
import thecodex6824.thaumicaugmentation.common.network.PacketRecoil;
import thecodex6824.thaumicaugmentation.common.network.PacketRiftJarInstability;
import thecodex6824.thaumicaugmentation.common.network.PacketTerraformerWork;
import thecodex6824.thaumicaugmentation.common.network.PacketWardUpdate;
import thecodex6824.thaumicaugmentation.common.network.PacketWispZap;
import thecodex6824.thaumicaugmentation.common.tile.TileAltar;
import thecodex6824.thaumicaugmentation.common.tile.TileArcaneTerraformer;
import thecodex6824.thaumicaugmentation.common.tile.TileEldritchLock;
import thecodex6824.thaumicaugmentation.common.tile.TileGlassTube;
import thecodex6824.thaumicaugmentation.common.tile.TileImpetusDiffuser;
import thecodex6824.thaumicaugmentation.common.tile.TileImpetusDrainer;
import thecodex6824.thaumicaugmentation.common.tile.TileImpetusGate;
import thecodex6824.thaumicaugmentation.common.tile.TileImpetusMatrix;
import thecodex6824.thaumicaugmentation.common.tile.TileImpetusMirror;
import thecodex6824.thaumicaugmentation.common.tile.TileObelisk;
import thecodex6824.thaumicaugmentation.common.tile.TileObeliskVisual;
import thecodex6824.thaumicaugmentation.common.tile.TileRiftBarrier;
import thecodex6824.thaumicaugmentation.common.tile.TileRiftJar;
import thecodex6824.thaumicaugmentation.common.tile.TileRiftMonitor;
import thecodex6824.thaumicaugmentation.common.tile.TileRiftMoverOutput;
import thecodex6824.thaumicaugmentation.common.tile.TileStabilityFieldGenerator;
import thecodex6824.thaumicaugmentation.common.tile.TileStarfieldGlass;
import thecodex6824.thaumicaugmentation.common.tile.TileVisRegenerator;
import thecodex6824.thaumicaugmentation.common.tile.TileVoidRechargePedestal;
import thecodex6824.thaumicaugmentation.common.tile.TileWardedChest;
import thecodex6824.thaumicaugmentation.common.util.IResourceReloadDispatcher;
import thecodex6824.thaumicaugmentation.common.util.ISoundHandle;
import thecodex6824.thaumicaugmentation.common.util.ITARenderHelper;
import thecodex6824.thaumicaugmentation.common.util.MorphicArmorHelper;
import thecodex6824.thaumicaugmentation.common.world.biome.BiomeUtil;
import thecodex6824.thaumicaugmentation.init.GUIHandler;
import thecodex6824.thaumicaugmentation.init.proxy.ServerProxy;

public class ClientProxy
extends ServerProxy {
    private KeyBinding elytraBoost;
    private HashMap<Class<? extends IMessage>, BiConsumer<IMessage, MessageContext>> handlers = new HashMap();
    private ResourceReloadDispatcher reloadDispatcher;

    public ClientProxy() {
        this.handlers.put(PacketParticleEffect.class, (message, ctx) -> this.handleParticlePacket((PacketParticleEffect)message, (MessageContext)ctx));
        this.handlers.put(PacketConfigSync.class, (message, ctx) -> this.handleConfigSyncPacket((PacketConfigSync)message, (MessageContext)ctx));
        this.handlers.put(PacketAugmentableItemSync.class, (message, ctx) -> this.handleAugmentableItemSyncPacket((PacketAugmentableItemSync)message, (MessageContext)ctx));
        this.handlers.put(PacketFullWardSync.class, (message, ctx) -> this.handleFullWardSyncPacket((PacketFullWardSync)message, (MessageContext)ctx));
        this.handlers.put(PacketWardUpdate.class, (message, ctx) -> this.handleWardUpdatePacket((PacketWardUpdate)message, (MessageContext)ctx));
        this.handlers.put(PacketFractureLocatorUpdate.class, (message, ctx) -> this.handleFractureLocatorUpdatePacket((PacketFractureLocatorUpdate)message, (MessageContext)ctx));
        this.handlers.put(PacketEntityCast.class, (message, ctx) -> this.handleEntityCastPacket((PacketEntityCast)message, (MessageContext)ctx));
        this.handlers.put(PacketFullImpetusNodeSync.class, (message, ctx) -> this.handleFullImpetusNodeSyncPacket((PacketFullImpetusNodeSync)message, (MessageContext)ctx));
        this.handlers.put(PacketImpetusNodeUpdate.class, (message, ctx) -> this.handleImpetusNodeUpdatePacket((PacketImpetusNodeUpdate)message, (MessageContext)ctx));
        this.handlers.put(PacketImpetusTransaction.class, (message, ctx) -> this.handleImpetusTransationPacket((PacketImpetusTransaction)message, (MessageContext)ctx));
        this.handlers.put(PacketRiftJarInstability.class, (message, ctx) -> this.handleRiftJarInstabilityPacket((PacketRiftJarInstability)message, (MessageContext)ctx));
        this.handlers.put(PacketBiomeUpdate.class, (message, ctx) -> this.handleBiomeUpdatePacket((PacketBiomeUpdate)message, (MessageContext)ctx));
        this.handlers.put(PacketFXShield.class, (message, ctx) -> this.handleFXShieldPacket((PacketFXShield)message, (MessageContext)ctx));
        this.handlers.put(PacketImpulseBeam.class, (message, ctx) -> this.handleImpulseBeamPacket((PacketImpulseBeam)message, (MessageContext)ctx));
        this.handlers.put(PacketImpulseBurst.class, (message, ctx) -> this.handleImpulseBurstPacket((PacketImpulseBurst)message, (MessageContext)ctx));
        this.handlers.put(PacketImpulseRailgunProjectile.class, (message, ctx) -> this.handleImpulseRailgunPacket((PacketImpulseRailgunProjectile)message, (MessageContext)ctx));
        this.handlers.put(PacketLivingEquipmentChange.class, (message, ctx) -> this.handleLivingEquipmentChangePacket((PacketLivingEquipmentChange)message, (MessageContext)ctx));
        this.handlers.put(PacketBaubleChange.class, (message, ctx) -> this.handleBaubleChangePacket((PacketBaubleChange)message, (MessageContext)ctx));
        this.handlers.put(PacketWispZap.class, (message, ctx) -> this.handleWispZapPacket((PacketWispZap)message, (MessageContext)ctx));
        this.handlers.put(PacketFollowingOrb.class, (message, ctx) -> this.handleFollowingOrbPacket((PacketFollowingOrb)message, (MessageContext)ctx));
        this.handlers.put(PacketFlightState.class, (message, ctx) -> this.handleFlightStatePacket((PacketFlightState)message, (MessageContext)ctx));
        this.handlers.put(PacketBoostState.class, (message, ctx) -> this.handleBoostStatePacket((PacketBoostState)message, (MessageContext)ctx));
        this.handlers.put(PacketRecoil.class, (message, ctx) -> this.handleRecoilPacket((PacketRecoil)message, (MessageContext)ctx));
        this.handlers.put(PacketTerraformerWork.class, (message, ctx) -> this.handleTerraformerWorkPacket((PacketTerraformerWork)message, (MessageContext)ctx));
        this.handlers.put(PacketEssentiaUpdate.class, (message, ctx) -> this.handleEssentiaUpdatePacket((PacketEssentiaUpdate)message, (MessageContext)ctx));
        this.reloadDispatcher = new ResourceReloadDispatcher();
    }

    @Override
    public IAnimationStateMachine loadASM(ResourceLocation loc, ImmutableMap<String, ITimeValue> params) {
        return ModelLoaderRegistry.loadASM((ResourceLocation)loc, params);
    }

    @Override
    public ITARenderHelper getRenderHelper() {
        if (renderHelper == null) {
            renderHelper = new TARenderHelperClient();
        }
        return renderHelper;
    }

    @Override
    public IWardStorage createWardStorageInstance(World world) {
        return world.field_72995_K ? new WardStorageClient() : new WardStorageServer();
    }

    @Override
    public void registerRenderableImpetusNode(IImpetusNode node) {
        ImpetusRenderingManager.registerRenderableNode(node);
    }

    @Override
    public boolean deregisterRenderableImpetusNode(IImpetusNode node) {
        return ImpetusRenderingManager.deregisterRenderableNode(node);
    }

    @Override
    public boolean isOpenToLAN() {
        return Minecraft.func_71410_x().func_71401_C() != null && Minecraft.func_71410_x().func_71401_C().func_71344_c();
    }

    @Override
    public boolean isSingleplayer() {
        return Minecraft.func_71410_x().func_71356_B();
    }

    @Override
    public boolean isInGame() {
        return Minecraft.func_71410_x().func_175606_aa() != null;
    }

    @Override
    public boolean isElytraBoostKeyDown() {
        if (this.elytraBoost != null) {
            return this.elytraBoost.func_151470_d();
        }
        return Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
    }

    @Override
    public boolean isPvPEnabled() {
        return Minecraft.func_71410_x().func_71401_C() != null && Minecraft.func_71410_x().func_71401_C().func_71219_W();
    }

    @Override
    public boolean isEntityClientPlayer(Entity e) {
        return e == Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public boolean isEntityRenderView(Entity e) {
        return e == Minecraft.func_71410_x().func_175606_aa();
    }

    @Override
    public float getPartialTicks() {
        return Minecraft.func_71410_x().func_184121_ak();
    }

    @Override
    public Object getClientGUIElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        switch (GUIHandler.TAInventory.values()[ID]) {
            case WARDED_CHEST: {
                return new GUIWardedChest((ContainerWardedChest)this.getServerGUIElement(ID, player, world, x, y, z), player.field_71071_by);
            }
            case ARCANE_TERRAFORMER: {
                return new GUIArcaneTerraformer((ContainerArcaneTerraformer)this.getServerGUIElement(ID, player, world, x, y, z));
            }
            case AUTOCASTER: {
                return new GUIAutocaster((ContainerAutocaster)this.getServerGUIElement(ID, player, world, x, y, z));
            }
            case CELESTIAL_OBSERVER: {
                return new GUICelestialObserver((ContainerCelestialObserver)this.getServerGUIElement(ID, player, world, x, y, z));
            }
        }
        return null;
    }

    @Override
    public Object getSealGUI(World world, EntityPlayer player, BlockPos pos, EnumFacing face, ISealEntity seal) {
        return new SealBaseGUI(player.field_71071_by, world, seal);
    }

    @Override
    public ISoundHandle playSpecialSound(SoundEvent sound, SoundCategory category, Function<Vec3d, Vec3d> tick, float x, float y, float z, float vol, float pitch, boolean repeat, int repeatDelay) {
        MovingSoundRecord audio = new MovingSoundRecord(sound, category, tick, x, y, z, vol, pitch, repeat, repeatDelay);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)audio);
        return new SoundHandleSpecialSound(audio);
    }

    @Override
    public void handlePacketServer(IMessage message, MessageContext context) {
        if (Minecraft.func_71410_x().func_71401_C() == null) {
            ThaumicAugmentation.getLogger().warn("A packet was received on the wrong side: " + message.getClass().toString());
        } else {
            super.handlePacketServer(message, context);
        }
    }

    @Override
    public void handlePacketClient(IMessage message, MessageContext context) {
        BiConsumer<IMessage, MessageContext> handler = this.handlers.get(message.getClass());
        if (handler != null) {
            handler.accept(message, context);
        } else {
            ThaumicAugmentation.getLogger().warn("An unknown packet was received and will be dropped: " + message.getClass().toString());
        }
    }

    protected void handleParticlePacket(PacketParticleEffect message, MessageContext context) {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            Random rand = FMLClientHandler.instance().getClient().field_71441_e.field_73012_v;
            double[] d = message.getData();
            switch (message.getEffect()) {
                case VIS_REGENERATOR: {
                    if (d.length != 3) break;
                    int particles = 3;
                    if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 1) {
                        particles = 2;
                    } else if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 2) {
                        particles = 1;
                    }
                    for (int i = 0; i < rand.nextInt(3) + particles; ++i) {
                        double x = d[0] + rand.nextGaussian() / 4.0;
                        double y = d[1] + rand.nextDouble() / 2.0;
                        double z = d[2] + rand.nextGaussian() / 4.0;
                        double vX = rand.nextGaussian() / 4.0;
                        double vY = rand.nextDouble() / 2.0;
                        double vZ = rand.nextGaussian() / 4.0;
                        FXDispatcher.INSTANCE.drawVentParticles(x, y, z, vX, vY, vZ, Aspect.AURA.getColor());
                    }
                    break;
                }
                case VOID_STREAKS: {
                    if (d.length != 7) break;
                    double x1 = d[0];
                    double y1 = d[1];
                    double z1 = d[2];
                    double x2 = d[3];
                    double y2 = d[4];
                    double z2 = d[5];
                    float scale = (float)d[6];
                    FXDispatcher.INSTANCE.voidStreak(x1, y1, z1, x2, y2, z2, rand.nextInt(), scale);
                    break;
                }
                case WARD: {
                    if (d.length != 4) break;
                    double x = d[0];
                    double y = d[1];
                    double z = d[2];
                    EnumFacing dir = EnumFacing.func_82600_a((int)((int)d[3]));
                    BlockPos pos = new BlockPos(x, y, z);
                    IBlockState state = Minecraft.func_71410_x().field_71441_e.func_180495_p(pos);
                    AxisAlignedBB box = state.func_185900_c((IBlockAccess)Minecraft.func_71410_x().field_71441_e, pos);
                    float hitX = (float)(box.field_72336_d + box.field_72340_a) / 2.0f;
                    float hitY = (float)(box.field_72337_e + box.field_72338_b) / 2.0f;
                    float hitZ = (float)(box.field_72334_f + box.field_72339_c) / 2.0f;
                    if (dir.func_82601_c() != 0) {
                        hitX = 0.5f * (float)(-dir.func_82601_c()) + (float)(dir.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? box.field_72340_a : box.field_72336_d);
                    }
                    if (dir.func_96559_d() != 0) {
                        hitY = 0.5f * (float)(-dir.func_96559_d()) + (float)(dir.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? box.field_72338_b : box.field_72337_e);
                    }
                    if (dir.func_82599_e() != 0) {
                        hitZ = 0.5f * (float)(-dir.func_82599_e()) + (float)(dir.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? box.field_72339_c : box.field_72334_f);
                    }
                    FXBlockWardFixed ward = new FXBlockWardFixed(FXDispatcher.INSTANCE.getWorld(), x, y, z, dir, hitX, hitY, hitZ);
                    FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)ward);
                    break;
                }
                case POOF: {
                    if (d.length != 5) break;
                    double x = d[0];
                    double y = d[1];
                    double z = d[2];
                    int color = (int)d[3];
                    int index = (int)d[4];
                    FXDispatcher.INSTANCE.drawBamf(new BlockPos(x, y, z), color, true, true, EnumFacing.func_82600_a((int)index));
                    break;
                }
                case SMOKE_SPIRAL: {
                    if (d.length != 7) break;
                    double x = d[0];
                    double y = d[1];
                    double z = d[2];
                    float radius = (float)d[3];
                    int start = (int)d[4];
                    int minY = (int)d[5];
                    int color = (int)d[6];
                    FXDispatcher.INSTANCE.smokeSpiral(x, y, z, radius, start, minY, color);
                    break;
                }
                case CURLY_WISP: {
                    if (d.length != 3) break;
                    double x = d[0];
                    double y = d[1];
                    double z = d[2];
                    FXDispatcher.INSTANCE.drawCurlyWisp(x, y, z, 0.0, 0.0, 0.0, rand.nextFloat() + 0.1f, 1.0f, 1.0f, 1.0f, 0.45f, null, 1, 0, 0);
                    break;
                }
                case ESSENTIA_TRAIL: {
                    if (d.length != 7) break;
                    int x1 = (int)d[0];
                    int y1 = (int)d[1];
                    int z1 = (int)d[2];
                    int x2 = (int)d[3];
                    int y2 = (int)d[4];
                    int z2 = (int)d[5];
                    int color = (int)d[6];
                    String key = x2 + ":" + y2 + ":" + z2 + ":" + x1 + ":" + y1 + ":" + z1 + ":" + color;
                    if (EssentiaHandler.sourceFX.containsKey(key)) break;
                    EssentiaHandler.sourceFX.put(key, new EssentiaHandler.EssentiaSourceFX(new BlockPos(x2, y2, z2), new BlockPos(x1, y1, z1), color, 15));
                    break;
                }
                case EXPLOSION: {
                    if (d.length != 3) break;
                    double x = d[0];
                    double y = d[1];
                    double z = d[2];
                    Minecraft.func_71410_x().field_71441_e.func_175682_a(EnumParticleTypes.EXPLOSION_HUGE, false, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SPARK: {
                    if (d.length != 5) break;
                    double x = d[0];
                    double y = d[1];
                    double z = d[2];
                    float size = (float)d[3];
                    int color = (int)d[4];
                    this.getRenderHelper().renderSpark((World)Minecraft.func_71410_x().field_71441_e, x, y, z, size, color, false);
                    break;
                }
                case FIRE: {
                    if (d.length != 5) break;
                    double x = d[0];
                    double y = d[1];
                    double z = d[2];
                    float size = (float)d[3];
                    int color = (int)d[4];
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    FXDispatcher.INSTANCE.drawFireMote((float)x, (float)y, (float)z, 0.0f, 0.0f, 0.0f, r, g, b, 0.75f, size);
                    break;
                }
                case FIRE_EXPLOSION: {
                    if (d.length != 5) break;
                    double x = d[0];
                    double y = d[1];
                    double z = d[2];
                    float size = (float)d[3];
                    int color = (int)d[4];
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    int particles = 16;
                    if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 1) {
                        particles = 8;
                    } else if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 2) {
                        particles = 3;
                    }
                    for (int i = 0; i < particles; ++i) {
                        FXDispatcher.INSTANCE.drawFireMote((float)x, (float)y, (float)z, (rand.nextFloat() - rand.nextFloat()) / 10.0f, (rand.nextFloat() - rand.nextFloat()) / 10.0f, (rand.nextFloat() - rand.nextFloat()) / 10.0f, r, g, b, 0.75f, size);
                    }
                    break;
                }
                case GENERIC_SPHERE: {
                    if (d.length != 5) break;
                    double x = d[0];
                    double y = d[1];
                    double z = d[2];
                    float size = (float)d[3];
                    int color = (int)d[4];
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    FXGeneric fx = new FXGeneric((World)Minecraft.func_71410_x().field_71441_e, x, y, z, 0.0, 0.0, 0.0);
                    fx.func_70538_b(r, g, b);
                    fx.setAlphaF(new float[]{0.9f, 0.0f});
                    fx.setGridSize(64);
                    fx.setParticles(264, 8, 1);
                    fx.setScale(new float[]{size});
                    fx.setLayer(1);
                    fx.setLoop(true);
                    fx.setRotationSpeed(rand.nextFloat(), rand.nextBoolean() ? 1.0f : -1.0f);
                    ParticleEngine.addEffect((World)Minecraft.func_71410_x().field_71441_e, (Particle)fx);
                    break;
                }
                case SPLASH_BATCH: {
                    if (d.length % 3 != 0) break;
                    for (int i = 0; i < d.length; i += 3) {
                        double x = d[i];
                        double y = d[i + 1];
                        double z = d[i + 2];
                        WorldClient world = Minecraft.func_71410_x().field_71441_e;
                        world.func_175682_a(EnumParticleTypes.WATER_SPLASH, false, x, y, z, (double)(world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.5, (double)(world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.5, (double)(world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.5, new int[0]);
                    }
                    break;
                }
                case SMOKE_LARGE: {
                    if (d.length != 3) break;
                    double x = d[0];
                    double y = d[1];
                    double z = d[2];
                    Minecraft.func_71410_x().field_71441_e.func_175682_a(EnumParticleTypes.SMOKE_LARGE, false, x, y, z, 0.0, 0.05, 0.0, new int[0]);
                    break;
                }
                case FIRE_MULTIPLE_RAND: {
                    if (d.length != 5) break;
                    double x = d[0];
                    double y = d[1];
                    double z = d[2];
                    float size = (float)d[3];
                    int color = (int)d[4];
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    for (int i = 0; i < rand.nextInt(4) + 3; ++i) {
                        FXDispatcher.INSTANCE.drawFireMote((float)x + (rand.nextFloat() - rand.nextFloat()), (float)y + (rand.nextFloat() - rand.nextFloat()), (float)z + (rand.nextFloat() - rand.nextFloat()), 0.0f, 0.0f, 0.0f, r, g, b, 0.75f, size);
                    }
                    break;
                }
                case BLOCK_RUNES: {
                    if (d.length != 3) break;
                    double x = d[0];
                    double y = d[1];
                    double z = d[2];
                    int particles = 10;
                    if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 1) {
                        particles = 5;
                    } else if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 2) {
                        particles = 1;
                    }
                    for (int i = 0; i < particles; ++i) {
                        FXDispatcher.INSTANCE.blockRunes(x, y + 0.25, z, 0.3f + rand.nextFloat() * 0.7f, 0.0f, 0.3f + rand.nextFloat() * 0.7f, 15, 0.03f);
                    }
                    break;
                }
                case FLUX: {
                    if (d.length != 3) break;
                    int x = (int)d[0];
                    int y = (int)d[1];
                    int z = (int)d[2];
                    FXDispatcher.INSTANCE.drawPollutionParticles(new BlockPos(x, y, z));
                    break;
                }
                case FLUX_BATCH: {
                    if (d.length % 3 != 0) break;
                    for (int i = 0; i < d.length; i += 3) {
                        int x = (int)d[i];
                        int y = (int)d[i + 1];
                        int z = (int)d[i + 2];
                        FXDispatcher.INSTANCE.drawPollutionParticles(new BlockPos(x, y, z));
                    }
                    break;
                }
                case ARC: {
                    if (d.length != 8) break;
                    double sx = d[0];
                    double sy = d[1];
                    double sz = d[2];
                    double dx = d[3];
                    double dy = d[4];
                    double dz = d[5];
                    int color = (int)d[6];
                    double height = d[7];
                    this.getRenderHelper().renderArc((World)Minecraft.func_71410_x().field_71441_e, sx, sy, sz, dx, dy, dz, color, height);
                    break;
                }
                case ENDER_EYE_BREAK: {
                    if (d.length != 4) break;
                    WorldClient world = Minecraft.func_71410_x().field_71441_e;
                    double x = d[0];
                    double y = d[1];
                    double z = d[2];
                    for (int i = 0; i < 8; ++i) {
                        world.func_175682_a(EnumParticleTypes.ITEM_CRACK, true, x, y, z, rand.nextGaussian() * 0.15, rand.nextDouble() * 0.2, rand.nextGaussian() * 0.15, new int[]{(int)d[3]});
                    }
                    float angle = 0.0f;
                    while ((double)angle < Math.PI * 2) {
                        world.func_175682_a(EnumParticleTypes.PORTAL, true, x + (double)(MathHelper.func_76134_b((float)angle) * 5.0f), y - (double)0.4f, z + (double)(MathHelper.func_76126_a((float)angle) * 5.0f), (double)(MathHelper.func_76134_b((float)angle) * -5.0f), 0.0, (double)(MathHelper.func_76126_a((float)angle) * -5.0f), new int[0]);
                        world.func_175688_a(EnumParticleTypes.PORTAL, x + (double)(MathHelper.func_76134_b((float)angle) * 5.0f), y - (double)0.4f, z + (double)(MathHelper.func_76126_a((float)angle) * 5.0f), (double)(MathHelper.func_76134_b((float)angle) * -7.0f), 0.0, (double)(MathHelper.func_76126_a((float)angle) * -7.0f), new int[0]);
                        angle += 0.15707964f;
                    }
                    break;
                }
                case VIS_OPERATION: {
                    if (d.length != 10) break;
                    WorldClient world = Minecraft.func_71410_x().field_71441_e;
                    double x = d[0];
                    double y = d[1];
                    double z = d[2];
                    double dx = d[3];
                    double dy = d[4];
                    double dz = d[5];
                    float r = (float)d[6];
                    float g = (float)d[7];
                    float b = (float)d[8];
                    float a = (float)d[9];
                    int particles = 10;
                    if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 1) {
                        particles = 5;
                    } else if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 2) {
                        particles = 1;
                    }
                    for (int i = 0; i < particles; ++i) {
                        FXDispatcher.INSTANCE.drawGenericParticles(x + (double)(world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()), y + (double)(world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()), z + (double)(world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()), dx, dy, dz, r, g, b, a, false, 448, 9, 1, 6 + world.field_73012_v.nextInt(5), 0, 0.3f + world.field_73012_v.nextFloat() * 0.3f, 0.0f, 1);
                    }
                    break;
                }
            }
        }
    }

    protected void handleConfigSyncPacket(PacketConfigSync message, MessageContext context) {
        TAConfigManager.sync(context.side, message.getBuffer());
    }

    protected void handleAugmentableItemSyncPacket(PacketAugmentableItemSync message, MessageContext context) {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.getEntityID());
        if (entity != null) {
            int i = 0;
            for (Function<Entity, Iterable<ItemStack>> func : AugmentAPI.getAugmentableItemSources()) {
                for (ItemStack stack : func.apply(entity)) {
                    IAugmentableItem augmentable;
                    if (i == message.getItemIndex() && (augmentable = (IAugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)) != null) {
                        augmentable.readSyncNBT(message.getTagCompound());
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    protected void handleFullWardSyncPacket(PacketFullWardSync message, MessageContext context) {
        IWardStorage s;
        int chunkZ;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        NBTTagCompound tag = message.getTag();
        int chunkX = tag.func_74762_e("x");
        if (world.func_175667_e(new BlockPos(chunkX << 4, 0, (chunkZ = tag.func_74762_e("z")) << 4)) && (s = (IWardStorage)world.func_72964_e(chunkX, chunkZ).getCapability(CapabilityWardStorage.WARD_STORAGE, null)) instanceof IWardStorageClient) {
            ((IWardStorageClient)s).deserializeNBT(tag);
        }
    }

    protected void handleWardUpdatePacket(PacketWardUpdate message, MessageContext context) {
        IWardStorage s;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        BlockPos pos = new BlockPos(message.getX(), message.getY(), message.getZ());
        if (world.func_175667_e(pos) && (s = (IWardStorage)world.func_175726_f(pos).getCapability(CapabilityWardStorage.WARD_STORAGE, null)) instanceof IWardStorageClient) {
            ((IWardStorageClient)s).setWard(pos, ClientWardStorageValue.fromID(message.getStatus()));
        }
    }

    protected void handleFractureLocatorUpdatePacket(PacketFractureLocatorUpdate message, MessageContext context) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ItemFractureLocator)) continue;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74757_a("found", message.wasFractureFound());
            if (!message.wasFractureFound()) continue;
            stack.func_77978_p().func_74783_a("pos", new int[]{message.getX(), message.getY(), message.getZ()});
        }
    }

    protected void handleEntityCastPacket(PacketEntityCast message, MessageContext context) {
        RenderEventHandler.onEntityCast(message.getEntityID());
    }

    protected void handleFullImpetusNodeSyncPacket(PacketFullImpetusNodeSync message, MessageContext context) {
        IImpetusNode node;
        TileEntity tile;
        NBTTagCompound tag = message.getTag();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        BlockPos pos = message.getNode();
        if (world.func_175667_e(pos) && (tile = world.func_175625_s(pos)) != null && (node = (IImpetusNode)tile.getCapability(CapabilityImpetusNode.IMPETUS_NODE, null)) != null) {
            node.readSyncNBT(tag);
        }
    }

    protected void handleImpetusNodeUpdatePacket(PacketImpetusNodeUpdate message, MessageContext context) {
        IImpetusNode node;
        TileEntity tile;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world.func_175667_e(message.getNode()) && (tile = world.func_175625_s(message.getNode())) != null && (node = (IImpetusNode)tile.getCapability(CapabilityImpetusNode.IMPETUS_NODE, null)) != null) {
            IImpetusNode destNode;
            TileEntity destTile;
            DimensionalBlockPos dest = message.getDest();
            if (dest.getDimension() == world.field_73011_w.getDimension() && world.func_175667_e(dest.getPos()) && (destTile = world.func_175625_s(dest.getPos())) != null && (destNode = (IImpetusNode)destTile.getCapability(CapabilityImpetusNode.IMPETUS_NODE, null)) != null) {
                if (message.isOutput()) {
                    if (message.shouldRemove()) {
                        node.removeOutput(destNode);
                    } else {
                        node.addOutput(destNode);
                    }
                } else if (message.shouldRemove()) {
                    node.removeInput(destNode);
                } else {
                    node.addInput(destNode);
                }
                return;
            }
            if (message.isOutput()) {
                if (message.shouldRemove()) {
                    node.removeOutputLocation(message.getDest());
                } else {
                    node.addOutputLocation(message.getDest());
                }
            } else if (message.shouldRemove()) {
                node.removeInputLocation(message.getDest());
            } else {
                node.addInputLocation(message.getDest());
            }
        }
    }

    protected void handleImpetusTransationPacket(PacketImpetusTransaction message, MessageContext context) {
        RenderEventHandler.onImpetusTransaction(message.getPositions());
    }

    protected void handleRiftJarInstabilityPacket(PacketRiftJarInstability message, MessageContext context) {
        TileEntity tile;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world.func_175667_e(message.getPosition()) && (tile = world.func_175625_s(message.getPosition())) instanceof TileRiftJar) {
            ((TileRiftJar)tile).setRiftStability(message.getStability());
        }
    }

    protected void handleBiomeUpdatePacket(PacketBiomeUpdate message, MessageContext context) {
        BiomeUtil.setBiome((World)Minecraft.func_71410_x().field_71441_e, new BlockPos(message.getX(), 64, message.getZ()), Biome.func_150568_d((int)message.getBiome()));
    }

    protected void handleFXShieldPacket(PacketFXShield message, MessageContext context) {
        message.onMessage(message, context);
    }

    protected void handleImpulseBeamPacket(PacketImpulseBeam message, MessageContext context) {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.getEntityID());
        if (entity instanceof EntityLivingBase) {
            RenderEventHandler.onImpulseBeam((EntityLivingBase)entity, message.shouldStopBeam());
        }
    }

    protected void handleImpulseBurstPacket(PacketImpulseBurst message, MessageContext context) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity entity = world.func_73045_a(message.getEntityID());
        if (entity instanceof EntityLivingBase) {
            Vec3d t = message.getTarget();
            FXImpulseBeam beam = new FXImpulseBeam((World)world, (EntityLivingBase)entity, t.field_72450_a, t.field_72448_b, t.field_72449_c, 0.35f, 0.35f, 0.65f, message.getBurstNum() == 2 ? 20 : 15);
            beam.setAlphaFunc(b -> Float.valueOf(Math.min((float)(b.getMaxAge() - b.getAge()) / (float)b.getMaxAge(), 0.85f)));
            beam.setImpactTicks(9);
            beam.setSize(0.8f);
            ParticleEngine.addEffect((World)world, (Particle)beam);
        }
    }

    protected void handleImpulseRailgunPacket(PacketImpulseRailgunProjectile message, MessageContext context) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity entity = world.func_73045_a(message.getEntityID());
        if (entity instanceof EntityLivingBase) {
            Vec3d t = message.getTarget();
            FXImpulseBeam beam = new FXImpulseBeam((World)world, (EntityLivingBase)entity, t.field_72450_a, t.field_72448_b, t.field_72449_c, 0.35f, 0.35f, 0.65f, 40);
            beam.setAlphaFunc(b -> Float.valueOf(Math.min((float)(b.getMaxAge() - b.getAge()) / (float)b.getMaxAge(), 0.85f)));
            beam.setImpactTicks(10);
            beam.setSize(0.8f);
            ParticleEngine.addEffect((World)world, (Particle)beam);
        }
    }

    protected void handleLivingEquipmentChangePacket(PacketLivingEquipmentChange message, MessageContext context) {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.getEntityID());
        if (entity instanceof EntityLivingBase) {
            ClientEventHandler.onClientEquipmentChange(new ClientLivingEquipmentChangeEvent((EntityLivingBase)entity, message.getSlot(), message.getStack()));
        }
    }

    protected void handleBaubleChangePacket(PacketBaubleChange message, MessageContext context) {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.getEntityID());
        if (entity instanceof EntityLivingBase) {
            ClientEventHandler.onClientEquipmentChange(new ClientLivingEquipmentChangeEvent((EntityLivingBase)entity, EntityEquipmentSlot.HEAD, ItemStack.field_190927_a));
        }
    }

    protected void handleWispZapPacket(PacketWispZap message, MessageContext context) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity source = world.func_73045_a(message.getSourceID());
        Entity target = world.func_73045_a(message.getTargetID());
        if (source != null && target != null) {
            int packed = message.getZapColor();
            float r = (float)(packed >> 16 & 0xFF) / 255.0f;
            float g = (float)(packed >> 8 & 0xFF) / 255.0f;
            float b = (float)(packed & 0xFF) / 255.0f;
            FXDispatcher.INSTANCE.arcBolt(source.field_70165_t, source.field_70163_u, source.field_70161_v, target.field_70165_t, target.field_70163_u, target.field_70161_v, r, g, b, 0.6f);
        }
    }

    protected void handleFollowingOrbPacket(PacketFollowingOrb message, MessageContext context) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        int entityID = message.getEntityID();
        Entity e = world.func_73045_a(entityID);
        if (e != null) {
            int color = message.getColor();
            FXGenericP2ECustomSpeed orb = new FXGenericP2ECustomSpeed((World)world, message.getX(), message.getY(), message.getZ(), e, -0.2, 0.2);
            orb.func_70538_b((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
            orb.func_187114_a(200);
            orb.setAlphaF(new float[]{0.75f, 1.0f, 0.0f});
            orb.setGridSize(64);
            orb.setParticles(264, 8, 1);
            orb.setScale(new float[]{2.0f});
            orb.setLayer(1);
            orb.setLoop(true);
            orb.setNoClip(false);
            orb.setRotationSpeed(world.field_73012_v.nextFloat(), world.field_73012_v.nextBoolean() ? 1.0f : -1.0f);
            ParticleEngine.addEffect((World)world, (Particle)orb);
        }
    }

    protected void handleFlightStatePacket(PacketFlightState message, MessageContext context) {
        Entity e = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.getEntityID());
        if (e instanceof EntityPlayer) {
            ClientEventHandler.onFlightChange((EntityPlayer)e, message.isFlying());
        }
    }

    protected void handleBoostStatePacket(PacketBoostState message, MessageContext context) {
        Entity e = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.getEntityID());
        if (e instanceof EntityPlayer) {
            ClientEventHandler.onBoostChange((EntityPlayer)e, message.isBoosting());
        }
    }

    protected boolean isImpulseCannonStable(EntityLivingBase entity) {
        if (entity.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == TAItems.IMPULSE_CANNON) {
            return entity.func_184586_b(EnumHand.OFF_HAND).func_190926_b();
        }
        if (entity.func_184586_b(EnumHand.OFF_HAND).func_77973_b() == TAItems.IMPULSE_CANNON) {
            return entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b();
        }
        return false;
    }

    protected void handleRecoilPacket(PacketRecoil message, MessageContext context) {
        Entity e = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.getEntityID());
        if (e instanceof EntityLivingBase) {
            switch (message.getRecoilType()) {
                case IMPULSE_BURST: {
                    ClientEventHandler.onRecoil((EntityLivingBase)e, (entity, time) -> {
                        float mult = this.isImpulseCannonStable((EntityLivingBase)entity) ? 1.0f : 1.5f;
                        return Float.valueOf(-MathHelper.func_76134_b((float)((float)time.longValue() * (float)Math.PI / 11.0f)) * mult);
                    }, 12L);
                    break;
                }
                case IMPULSE_RAILGUN: {
                    ClientEventHandler.onRecoil((EntityLivingBase)e, (entity, time) -> {
                        float mult;
                        float f = mult = this.isImpulseCannonStable((EntityLivingBase)entity) ? 1.0f : 1.5f;
                        if (time < 4L) {
                            return Float.valueOf((float)(Math.pow((float)time.longValue() / 3.0f, 2.0) - 1.0) * 5.0f * mult);
                        }
                        return Float.valueOf(1.01875f * mult);
                    }, 16L);
                    break;
                }
            }
        }
    }

    protected void handleTerraformerWorkPacket(PacketTerraformerWork message, MessageContext context) {
        ResourceLocation activeBiome;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        BlockPos pos = new BlockPos(message.getX(), message.getY(), message.getZ());
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileArcaneTerraformer && (activeBiome = ((TileArcaneTerraformer)tile).getActiveBiome()) != null) {
            Biome biome = null;
            if (activeBiome.equals((Object)IBiomeSelector.RESET)) {
                biome = BiomeUtil.getNaturalBiome((World)world, pos, Biomes.field_76772_c);
                BiomeUtil.resetBiome((World)world, pos);
            } else {
                biome = (Biome)Biome.field_185377_q.func_82594_a((Object)activeBiome);
                BiomeUtil.setBiome((World)world, pos, biome);
            }
            int color = world.field_73012_v.nextInt(3);
            color = color == 0 ? biome.func_180627_b(pos) : (color == 1 ? biome.func_180625_c(pos) : (biome == Biomes.field_76778_j ? 16729344 : biome.func_185361_o() & 0x3F76E4));
            ThaumicAugmentation.proxy.getRenderHelper().renderTerraformerParticle((World)world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.6, (double)pos.func_177952_p() + 0.5, (double)(world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) / 8.0, 0.125, (double)(world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) / 8.0, color);
            ThaumicAugmentation.proxy.getRenderHelper().renderSpark((World)world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.25, (double)pos.func_177952_p() + 0.5, 5.0f, Aspect.ELDRITCH.getColor(), false);
        }
    }

    protected void handleEssentiaUpdatePacket(PacketEssentiaUpdate message, MessageContext context) {
        TileEntity tile;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world.func_175667_e(message.getPosition()) && (tile = world.func_175625_s(message.getPosition())) instanceof IEssentiaTube) {
            if (message.getEssentiaAmount() > 0 && message.getAspectID() >= 0 && message.getAspectID() < ModConfig.aspectOrder.size()) {
                ((IEssentiaTube)tile).setEssentiaDirect((Aspect)ModConfig.aspectOrder.get(message.getAspectID()), message.getEssentiaAmount());
            } else {
                ((IEssentiaTube)tile).setEssentiaDirect(null, 0);
            }
        }
    }

    @Override
    public IResourceReloadDispatcher getResourceReloadDispatcher() {
        return this.reloadDispatcher;
    }

    @Override
    public void initResourceReloadDispatcher() {
        IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
        if (manager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)manager).func_110542_a((IResourceManagerReloadListener)this.reloadDispatcher);
        } else {
            ThaumicAugmentation.getLogger().warn("Resource manager not reloadable, some models may break on resource reload");
        }
    }

    @Override
    public void preInit() {
        super.preInit();
        RenderingRegistry.registerEntityRenderingHandler(EntityDimensionalFracture.class, (IRenderFactory)new IRenderFactory<EntityDimensionalFracture>(){

            public Render<EntityDimensionalFracture> createRenderFor(RenderManager manager) {
                return new RenderDimensionalFracture(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityFocusShield.class, (IRenderFactory)new IRenderFactory<EntityFocusShield>(){

            public Render<EntityFocusShield> createRenderFor(RenderManager manager) {
                return new RenderFocusShield(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityAutocaster.class, (IRenderFactory)new IRenderFactory<EntityAutocaster>(){

            public Render<? super EntityAutocaster> createRenderFor(RenderManager manager) {
                return new RenderAutocaster(manager, false);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityAutocasterEldritch.class, (IRenderFactory)new IRenderFactory<EntityAutocasterEldritch>(){

            public Render<? super EntityAutocasterEldritch> createRenderFor(RenderManager manager) {
                return new RenderAutocaster(manager, true);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityTAEldritchGuardian.class, (IRenderFactory)new IRenderFactory<EntityTAEldritchGuardian>(){

            public Render<? super EntityTAEldritchGuardian> createRenderFor(RenderManager manager) {
                return new RenderTAEldritchGuardian(manager, new ModelEldritchGuardianFixed(), 0.5f);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityTAEldritchWarden.class, (IRenderFactory)new IRenderFactory<EntityTAEldritchWarden>(){

            public Render<? super EntityTAEldritchWarden> createRenderFor(RenderManager manager) {
                return new RenderTAEldritchGuardian(manager, new ModelEldritchGuardianFixed(), 0.6f);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityPrimalWisp.class, (IRenderFactory)new IRenderFactory<EntityPrimalWisp>(){

            public Render<? super EntityPrimalWisp> createRenderFor(RenderManager manager) {
                return new RenderPrimalWisp(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityTAEldritchGolem.class, (IRenderFactory)new IRenderFactory<EntityTAEldritchGolem>(){

            public Render<? super EntityTAEldritchGolem> createRenderFor(RenderManager manager) {
                return new RenderTAEldritchGolem(manager, new ModelEldritchGolem(), 0.5f);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityTAGolemOrb.class, (IRenderFactory)new IRenderFactory<EntityTAGolemOrb>(){

            public Render<? super EntityTAGolemOrb> createRenderFor(RenderManager manager) {
                return new RenderTAGolemOrb(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityCelestialObserver.class, (IRenderFactory)new IRenderFactory<EntityCelestialObserver>(){

            public Render<? super EntityCelestialObserver> createRenderFor(RenderManager manager) {
                return new RenderCelestialObserver(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityItemImportant.class, (IRenderFactory)new IRenderFactory<EntityItemImportant>(){

            public Render<? super EntityItemImportant> createRenderFor(RenderManager manager) {
                return new RenderItemImportant(manager, Minecraft.func_71410_x().func_175599_af());
            }
        });
        TAModelLoader loader = new TAModelLoader();
        loader.registerLoader(new ProviderModel.Loader(new ResourceLocation("ta_special", "models/item/strength_provider"), () -> CasterAugmentBuilder.getAllStrengthProviders(), stack -> ItemCustomCasterStrengthProvider.getProviderID(stack)));
        loader.registerLoader(new ProviderModel.Loader(new ResourceLocation("ta_special", "models/item/effect_provider"), () -> CasterAugmentBuilder.getAllEffectProviders(), stack -> ItemCustomCasterEffectProvider.getProviderID(stack)));
        loader.registerLoader(new CustomCasterAugmentModel.Loader());
        loader.registerLoader(new MorphicToolModel.Loader());
        loader.registerLoader(new BuiltInRendererModel.Loader());
        loader.registerLoader(new DirectionalRetexturingModel.Loader());
        loader.registerLoader(new GlassTubeModel.Loader());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)loader);
        if (TAConfig.enableBoosterKeybind.getValue().booleanValue()) {
            this.elytraBoost = new KeyBinding("thaumicaugmentation.key.elytra_boost", 57, "thaumicaugmentation.key.category");
            ClientRegistry.registerKeyBinding((KeyBinding)this.elytraBoost);
        }
        for (String s : TAConfig.morphicArmorExclusions.getValue()) {
            MorphicArmorExclusions.addExcludedModelPattern(s);
        }
    }

    @Override
    public void init() {
        super.init();
        ClientSoundHandler.init();
        ClientRegistry.bindTileEntitySpecialRenderer(TileVisRegenerator.class, new ListeningAnimatedTESR());
        ClientRegistry.bindTileEntitySpecialRenderer(TileWardedChest.class, new ListeningAnimatedTESR());
        ClientRegistry.bindTileEntitySpecialRenderer(TileImpetusDrainer.class, new ListeningAnimatedTESR());
        ClientRegistry.bindTileEntitySpecialRenderer(TileImpetusDiffuser.class, new ListeningAnimatedTESR());
        ClientRegistry.bindTileEntitySpecialRenderer(TileImpetusMatrix.class, new ListeningAnimatedTESR());
        ClientRegistry.bindTileEntitySpecialRenderer(TileRiftJar.class, (TileEntitySpecialRenderer)new RenderRiftJar());
        ClientRegistry.bindTileEntitySpecialRenderer(TileRiftMoverOutput.class, (TileEntitySpecialRenderer)new RenderRiftMoverOutput());
        ClientRegistry.bindTileEntitySpecialRenderer(TileVoidRechargePedestal.class, (TileEntitySpecialRenderer)new RenderVoidRechargePedestal());
        ClientRegistry.bindTileEntitySpecialRenderer(TileImpetusMirror.class, (TileEntitySpecialRenderer)new RenderImpetusMirror());
        ClientRegistry.bindTileEntitySpecialRenderer(TileRiftMonitor.class, (TileEntitySpecialRenderer)new RenderRiftMonitor());
        ClientRegistry.bindTileEntitySpecialRenderer(TileStabilityFieldGenerator.class, new ListeningAnimatedTESR());
        ClientRegistry.bindTileEntitySpecialRenderer(TileStarfieldGlass.class, (TileEntitySpecialRenderer)new RenderStarfieldGlass());
        ClientRegistry.bindTileEntitySpecialRenderer(TileObelisk.class, (TileEntitySpecialRenderer)new RenderObelisk());
        ClientRegistry.bindTileEntitySpecialRenderer(TileObeliskVisual.class, (TileEntitySpecialRenderer)new RenderObeliskVisual());
        ClientRegistry.bindTileEntitySpecialRenderer(TileAltar.class, (TileEntitySpecialRenderer)new RenderAltar());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEldritchLock.class, (TileEntitySpecialRenderer)new RenderEldritchLock());
        ClientRegistry.bindTileEntitySpecialRenderer(TileRiftBarrier.class, (TileEntitySpecialRenderer)new RenderRiftBarrier());
        ClientRegistry.bindTileEntitySpecialRenderer(TileGlassTube.class, (TileEntitySpecialRenderer)new RenderGlassTube());
        ClientProxy.registerItemColorHandlers();
        ClientProxy.registerBlockColorHandlers();
        for (RenderPlayer render : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
            render.func_177094_a((LayerRenderer)new RenderLayerHarness(render));
        }
        if (TAConfig.optimizedFluxRiftRenderer.getValue().booleanValue()) {
            RenderingRegistry.registerEntityRenderingHandler(EntityFluxRift.class, (Render)new RenderFluxRiftOptimized(Minecraft.func_71410_x().func_175598_ae()));
        }
    }

    @Override
    public void postInit() {
        super.postInit();
        TAShaderManager.init();
        if (TAShaderManager.shouldUseShaders()) {
            TAShaders.FRACTURE = TAShaderManager.registerShader(new ResourceLocation("thaumicaugmentation", "fracture"));
            TAShaders.EMPTINESS_SKY = TAShaderManager.registerShader(new ResourceLocation("thaumicaugmentation", "emptiness_sky"));
            TAShaders.FLUX_RIFT = TAShaderManager.registerShader(new ResourceLocation("thaumicaugmentation", "ender"));
            TAShaders.MIRROR = TAShaderManager.registerShader(new ResourceLocation("thaumicaugmentation", "mirror"));
            TAShaders.FLUX_RIFT_HUD = TAShaderManager.registerShader(new ResourceLocation("thaumicaugmentation", "ender_hud"));
        }
        ClientProxy.overrideArmorColorHandlers();
    }

    private static void registerItemColorHandlers() {
        ItemColors registerTo = Minecraft.func_71410_x().getItemColors();
        registerTo.func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (tintIndex == 1 && stack.func_77973_b() instanceof ICaster && ((ICaster)stack.func_77973_b()).getFocus(stack) != null) {
                    return ((ItemFocus)((ICaster)stack.func_77973_b()).getFocus(stack)).getFocusColor(((ICaster)stack.func_77973_b()).getFocusStack(stack));
                }
                if (tintIndex == 2 && stack.func_77973_b() instanceof IDyeableItem) {
                    return ((IDyeableItem)stack.func_77973_b()).getDyedColor(stack);
                }
                return -1;
            }
        }, new Item[]{TAItems.GAUNTLET});
        registerTo.func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (tintIndex == 1 && stack.func_77973_b() instanceof ItemKey) {
                    return ((ItemKey)stack.func_77973_b()).getKeyColor(stack);
                }
                return -1;
            }
        }, new Item[]{TAItems.KEY});
        IItemColor dye = new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (tintIndex == 1 && stack.func_77973_b() instanceof IDyeableItem) {
                    return ((IDyeableItem)stack.func_77973_b()).getDyedColor(stack);
                }
                return -1;
            }
        };
        registerTo.func_186730_a(dye, new Item[]{TAItems.VOID_BOOTS});
        registerTo.func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (tintIndex == 1 && stack.getCapability(CapabilityAugment.AUGMENT, null) instanceof ICustomCasterAugment) {
                    ICustomCasterAugment augment = (ICustomCasterAugment)stack.getCapability(CapabilityAugment.AUGMENT, null);
                    return CasterAugmentBuilder.getStrengthProvider(CasterAugmentBuilder.getStrengthProviderID(augment.getStrengthProvider())).calculateTintColor(augment);
                }
                return -1;
            }
        }, new Item[]{TAItems.AUGMENT_CUSTOM});
        registerTo.func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (tintIndex == 1 && stack.func_77973_b() instanceof ItemFractureLocator) {
                    return ((ItemFractureLocator)stack.func_77973_b()).getTintColor(stack);
                }
                return -1;
            }
        }, new Item[]{TAItems.FRACTURE_LOCATOR});
        registerTo.func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                ItemStack display = ((IMorphicTool)stack.getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null)).getDisplayStack();
                if (!display.func_190926_b()) {
                    return Minecraft.func_71410_x().getItemColors().func_186728_a(display, tintIndex);
                }
                return -1;
            }
        }, new Item[]{TAItems.MORPHIC_TOOL});
        registerTo.func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                IBiomeSelector selected = (IBiomeSelector)stack.getCapability(CapabilityBiomeSelector.BIOME_SELECTOR, null);
                if (tintIndex == 1 && selected != null) {
                    Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)selected.getBiomeID());
                    if (biome != null) {
                        return biome.func_180627_b(Minecraft.func_71410_x().field_71439_g.func_180425_c());
                    }
                    if (selected.getBiomeID().equals((Object)IBiomeSelector.RESET)) {
                        return 16716947;
                    }
                }
                return -1;
            }
        }, new Item[]{TAItems.BIOME_SELECTOR});
        registerTo.func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (tintIndex == 0 && stack.func_77973_b() instanceof ItemFocus) {
                    return ((ItemFocus)stack.func_77973_b()).getFocusColor(stack);
                }
                return -1;
            }
        }, new Item[]{TAItems.FOCUS_ANCIENT});
        registerTo.func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                IAugmentableItem item;
                if (tintIndex == 0 && (item = (IAugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)) != null) {
                    for (ItemStack augment : item.getAllAugments()) {
                        IAugment a = (IAugment)augment.getCapability(CapabilityAugment.AUGMENT, null);
                        if (!(a instanceof IElytraHarnessAugment) || !((IElytraHarnessAugment)a).isCosmetic()) continue;
                        return ((IElytraHarnessAugment)a).getCosmeticItemTint();
                    }
                }
                return -1;
            }
        }, new Item[]{TAItems.ELYTRA_HARNESS});
        registerTo.func_186731_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (tintIndex == 1) {
                    return 0x990099;
                }
                return -1;
            }
        }, new Block[]{TABlocks.IMPETUS_GATE});
        registerTo.func_186731_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (tintIndex == 0) {
                    return 0;
                }
                return -1;
            }
        }, new Block[]{TABlocks.IMPETUS_MATRIX});
        registerTo.func_186730_a(dye, new Item[]{TAItems.THAUMIUM_ROBES_HOOD});
        registerTo.func_186730_a(dye, new Item[]{TAItems.THAUMIUM_ROBES_CHESTPLATE});
        registerTo.func_186730_a(dye, new Item[]{TAItems.THAUMIUM_ROBES_LEGGINGS});
    }

    private static void registerBlockColorHandlers() {
        BlockColors registerTo = Minecraft.func_71410_x().func_184125_al();
        registerTo.func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos, int tintIndex) {
                ItemStack stack;
                IBiomeSelector item;
                IItemHandler inv;
                TileEntity tile;
                if (tintIndex == 0 && world != null && pos != null && (tile = world.func_175625_s(pos)) instanceof TileArcaneTerraformer && (inv = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null && (item = (IBiomeSelector)(stack = inv.getStackInSlot(0)).getCapability(CapabilityBiomeSelector.BIOME_SELECTOR, null)) != null) {
                    if (item.getBiomeID().equals((Object)IBiomeSelector.EMPTY)) {
                        return -1;
                    }
                    if (item.getBiomeID().equals((Object)IBiomeSelector.RESET)) {
                        return 16716947;
                    }
                    Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)item.getBiomeID());
                    if (biome != null) {
                        return biome.func_180627_b(pos);
                    }
                }
                return -1;
            }
        }, new Block[]{TABlocks.ARCANE_TERRAFORMER});
        registerTo.func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos, int tintIndex) {
                TileEntity tile;
                if (tintIndex == 1 && world != null && pos != null && (tile = world.func_175625_s(pos)) instanceof TileImpetusGate) {
                    if (tile.func_145831_w().func_175687_A(pos) > 0) {
                        return 0;
                    }
                    return 0x990099;
                }
                return -1;
            }
        }, new Block[]{TABlocks.IMPETUS_GATE});
        registerTo.func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos, int tintIndex) {
                IImpetusStorage s;
                TileEntity tile;
                if (world != null && pos != null && tintIndex == 0 && (tile = world.func_175625_s(pos)) instanceof TileImpetusMatrix && (s = (IImpetusStorage)tile.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null)) != null) {
                    int base = ImpetusAPI.getSuggestedColorForDescriptor(s);
                    double brightness = (Math.sin((double)Minecraft.func_71386_F() / 1000.0 + (double)pos.hashCode()) + 1.0) / 2.0;
                    int r = (int)((double)(base >> 16 & 0xFF) * brightness) << 16;
                    int g = (int)((double)(base >> 8 & 0xFF) * brightness) << 8;
                    int b = (int)((double)(base & 0xFF) * brightness);
                    return r | g | b;
                }
                return -1;
            }
        }, new Block[]{TABlocks.IMPETUS_MATRIX});
    }

    private static void overrideArmorColorHandlers() {
        Map registry = null;
        try {
            Field f = ItemColors.class.getDeclaredField("itemColorMap");
            f.setAccessible(true);
            registry = (Map)f.get(Minecraft.func_71410_x().getItemColors());
        }
        catch (Exception ex) {
            ThaumicAugmentation.getLogger().error("Could not access ItemColors#itemColorMap");
            throw new RuntimeException(ex);
        }
        HashMap<IRegistryDelegate, 26> toReplace = new HashMap<IRegistryDelegate, 26>();
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof ItemArmor)) continue;
            final IItemColor original = (IItemColor)registry.get(item.delegate);
            toReplace.put(item.delegate, new IItemColor(){

                public int func_186726_a(ItemStack stack, int tintIndex) {
                    if (MorphicArmorHelper.hasMorphicArmor(stack)) {
                        ItemStack armor = MorphicArmorHelper.getMorphicArmor(stack);
                        return Minecraft.func_71410_x().getItemColors().func_186728_a(armor, tintIndex);
                    }
                    return original != null ? original.func_186726_a(stack, tintIndex) : -1;
                }
            });
        }
        registry.putAll(toReplace);
    }
}

